/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi.parallel;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserAggregationUpdater;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.security.OverriddenAccessMode;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.NodeEntityWrappingNodeValue;
import org.neo4j.kernel.impl.util.PathWrappingPathValue;
import org.neo4j.kernel.impl.util.RelationshipEntityWrappingValue;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;
import org.neo4j.procedure.UserFunction;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.NodeIdReference;
import org.neo4j.values.virtual.PathReference;
import org.neo4j.values.virtual.VirtualValues;

@DbmsExtension(configurationCallback="configuration")
class ExecutionContextFunctionIT {
    @Inject
    private GraphDatabaseAPI db;

    ExecutionContextFunctionIT() {
    }

    @BeforeEach
    void beforeEach() throws KernelException {
        this.registerFunctions();
    }

    @ExtensionCallback
    void configuration(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.procedure_unrestricted, List.of("execution.context.test.function.doSomethingWithKernelTransaction"));
    }

    @Test
    void testUserFunctionAcceptingBasicType() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AnyValue result = this.invokeUserFunction(executionContext, "plus", new AnyValue[]{Values.intValue((int)1), Values.intValue((int)2)});
            Assertions.assertThat((Object)result).isEqualTo((Object)Values.intValue((int)3));
        });
    }

    @Test
    void testUserFunctionAcceptingNode() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AnyValue result = this.invokeUserFunction(executionContext, "nodeId", new AnyValue[]{VirtualValues.node((long)123L)});
            Assertions.assertThat((Object)result).isEqualTo((Object)Values.intValue((int)123));
        });
    }

    @Test
    void testUserFunctionAcceptingNodeList() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AnyValue result = this.invokeUserFunction(executionContext, "nodeIds", new AnyValue[]{VirtualValues.list((AnyValue[])new AnyValue[]{VirtualValues.node((long)123L), VirtualValues.node((long)456L)})});
            Assertions.assertThat((Object)result).isEqualTo((Object)VirtualValues.list((AnyValue[])new AnyValue[]{Values.intValue((int)123), Values.intValue((int)456)}));
        });
    }

    @Test
    void testUserFunctionAcceptingRelationship() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AnyValue result = this.invokeUserFunction(executionContext, "relationshipId", new AnyValue[]{VirtualValues.relationship((long)123L)});
            Assertions.assertThat((Object)result).isEqualTo((Object)Values.longValue((long)123L));
        });
    }

    @Test
    void testUserFunctionAcceptingRelationshipList() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AnyValue result = this.invokeUserFunction(executionContext, "relationshipIds", new AnyValue[]{VirtualValues.list((AnyValue[])new AnyValue[]{VirtualValues.relationship((long)123L), VirtualValues.relationship((long)456L)})});
            Assertions.assertThat((Object)result).isEqualTo((Object)VirtualValues.list((AnyValue[])new AnyValue[]{Values.intValue((int)123), Values.intValue((int)456)}));
        });
    }

    @Test
    void userFunctionShouldNotWrapExecutionContextNodes() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AnyValue result = this.invokeUserFunction(executionContext, "passThrough", new AnyValue[]{VirtualValues.node((long)123L)});
            Assertions.assertThat((Object)result).isNotInstanceOf(NodeEntityWrappingNodeValue.class);
        });
    }

    @Test
    void userFunctionShouldNotWrapExecutionContextRelationships() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AnyValue result = this.invokeUserFunction(executionContext, "passThrough", new AnyValue[]{VirtualValues.relationship((long)123L)});
            Assertions.assertThat((Object)result).isNotInstanceOf(RelationshipEntityWrappingValue.class);
        });
    }

    @Test
    void userFunctionShouldNotWrapExecutionContextPaths() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            PathReference path = VirtualValues.pathReference((long[])new long[]{11L, 22L}, (long[])new long[]{33L});
            AnyValue result = this.invokeUserFunction(executionContext, "passThrough", new AnyValue[]{path});
            Assertions.assertThat((Object)result).isNotInstanceOf(PathWrappingPathValue.class);
        });
    }

    @Test
    void userFunctionShouldNotHandleWrappedNodesAsReferences() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            Node originalWrappedNode = (Node)Mockito.mock(Node.class);
            AnyValue result = this.invokeUserFunction(executionContext, "passThrough", new AnyValue[]{ValueUtils.wrapNodeEntity((Node)originalWrappedNode)});
            Assertions.assertThat((Object)result).isInstanceOf(NodeEntityWrappingNodeValue.class);
            Node unwrappedNode = ((NodeEntityWrappingNodeValue)result).getEntity();
            Assertions.assertThat((Object)unwrappedNode).isEqualTo((Object)originalWrappedNode);
        });
    }

    @Test
    void userFunctionShouldNotHandleWrappedRelationshipsAsReferences() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            Relationship originalWrappedRelationship = (Relationship)Mockito.mock(Relationship.class);
            AnyValue result = this.invokeUserFunction(executionContext, "passThrough", new AnyValue[]{ValueUtils.wrapRelationshipEntity((Relationship)originalWrappedRelationship)});
            Assertions.assertThat((Object)result).isInstanceOf(RelationshipEntityWrappingValue.class);
            Relationship unwrappedRelationship = ((RelationshipEntityWrappingValue)result).getEntity();
            Assertions.assertThat((Object)unwrappedRelationship).isEqualTo((Object)originalWrappedRelationship);
        });
    }

    @Test
    void userFunctionShouldNotHandleWrappedPathsAsReferences() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            Path originalWrappedPath = (Path)Mockito.mock(Path.class);
            AnyValue result = this.invokeUserFunction(executionContext, "passThrough", new AnyValue[]{ValueUtils.wrapPath((Path)originalWrappedPath)});
            Assertions.assertThat((Object)result).isInstanceOf(PathWrappingPathValue.class);
            Path unwrappedPath = ((PathWrappingPathValue)result).path();
            Assertions.assertThat((Iterable)unwrappedPath).isSameAs((Object)originalWrappedPath);
        });
    }

    @Test
    void testUserFunctionUsingUnsupportedNodeOperation() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> Assertions.assertThatThrownBy(() -> this.invokeUserFunction(executionContext, "deleteNode", new AnyValue[]{VirtualValues.node((long)123L)})).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasMessageContaining("Operation unsupported during parallel query execution"));
    }

    @Test
    void testUserFunctionUsingUnsupportedRelationshipOperation() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> Assertions.assertThatThrownBy(() -> this.invokeUserFunction(executionContext, "deleteRelationship", new AnyValue[]{VirtualValues.relationship((long)123L)})).hasRootCauseInstanceOf(UnsupportedOperationException.class).hasMessageContaining("Operation unsupported during parallel query execution"));
    }

    @Test
    void testInjectingTransactionIntoUserFunctionAndGettingDataFromIt() throws ProcedureException {
        NodeIdReference nodeRef;
        String nodeId;
        try (Transaction tx = this.db.beginTx();){
            Node node = tx.createNode();
            nodeId = node.getElementId();
            nodeRef = VirtualValues.node((long)node.getId());
            tx.commit();
        }
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AnyValue result = this.invokeUserFunction(executionContext, "getNodeById", new AnyValue[]{Values.of((Object)nodeId)});
            Assertions.assertThat((Object)result).isEqualTo((Object)nodeRef);
        });
    }

    @Test
    void testKernelTransactionInjectionIntoUserFunction() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> Assertions.assertThatThrownBy(() -> this.invokeUserFunction(executionContext, "doSomethingWithKernelTransaction", new AnyValue[]{Values.intValue((int)1)})).hasRootCauseInstanceOf(ProcedureException.class).hasMessageContaining("There is no `Transaction` in the current procedure call context."));
    }

    @Test
    void testGraphDatabaseServiceInjectionIntoUserFunction() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AnyValue result = this.invokeUserFunction(executionContext, "databaseName", new AnyValue[0]);
            Assertions.assertThat((Object)result).isEqualTo((Object)Values.stringValue((String)this.db.databaseName()));
        });
    }

    @Test
    void testUserFunctionSecurityContext() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            AccessMode originalAccessMode = executionContext.securityContext().mode();
            Assertions.assertThat((Object)originalAccessMode).isEqualTo((Object)AccessMode.Static.FULL);
            AnyValue result = this.invokeUserFunction(executionContext, "accessMode", new AnyValue[0]);
            Assertions.assertThat((Object)result).isEqualTo((Object)Values.stringValue((String)new OverriddenAccessMode(originalAccessMode, AccessMode.Static.READ).name()));
            Assertions.assertThat((Object)executionContext.securityContext().mode()).isEqualTo((Object)AccessMode.Static.FULL);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void closedTransactionShouldBeDetectedOnUserFunctionInvocation() {
        try (Transaction transaction = this.db.beginTx();
             Statement statement = this.acquireStatement(transaction);
             ExecutionContext executionContext = this.createExecutionContext(transaction);){
            try {
                UserFunctionHandle handle = executionContext.procedures().functionGet(this.getName("plus"));
                transaction.rollback();
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> executionContext.procedures().functionCall(handle.id(), (AnyValue[])new Value[]{Values.intValue((int)1), Values.intValue((int)2)})).isInstanceOf(NotInTransactionException.class)).hasMessageContaining("This transaction has already been closed.");
            }
            finally {
                executionContext.complete();
            }
        }
    }

    @Test
    void testUserAggregationFunctionAcceptingBasicType() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            UserAggregationReducer sumFunction = this.prepareUserAggregationFunction(executionContext, "sum");
            UserAggregationUpdater updater = sumFunction.newUpdater();
            updater.update((AnyValue[])new Value[]{Values.intValue((int)1)});
            updater.update((AnyValue[])new Value[]{Values.intValue((int)2)});
            updater.update((AnyValue[])new Value[]{Values.intValue((int)3)});
            updater.applyUpdates();
            Assertions.assertThat((Object)sumFunction.result()).isEqualTo((Object)Values.intValue((int)6));
        });
    }

    @Test
    void testUserAggregationFunctionAcceptingNode() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            UserAggregationReducer sumFunction = this.prepareUserAggregationFunction(executionContext, "sumNodeIds");
            UserAggregationUpdater updater = sumFunction.newUpdater();
            updater.update(new AnyValue[]{VirtualValues.node((long)1L)});
            updater.update(new AnyValue[]{VirtualValues.node((long)2L)});
            updater.update(new AnyValue[]{VirtualValues.node((long)3L)});
            updater.applyUpdates();
            Assertions.assertThat((Object)sumFunction.result()).isEqualTo((Object)Values.intValue((int)6));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void closedTransactionShouldBeDetectedOnUserAggregationFunctionInvocation() {
        try (Transaction transaction = this.db.beginTx();
             Statement statement = this.acquireStatement(transaction);
             ExecutionContext executionContext = this.createExecutionContext(transaction);){
            try {
                UserFunctionHandle handle = executionContext.procedures().aggregationFunctionGet(this.getName("sum"));
                transaction.rollback();
                ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> executionContext.procedures().aggregationFunction(handle.id())).isInstanceOf(NotInTransactionException.class)).hasMessageContaining("This transaction has already been closed.");
            }
            finally {
                executionContext.complete();
            }
        }
    }

    @Test
    void testBuiltInFunction() throws ProcedureException {
        this.doWithExecutionContext((ExecutionContext executionContext) -> {
            UserFunctionHandle handle = executionContext.procedures().functionGet(new QualifiedName(List.of(), "date"));
            AnyValue result = executionContext.procedures().builtInFunctionCall(handle.id(), new AnyValue[]{Values.stringValue((String)"2022-10-07")});
            Assertions.assertThat((Object)result).isEqualTo((Object)DateValue.date((LocalDate)LocalDate.parse("2022-10-07")));
        });
    }

    @Test
    void testRealClockTemporalFunction() throws ProcedureException {
        this.doWithExecutionContext((KernelTransactionImplementation ktx, ExecutionContext executionContext) -> {
            ZonedDateTime referenceDateTime = ZonedDateTime.now();
            UserFunctionHandle handle = executionContext.procedures().functionGet(new QualifiedName(List.of("datetime"), "realtime"));
            AnyValue result = executionContext.procedures().builtInFunctionCall(handle.id(), new AnyValue[0]);
            Assertions.assertThat((Object)result).isInstanceOf(DateTimeValue.class);
            Assertions.assertThat((ZonedDateTime)((ZonedDateTime)((DateTimeValue)result).asObjectCopy())).isAfterOrEqualTo(referenceDateTime);
        });
    }

    @Test
    void testTransactionClockTemporalFunction() throws ProcedureException {
        this.doWithExecutionContext((KernelTransactionImplementation ktx, ExecutionContext executionContext) -> {
            UserFunctionHandle handle = executionContext.procedures().functionGet(new QualifiedName(List.of("datetime"), "transaction"));
            AnyValue result = executionContext.procedures().builtInFunctionCall(handle.id(), new AnyValue[0]);
            Assertions.assertThat((Object)result).isEqualTo((Object)DateTimeValue.datetime((ZonedDateTime)ZonedDateTime.now(ktx.clocks().transactionClock())));
        });
    }

    @Test
    void testStatementClockTemporalFunction() throws ProcedureException {
        this.doWithExecutionContext((KernelTransactionImplementation ktx, ExecutionContext executionContext) -> {
            UserFunctionHandle handle = executionContext.procedures().functionGet(new QualifiedName(List.of("datetime"), "statement"));
            AnyValue result = executionContext.procedures().builtInFunctionCall(handle.id(), new AnyValue[0]);
            Assertions.assertThat((Object)result).isEqualTo((Object)DateTimeValue.datetime((ZonedDateTime)ZonedDateTime.now(ktx.clocks().statementClock())));
        });
    }

    @Test
    void testDefaultClockTemporalFunction() throws ProcedureException {
        this.doWithExecutionContext((KernelTransactionImplementation ktx, ExecutionContext executionContext) -> {
            UserFunctionHandle handle = executionContext.procedures().functionGet(new QualifiedName(List.of(), "datetime"));
            AnyValue result = executionContext.procedures().builtInFunctionCall(handle.id(), new AnyValue[0]);
            Assertions.assertThat((Object)result).isEqualTo((Object)DateTimeValue.datetime((ZonedDateTime)ZonedDateTime.now(ktx.clocks().statementClock())));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWithExecutionContext(ExecutionContextLogic executionContextLogic) throws ProcedureException {
        try (Transaction transaction = this.db.beginTx();
             Statement statement = this.acquireStatement(transaction);
             ExecutionContext executionContext = this.createExecutionContext(transaction);){
            try {
                executionContextLogic.doWithExecutionContext(executionContext);
            }
            finally {
                executionContext.complete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWithExecutionContext(ExecutionContextLogic2 executionContextLogic) throws ProcedureException {
        try (Transaction transaction = this.db.beginTx();
             Statement statement = this.acquireStatement(transaction);
             ExecutionContext executionContext = this.createExecutionContext(transaction);){
            try {
                executionContextLogic.doWithExecutionContext((KernelTransactionImplementation)((InternalTransaction)transaction).kernelTransaction(), executionContext);
            }
            finally {
                executionContext.complete();
            }
        }
    }

    private Statement acquireStatement(Transaction transaction) {
        return ((InternalTransaction)transaction).kernelTransaction().acquireStatement();
    }

    private AnyValue invokeUserFunction(ExecutionContext executionContext, String name, AnyValue ... args) throws ProcedureException {
        UserFunctionHandle handle = executionContext.procedures().functionGet(this.getName(name));
        return executionContext.procedures().functionCall(handle.id(), args);
    }

    private UserAggregationReducer prepareUserAggregationFunction(ExecutionContext executionContext, String name) throws ProcedureException {
        UserFunctionHandle handle = executionContext.procedures().aggregationFunctionGet(this.getName(name));
        return executionContext.procedures().aggregationFunction(handle.id());
    }

    private QualifiedName getName(String name) {
        return new QualifiedName(List.of("execution", "context", "test", "function"), name);
    }

    private ExecutionContext createExecutionContext(Transaction transaction) {
        return ((InternalTransaction)transaction).kernelTransaction().createExecutionContext();
    }

    private void registerFunctions() throws KernelException {
        GlobalProcedures globalProcedures = (GlobalProcedures)this.db.getDependencyResolver().resolveDependency(GlobalProcedures.class);
        globalProcedures.registerFunction(BasicTestFunctions.class);
        globalProcedures.registerFunction(FunctionInjectingTransaction.class);
        globalProcedures.registerFunction(FunctionInjectingKernelTransaction.class);
        globalProcedures.registerFunction(FunctionInjectingDatabase.class);
        globalProcedures.registerFunction(FunctionInjectingSecurityContext.class);
        globalProcedures.registerAggregationFunction(BasicTestAggregationFunctions.class);
    }

    private static interface ExecutionContextLogic {
        public void doWithExecutionContext(ExecutionContext var1) throws ProcedureException;
    }

    private static interface ExecutionContextLogic2 {
        public void doWithExecutionContext(KernelTransactionImplementation var1, ExecutionContext var2) throws ProcedureException;
    }

    public static class BasicTestFunctions {
        @UserFunction(value="execution.context.test.function.plus")
        public long plus(@Name(value="value1") long value1, @Name(value="value2") long value2) {
            return value1 + value2;
        }

        @UserFunction(value="execution.context.test.function.nodeId")
        public long nodeId(@Name(value="value") Node value) {
            return value.getId();
        }

        @UserFunction(value="execution.context.test.function.relationshipId")
        public long relationshipId(@Name(value="value") Relationship value) {
            return value.getId();
        }

        @UserFunction(value="execution.context.test.function.nodeIds")
        public List<Long> nodeIds(@Name(value="value") List<Node> value) {
            return value.stream().map(Entity::getId).collect(Collectors.toList());
        }

        @UserFunction(value="execution.context.test.function.relationshipIds")
        public List<Long> relationshipIds(@Name(value="value") List<Relationship> value) {
            return value.stream().map(Entity::getId).collect(Collectors.toList());
        }

        @UserFunction(value="execution.context.test.function.deleteNode")
        public Object deleteNode(@Name(value="value") Node value) {
            value.delete();
            return null;
        }

        @UserFunction(value="execution.context.test.function.deleteRelationship")
        public Object deleteRelationship(@Name(value="value") Relationship value) {
            value.delete();
            return null;
        }

        @UserFunction(value="execution.context.test.function.passThrough")
        public Object passThrough(@Name(value="value") Object value) {
            return value;
        }
    }

    public static class FunctionInjectingTransaction {
        @Context
        public Transaction transaction;

        @UserFunction(value="execution.context.test.function.getNodeById")
        public Node getNodeById(@Name(value="elementId") String elementId) {
            return this.transaction.getNodeByElementId(elementId);
        }
    }

    public static class FunctionInjectingKernelTransaction {
        @Context
        public KernelTransaction kernelTransaction;

        @UserFunction(value="execution.context.test.function.doSomethingWithKernelTransaction")
        public Object doSomethingWithKernelTransaction(@Name(value="value") Object value) {
            return value;
        }
    }

    public static class FunctionInjectingDatabase {
        @Context
        public GraphDatabaseService db;

        @UserFunction(value="execution.context.test.function.databaseName")
        public String databaseName() {
            return this.db.databaseName();
        }
    }

    public static class FunctionInjectingSecurityContext {
        @Context
        public SecurityContext securityContext;

        @UserFunction(value="execution.context.test.function.accessMode")
        public String accessMode() {
            return this.securityContext.mode().name();
        }
    }

    public static class BasicTestAggregationFunctions {
        @UserAggregationFunction(value="execution.context.test.function.sum")
        public SumAggregationFunction sum() {
            return new SumAggregationFunction();
        }

        @UserAggregationFunction(value="execution.context.test.function.sumNodeIds")
        public SumNodeIdsAggregationFunction sumNodeIds() {
            return new SumNodeIdsAggregationFunction();
        }
    }

    public static class SumNodeIdsAggregationFunction {
        private long sum = 0L;

        @UserAggregationUpdate
        public void update(@Name(value="in") Node in) {
            this.sum += in.getId();
        }

        @UserAggregationResult
        public long result() {
            return this.sum;
        }
    }

    public static class SumAggregationFunction {
        private long sum = 0L;

        @UserAggregationUpdate
        public void update(@Name(value="in") long in) {
            this.sum += in;
        }

        @UserAggregationResult
        public long result() {
            return this.sum;
        }
    }
}

