/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.common.ProgressReporter;
import org.neo4j.configuration.Config;
import org.neo4j.internal.batchimport.BatchImporterFactory;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.storemigration.RecordStorageMigrator;
import org.neo4j.kernel.impl.transaction.log.EmptyLogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionIdentifier;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@PageCacheExtension
@Neo4jLayoutExtension
class RecordStoreMigratorTest {
    @Inject
    private FileSystemAbstraction filesystem;
    @Inject
    private PageCache pageCache;
    @Inject
    private Neo4jLayout neo4jLayout;
    @Inject
    private DatabaseLayout databaseLayout;
    private JobScheduler jobScheduler;
    private final BatchImporterFactory batchImporterFactory = BatchImporterFactory.withHighestPriority();
    private final CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)new DefaultPageCacheTracer(), EmptyVersionContextSupplier.EMPTY);

    RecordStoreMigratorTest() {
    }

    @BeforeEach
    void setUp() {
        Assumptions.assumeThat((Object)this.databaseLayout).isInstanceOf(RecordDatabaseLayout.class);
        this.jobScheduler = new ThreadPoolJobScheduler();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    void shouldNotMigrateFilesForVersionsWithSameCapability() throws Exception {
        RecordStorageMigrator migrator = this.newStoreMigrator();
        this.filesystem.write(this.databaseLayout.pathForExistsMarker()).close();
        MyProgressReporter progressReporter = new MyProgressReporter();
        RecordDatabaseLayout migrationLayout = RecordDatabaseLayout.of((Neo4jLayout)this.neo4jLayout, (String)"migrationDir");
        this.filesystem.mkdirs(migrationLayout.databaseDirectory());
        RecordFormats format = Standard.LATEST_RECORD_FORMATS;
        this.filesystem.write(migrationLayout.pathForExistsMarker()).close();
        MetaDataStore.FieldAccess fieldAccess = MetaDataStore.getFieldAccess((PageCache)this.pageCache, (Path)migrationLayout.metadataStore(), (String)migrationLayout.getDatabaseName(), (CursorContext)CursorContext.NULL_CONTEXT);
        fieldAccess.writeStoreId(StoreId.generateNew((String)"record", (String)format.getFormatFamily().name(), (int)format.majorVersion(), (int)format.minorVersion()));
        StoreVersionIdentifier storeVersionIdentifier = new StoreVersionIdentifier("record", format.getFormatFamily().name(), format.majorVersion(), format.minorVersion());
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.defaultStorageEngine();
        migrator.migrate(this.databaseLayout, (DatabaseLayout)migrationLayout, (ProgressReporter)progressReporter, (StoreVersion)storageEngineFactory.versionInformation(storeVersionIdentifier).orElseThrow(), (StoreVersion)storageEngineFactory.versionInformation(storeVersionIdentifier).orElseThrow(), IndexImporterFactory.EMPTY, (LogTailMetadata)new EmptyLogTailMetadata(Config.defaults()));
        Assertions.assertThat((boolean)progressReporter.started).isFalse();
    }

    private RecordStorageMigrator newStoreMigrator() {
        return new RecordStorageMigrator(this.filesystem, this.pageCache, PageCacheTracer.NULL, Config.defaults(), (LogService)NullLogService.getInstance(), this.jobScheduler, this.contextFactory, this.batchImporterFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE, false);
    }

    private static class MyProgressReporter
    implements ProgressReporter {
        public boolean started;

        private MyProgressReporter() {
        }

        public void start(long max) {
            this.started = true;
        }

        public void progress(long add) {
        }

        public void completed() {
        }
    }
}

