/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.KernelVersionRepository;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class CheckpointKernelVersionIT {
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private KernelVersionRepository kernelVersionRepository;
    @Inject
    private LogFiles logFiles;

    @Test
    void checkPointRecordContainsDatabaseKernelVersion() throws IOException {
        this.kernelVersionRepository.setKernelVersion(KernelVersion.V5_7);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Forced " + this.kernelVersionRepository.kernelVersion()));
        Stream checkpoints = this.logFiles.getCheckpointFile().reachableCheckpoints().stream();
        Stream<KernelVersion> kernelVersions = checkpoints.map(KernelVersionProvider::kernelVersion);
        ((ListAssert)Assertions.assertThat(kernelVersions).as("kernel versions from checkpoints", new Object[0])).containsExactly((Object[])new KernelVersion[]{this.kernelVersionRepository.kernelVersion()});
    }

    @Test
    void checkPointInLegacy5_0Format() throws IOException {
        this.kernelVersionRepository.setKernelVersion(KernelVersion.V5_0);
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Legacy format."));
        CheckpointInfo checkpoint = (CheckpointInfo)this.logFiles.getCheckpointFile().findLatestCheckpoint().orElseThrow();
        org.junit.jupiter.api.Assertions.assertEquals((Object)KernelVersion.V5_0, (Object)checkpoint.kernelVersion());
        org.junit.jupiter.api.Assertions.assertEquals((long)-1L, (long)checkpoint.transactionId().consensusIndex());
    }
}

