/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckpointAppender;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;

@DbmsExtension(configurationCallback="configure")
public class CheckpointLogFileRotationIT {
    static final long ROTATION_THRESHOLD = ByteUnit.kibiBytes((long)1L);
    @Inject
    private GraphDatabaseService database;
    @Inject
    LogFiles logFiles;

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_rotation_threshold, (Object)ROTATION_THRESHOLD).setConfig(GraphDatabaseInternalSettings.checkpoint_logical_log_keep_threshold, (Object)100).setConfig(GraphDatabaseSettings.preallocate_logical_logs, (Object)this.preallocateLogs());
    }

    @Test
    void rotateCheckpointLogFiles() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        TransactionId transactionId = new TransactionId(100L, 101, 102L, 103L);
        String reason = "checkpoint for rotation test";
        for (int i = 0; i < 105; ++i) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, LatestVersions.LATEST_KERNEL_VERSION, logPosition, Instant.now(), reason);
        }
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(27);
        for (Object fileWithCheckpoints : matchedFiles) {
            Assertions.assertThat((Path)fileWithCheckpoints).satisfies((Condition)new Condition<Path>(){

                public boolean matches(Path file) {
                    long length = file.toFile().length();
                    return length < ROTATION_THRESHOLD + 232L;
                }
            });
        }
    }

    @Test
    void doNotRotateWhileCheckpointsAreFitting() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        TransactionId transactionId = new TransactionId(100L, 101, 102L, 103L);
        String reason = "checkpoint for rotation test";
        int i = LogFormat.CURRENT_FORMAT_LOG_HEADER_SIZE + 232;
        while ((long)i < ROTATION_THRESHOLD) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, LatestVersions.LATEST_KERNEL_VERSION, logPosition, Instant.now(), reason);
            i += 232;
        }
        Assertions.assertThat((Object[])checkpointFile.getDetachedCheckpointFiles()).hasSize(1);
    }

    @Test
    void afterRotationNewFileHaveHeader() throws IOException {
        CheckpointFile checkpointFile = this.logFiles.getCheckpointFile();
        CheckpointAppender checkpointAppender = checkpointFile.getCheckpointAppender();
        LogPosition logPosition = new LogPosition(1000L, 12345L);
        TransactionId transactionId = new TransactionId(100L, 101, 102L, 103L);
        String reason = "checkpoint for rotation test";
        int i = LogFormat.CURRENT_FORMAT_LOG_HEADER_SIZE;
        while ((long)i < ROTATION_THRESHOLD) {
            checkpointAppender.checkPoint(LogCheckPointEvent.NULL, transactionId, LatestVersions.LATEST_KERNEL_VERSION, logPosition, Instant.now(), reason);
            i += 232;
        }
        Object[] matchedFiles = checkpointFile.getDetachedCheckpointFiles();
        Assertions.assertThat((Object[])matchedFiles).hasSize(2);
        boolean headerFileFound = false;
        for (Object matchedFile : matchedFiles) {
            if (checkpointFile.getDetachedCheckpointLogFileVersion((Path)matchedFile) != 1L) continue;
            Assertions.assertThat((File)matchedFile.toFile()).hasSize(this.expectedNewFileSize());
            headerFileFound = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)headerFileFound);
    }

    protected long expectedNewFileSize() {
        return LogFormat.CURRENT_FORMAT_LOG_HEADER_SIZE;
    }

    protected boolean preallocateLogs() {
        return false;
    }
}

