/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryDetachedCheckpointV4_2;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class DetachedCheckpointLogEntrySerializerV42Test {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    private final CommandReaderFactory commandReader = new TestCommandReaderFactory();
    private final LogPositionMarker positionMarker = new LogPositionMarker();

    DetachedCheckpointLogEntrySerializerV42Test() {
    }

    @Test
    void parseDetachedCheckpointRecord() throws IOException {
        KernelVersion version = KernelVersion.V4_3_D4;
        StoreId storeId = new StoreId(4L, 5L, "legacy", "legacy", 1, 1);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        int checkpointMillis = 3;
        String checkpointDescription = "checkpoint";
        byte[] bytes = Arrays.copyOf(checkpointDescription.getBytes(), 120);
        LogEntryDetachedCheckpointV4_2 checkpoint = new LogEntryDetachedCheckpointV4_2(version, new LogPosition(1L, 2L), (long)checkpointMillis, storeId, checkpointDescription);
        channel.putLong(checkpoint.getLogPosition().getLogVersion()).putLong(checkpoint.getLogPosition().getByteOffset()).putLong((long)checkpointMillis).putLong(storeId.getCreationTime()).putLong(storeId.getRandom()).putLong(123L).putLong(0L).putLong(0L).putShort((short)checkpointDescription.getBytes().length).put(bytes, bytes.length);
        channel.putChecksum();
        LogEntrySerializer checkpointParser = LogEntrySerializationSets.serializationSet((KernelVersion)version, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)8);
        LogEntry logEntry = checkpointParser.parse(version, (ReadableChannel)channel, this.positionMarker, this.commandReader);
        Assertions.assertEquals((Object)checkpoint, (Object)logEntry);
    }

    @Test
    void writeAndParseCheckpointKernelVersion() throws IOException {
        PhysicalFlushableLogChannel writeChannel;
        StoreChannel storeChannel;
        Path path = this.directory.createFile("a");
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.BIG_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            storeChannel = this.fs.write(path);
            writeChannel = new PhysicalFlushableLogChannel(storeChannel, (ScopedBuffer)buffer);
            try {
                DetachedCheckpointLogEntrySerializerV42Test.writeCheckpoint((WritableChannel)writeChannel, KernelVersion.V4_4, StringUtils.repeat((String)"b", (int)1024));
            }
            finally {
                writeChannel.close();
            }
        }
        buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try {
            storeChannel = this.fs.open(path, Set.of(StandardOpenOption.WRITE, StandardOpenOption.APPEND));
            writeChannel = new PhysicalFlushableLogChannel(storeChannel, (ScopedBuffer)buffer);
            try {
                DetachedCheckpointLogEntrySerializerV42Test.writeCheckpoint((WritableChannel)writeChannel, KernelVersion.V5_0, StringUtils.repeat((String)"c", (int)1024));
            }
            finally {
                writeChannel.close();
            }
        }
        finally {
            buffer.close();
        }
        VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.BINARY_VERSIONS);
        try (ReadAheadLogChannel readChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), -1L, -1, path, ChannelNativeAccessor.EMPTY_ACCESSOR, DatabaseTracer.NULL), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Assertions.assertEquals((Object)KernelVersion.V4_4, (Object)this.readCheckpoint(entryReader, readChannel).kernelVersion());
            Assertions.assertEquals((Object)KernelVersion.V5_0, (Object)this.readCheckpoint(entryReader, readChannel).kernelVersion());
        }
    }

    private LogEntryDetachedCheckpointV4_2 readCheckpoint(VersionAwareLogEntryReader entryReader, ReadAheadLogChannel readChannel) throws IOException {
        return (LogEntryDetachedCheckpointV4_2)entryReader.readLogEntry((ReadableLogPositionAwareChannel)readChannel);
    }

    private static void writeCheckpoint(WritableChannel channel, KernelVersion kernelVersion, String reason) throws IOException {
        StoreId storeId = new StoreId(4L, 5L, "engine-1", "format-1", 1, 2);
        LogPosition logPosition = new LogPosition(1L, 2L);
        DetachedCheckpointLogEntrySerializerV42Test.writeCheckPointEntry(channel, kernelVersion, logPosition, Instant.ofEpochMilli(1L), storeId, reason);
    }

    private static void writeCheckPointEntry(WritableChannel channel, KernelVersion kernelVersion, LogPosition logPosition, Instant checkpointTime, StoreId storeId, String reason) throws IOException {
        channel.beginChecksum();
        DetachedCheckpointLogEntrySerializerV42Test.writeLogEntryHeader(kernelVersion, (byte)8, channel);
        byte[] reasonBytes = reason.getBytes();
        short length = Numbers.safeCastIntToShort((int)Math.min(reasonBytes.length, 120));
        byte[] descriptionBytes = new byte[120];
        System.arraycopy(reasonBytes, 0, descriptionBytes, 0, length);
        channel.putLong(logPosition.getLogVersion()).putLong(logPosition.getByteOffset()).putLong(checkpointTime.toEpochMilli()).putLong(storeId.getCreationTime()).putLong(storeId.getRandom()).putLong(123L).putLong(0L).putLong(0L);
        channel.putShort(length).put(descriptionBytes, descriptionBytes.length);
        channel.putChecksum();
    }

    private static void writeLogEntryHeader(KernelVersion kernelVersion, byte type, WritableChannel channel) throws IOException {
        channel.put(kernelVersion.version()).put(type);
    }
}

