/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.api.TestCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableLogChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializationSets;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySerializer;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkEnd;
import org.neo4j.kernel.impl.transaction.log.entry.v57.LogEntryChunkStart;
import org.neo4j.kernel.impl.transaction.log.files.ChannelNativeAccessor;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.LatestVersions;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class LogEntrySerializerDispatcherTest {
    private final KernelVersion version = LatestVersions.LATEST_KERNEL_VERSION;
    private final CommandReaderFactory commandReader = new TestCommandReaderFactory();
    private final LogPositionMarker marker = new LogPositionMarker();
    private final LogPosition position = new LogPosition(0L, 25L);
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;

    LogEntrySerializerDispatcherTest() {
    }

    @Test
    void writeAndParseChunksEntries() throws IOException {
        try (HeapScopedBuffer buffer = new HeapScopedBuffer((int)ByteUnit.kibiBytes((long)1L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
            Path path = this.directory.createFile("a");
            StoreChannel storeChannel = this.fs.write(path);
            try (PhysicalFlushableLogChannel writeChannel = new PhysicalFlushableLogChannel(storeChannel, (ScopedBuffer)buffer);){
                LogEntryWriter entryWriter = new LogEntryWriter((WritableChannel)writeChannel, LatestVersions.BINARY_VERSIONS);
                entryWriter.writeStartEntry(LatestVersions.LATEST_KERNEL_VERSION, 1L, 2L, 3, ArrayUtils.EMPTY_BYTE_ARRAY);
                entryWriter.writeChunkEndEntry(LatestVersions.LATEST_KERNEL_VERSION, 17L, 13L);
                entryWriter.writeChunkStartEntry(LatestVersions.LATEST_KERNEL_VERSION, 11L, 13L, new LogPosition(14L, 15L));
                entryWriter.writeCommitEntry(LatestVersions.LATEST_KERNEL_VERSION, 7L, 8L);
            }
            VersionAwareLogEntryReader entryReader = new VersionAwareLogEntryReader(StorageEngineFactory.defaultStorageEngine().commandReaderFactory(), LatestVersions.BINARY_VERSIONS);
            try (ReadAheadLogChannel readChannel = new ReadAheadLogChannel((LogVersionedStoreChannel)new PhysicalLogVersionedStoreChannel(this.fs.read(path), 1L, -1, path, ChannelNativeAccessor.EMPTY_ACCESSOR, DatabaseTracer.NULL), LogVersionBridge.NO_MORE_CHANNELS, (MemoryTracker)EmptyMemoryTracker.INSTANCE);){
                LogEntry startEntry = entryReader.readLogEntry((ReadableLogPositionAwareChannel)readChannel);
                LogEntry chunkEnd = entryReader.readLogEntry((ReadableLogPositionAwareChannel)readChannel);
                LogEntry chunkStart = entryReader.readLogEntry((ReadableLogPositionAwareChannel)readChannel);
                LogEntry commitEnd = entryReader.readLogEntry((ReadableLogPositionAwareChannel)readChannel);
                Assertions.assertThat((Object)startEntry).isInstanceOf(LogEntryStart.class);
                Assertions.assertThat((Object)commitEnd).isInstanceOf(LogEntryCommit.class);
                Assertions.assertThat((Object)chunkEnd).isInstanceOf(LogEntryChunkEnd.class);
                LogEntryChunkEnd chunkEndEntry = (LogEntryChunkEnd)chunkEnd;
                org.junit.jupiter.api.Assertions.assertEquals((long)17L, (long)chunkEndEntry.getTransactionId());
                org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)chunkEndEntry.getChunkId());
                Assertions.assertThat((Object)chunkStart).isInstanceOf(LogEntryChunkStart.class);
                LogEntryChunkStart chunkStartEntry = (LogEntryChunkStart)chunkStart;
                org.junit.jupiter.api.Assertions.assertEquals((long)11L, (long)chunkStartEntry.getTimeWritten());
                org.junit.jupiter.api.Assertions.assertEquals((long)13L, (long)chunkStartEntry.getChunkId());
            }
        }
    }

    @Test
    void parseStartEntry() throws IOException {
        LogEntryStart start = new LogEntryStart(this.version, 1L, 2L, 3, new byte[]{4}, this.position);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.putInt(start.getPreviousChecksum());
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
        channel.getCurrentLogPosition(this.marker);
        LogEntrySerializer parser = LogEntrySerializationSets.serializationSet((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)1);
        LogEntry logEntry = parser.parse(this.version, (ReadableChannel)channel, this.marker, this.commandReader);
        org.junit.jupiter.api.Assertions.assertEquals((Object)start, (Object)logEntry);
    }

    @Test
    void parseCommitEntry() throws IOException {
        LogEntryCommit commit = new LogEntryCommit(LatestVersions.LATEST_KERNEL_VERSION, 42L, 21L, -361070784);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.putChecksum();
        channel.getCurrentLogPosition(this.marker);
        LogEntrySerializer parser = LogEntrySerializationSets.serializationSet((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)5);
        LogEntry logEntry = parser.parse(this.version, (ReadableChannel)channel, this.marker, this.commandReader);
        org.junit.jupiter.api.Assertions.assertEquals((Object)commit, (Object)logEntry);
    }

    @Test
    void shouldParserCommandsUsingAGivenFactory() throws IOException {
        TestCommand testCommand = new TestCommand(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        LogEntryCommand command = new LogEntryCommand((StorageCommand)testCommand);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        testCommand.serialize((WritableChannel)channel);
        channel.getCurrentLogPosition(this.marker);
        LogEntrySerializer parser = LogEntrySerializationSets.serializationSet((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)3);
        LogEntry logEntry = parser.parse(this.version, (ReadableChannel)channel, this.marker, this.commandReader);
        org.junit.jupiter.api.Assertions.assertEquals((Object)command, (Object)logEntry);
    }

    @Test
    void shouldThrowWhenParsingUnknownEntry() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> LogEntrySerializationSets.serializationSet((KernelVersion)LatestVersions.LATEST_KERNEL_VERSION, (BinarySupportedKernelVersions)LatestVersions.BINARY_VERSIONS).select((byte)42));
    }
}

