/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state.storeview;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.EmptyVersionContextSupplier;
import org.neo4j.io.pagecache.monitoring.PageCacheCounters;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.state.storeview.FullScanStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.NodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.RelationshipStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.TestPropertyScanConsumer;
import org.neo4j.kernel.impl.transaction.state.storeview.TestTokenScanConsumer;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.lock.Lock;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.ReadableStorageEngine;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.test.PageCacheTracerAssertions;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.values.storable.Values;

@DbmsExtension
class FullScanStoreViewTest {
    private static final CursorContextFactory CONTEXT_FACTORY = new CursorContextFactory(PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY);
    @Inject
    private GraphDatabaseAPI graphDb;
    @Inject
    private StorageEngine storageEngine;
    @Inject
    private CheckPointer checkPointer;
    @Inject
    private JobScheduler jobScheduler;
    private final Map<Long, Lock> lockMocks = new HashMap<Long, Lock>();
    private final Label label = Label.label((String)"Person");
    private final RelationshipType relationshipType = RelationshipType.withName((String)"Knows");
    private FullScanStoreView storeView;
    private int labelId;
    private int relTypeId;
    private int propertyKeyId;
    private int relPropertyKeyId;
    private Node alistair;
    private Node stefan;
    private LockService locks;
    private Relationship aKnowsS;
    private Relationship sKnowsA;
    private StorageReader reader;

    FullScanStoreViewTest() {
    }

    @BeforeEach
    void before() throws KernelException {
        this.createAlistairAndStefanNodes();
        this.getOrCreateIds();
        this.jobScheduler = JobSchedulerFactory.createInitialisedScheduler();
        this.locks = (LockService)Mockito.mock(LockService.class);
        Mockito.when((Object)this.locks.acquireNodeLock(ArgumentMatchers.anyLong(), (LockType)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Long nodeId = (Long)invocation.getArgument(0);
            return this.lockMocks.computeIfAbsent(nodeId, k -> (Lock)Mockito.mock(Lock.class));
        });
        Mockito.when((Object)this.locks.acquireRelationshipLock(ArgumentMatchers.anyLong(), (LockType)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Long nodeId = (Long)invocation.getArgument(0);
            return this.lockMocks.computeIfAbsent(nodeId, k -> (Lock)Mockito.mock(Lock.class));
        });
        this.storeView = new FullScanStoreView(this.locks, (ReadableStorageEngine)this.storageEngine, Config.defaults(), this.jobScheduler);
        this.reader = this.storageEngine.newReader();
    }

    @AfterEach
    void after() throws Exception {
        this.jobScheduler.close();
        this.reader.close();
    }

    @Test
    void shouldScanExistingNodesForALabel() {
        TestPropertyScanConsumer propertyScanConsumer = new TestPropertyScanConsumer();
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (PropertyScanConsumer)propertyScanConsumer, (TokenScanConsumer)new TestTokenScanConsumer(), false, true, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((List)((List)propertyScanConsumer.batches.get(0))).containsExactlyInAnyOrder((Object[])new TestPropertyScanConsumer.Record[]{FullScanStoreViewTest.record(this.alistair.getId(), this.propertyKeyId, "Alistair", new long[]{this.labelId}), FullScanStoreViewTest.record(this.stefan.getId(), this.propertyKeyId, "Stefan", new long[]{this.labelId})});
    }

    @Test
    void shouldScanExistingRelationshipsForARelationshipType() {
        TestPropertyScanConsumer propertyScanConsumer = new TestPropertyScanConsumer();
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, (PropertyScanConsumer)propertyScanConsumer, null, true, true, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((List)((List)propertyScanConsumer.batches.get(0))).containsExactlyInAnyOrder((Object[])new TestPropertyScanConsumer.Record[]{FullScanStoreViewTest.record(this.aKnowsS.getId(), this.relPropertyKeyId, "long", new long[]{this.relTypeId}), FullScanStoreViewTest.record(this.sKnowsA.getId(), this.relPropertyKeyId, "lengthy", new long[]{this.relTypeId})});
    }

    @Test
    void shouldIgnoreDeletedNodesDuringScan() {
        this.deleteAlistairAndStefanNodes();
        TestPropertyScanConsumer propertyScanConsumer = new TestPropertyScanConsumer();
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (PropertyScanConsumer)propertyScanConsumer, (TokenScanConsumer)new TestTokenScanConsumer(), false, true, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)propertyScanConsumer.batches.isEmpty());
    }

    @Test
    void shouldIgnoreDeletedRelationshipsDuringScan() {
        this.deleteAlistairAndStefanNodes();
        TestPropertyScanConsumer propertyScanConsumer = new TestPropertyScanConsumer();
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, (PropertyScanConsumer)propertyScanConsumer, null, true, true, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)propertyScanConsumer.batches.isEmpty());
    }

    @Test
    void shouldLockNodesWhileReadingThem() {
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, id -> id == this.propertyKeyId, (PropertyScanConsumer)new TestPropertyScanConsumer(), null, false, true, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.lockMocks.size()).as("allocated locks: " + this.lockMocks.keySet(), new Object[0])).isGreaterThanOrEqualTo(2);
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lock0, (String)"Lock[node=0] never acquired");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lock1, (String)"Lock[node=1] never acquired");
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(0L, LockType.SHARED);
        ((Lock)order.verify((Object)lock0)).close();
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(1L, LockType.SHARED);
        ((Lock)order.verify((Object)lock1)).close();
    }

    @Test
    void shouldLockRelationshipsWhileReadingThem() {
        StoreScan storeScan = this.storeView.visitRelationships(new int[]{this.relTypeId}, id -> id == this.relPropertyKeyId, (PropertyScanConsumer)new TestPropertyScanConsumer(), null, true, true, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.lockMocks.size()).as("allocated locks: " + this.lockMocks.keySet(), new Object[0])).isGreaterThanOrEqualTo(2);
        Lock lock0 = this.lockMocks.get(this.aKnowsS.getId());
        Lock lock1 = this.lockMocks.get(this.sKnowsA.getId());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lock0, (String)("Lock[relationship=" + this.aKnowsS.getId() + "] never acquired"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lock1, (String)("Lock[relationship=" + this.sKnowsA.getId() + "] never acquired"));
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireRelationshipLock(this.aKnowsS.getId(), LockType.SHARED);
        ((Lock)order.verify((Object)lock0)).close();
        ((LockService)order.verify((Object)this.locks)).acquireRelationshipLock(this.sKnowsA.getId(), LockType.SHARED);
        ((Lock)order.verify((Object)lock1)).close();
    }

    @Test
    void tracePageCacheAccessOnStoreViewNodeScan() throws IOException {
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, EmptyVersionContextSupplier.EMPTY);
        TestPropertyScanConsumer propertyScanConsumer = new TestPropertyScanConsumer();
        NodeStoreScan scan = new NodeStoreScan(Config.defaults(), this.storageEngine.newReader(), arg_0 -> ((StorageEngine)this.storageEngine).createStorageCursors(arg_0), this.locks, null, (PropertyScanConsumer)propertyScanConsumer, new int[]{this.labelId}, id -> true, false, this.jobScheduler, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        scan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((int)((List)propertyScanConsumer.batches.get(0)).size()).isEqualTo(2);
        PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.graphDb).record(PageCacheTracerAssertions.pins((long)4L).noFaults()).freki(PageCacheTracerAssertions.pins((long)3L).noFaults()).matches((PageCacheCounters)pageCacheTracer);
    }

    @Test
    void tracePageCacheAccessOnRelationshipStoreScan() throws Exception {
        this.checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("forcedCheckpoint"));
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContextFactory contextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, EmptyVersionContextSupplier.EMPTY);
        TestPropertyScanConsumer propertyScanConsumer = new TestPropertyScanConsumer();
        RelationshipStoreScan scan = new RelationshipStoreScan(Config.defaults(), this.storageEngine.newReader(), arg_0 -> ((StorageEngine)this.storageEngine).createStorageCursors(arg_0), this.locks, null, (PropertyScanConsumer)propertyScanConsumer, new int[]{this.relTypeId}, id -> true, false, this.jobScheduler, contextFactory, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        scan.run(StoreScan.NO_EXTERNAL_UPDATES);
        Assertions.assertThat((int)((List)propertyScanConsumer.batches.get(0)).size()).isEqualTo(2);
        PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.graphDb).record(PageCacheTracerAssertions.pins((long)3L).noFaults()).freki(PageCacheTracerAssertions.pins((long)3L).noFaults()).matches((PageCacheCounters)pageCacheTracer);
    }

    @Test
    void processAllRelationshipTypes() {
        TestTokenScanConsumer tokenScanConsumer = new TestTokenScanConsumer();
        StoreScan storeViewRelationshipStoreScan = this.storeView.visitRelationships(ArrayUtils.EMPTY_INT_ARRAY, Predicates.ALWAYS_TRUE_INT, null, (TokenScanConsumer)tokenScanConsumer, true, true, CONTEXT_FACTORY, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        storeViewRelationshipStoreScan.run(StoreScan.NO_EXTERNAL_UPDATES);
        List updates = (List)tokenScanConsumer.batches.get(0);
        Assertions.assertThat((int)updates.size()).isEqualTo(2);
        for (TestTokenScanConsumer.Record update : updates) {
            long[] tokensAfter = update.getTokens();
            Assertions.assertThat((int)tokensAfter.length).isEqualTo(1);
            Assertions.assertThat((long)tokensAfter[0]).isEqualTo(0L);
            Assertions.assertThat((long)update.getEntityId()).satisfiesAnyOf(new ThrowingConsumer[]{id -> Assertions.assertThat((Long)id).isEqualTo(0L), id -> Assertions.assertThat((Long)id).isEqualTo(1L)});
        }
    }

    private static TestPropertyScanConsumer.Record record(long nodeId, int propertyKeyId, Object value, long[] labels) {
        return new TestPropertyScanConsumer.Record(nodeId, labels, Map.of(propertyKeyId, Values.of((Object)value)));
    }

    private void createAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair = tx.createNode(new Label[]{this.label});
            this.alistair.setProperty("name", (Object)"Alistair");
            this.alistair.setProperty("country", (Object)"UK");
            this.stefan = tx.createNode(new Label[]{this.label});
            this.stefan.setProperty("name", (Object)"Stefan");
            this.stefan.setProperty("country", (Object)"Deutschland");
            this.aKnowsS = this.alistair.createRelationshipTo(this.stefan, this.relationshipType);
            this.aKnowsS.setProperty("duration", (Object)"long");
            this.aKnowsS.setProperty("irrelevant", (Object)"prop");
            this.sKnowsA = this.stefan.createRelationshipTo(this.alistair, this.relationshipType);
            this.sKnowsA.setProperty("duration", (Object)"lengthy");
            this.sKnowsA.setProperty("irrelevant", (Object)"prop");
            tx.commit();
        }
    }

    private void deleteAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            tx.getRelationshipById(this.aKnowsS.getId()).delete();
            tx.getRelationshipById(this.sKnowsA.getId()).delete();
            tx.getNodeById(this.alistair.getId()).delete();
            tx.getNodeById(this.stefan.getId()).delete();
            tx.commit();
        }
    }

    private void getOrCreateIds() throws KernelException {
        try (Transaction tx = this.graphDb.beginTx();){
            TokenWrite tokenWrite = ((InternalTransaction)tx).kernelTransaction().tokenWrite();
            this.labelId = tokenWrite.labelGetOrCreateForName("Person");
            this.relTypeId = tokenWrite.relationshipTypeGetOrCreateForName("Knows");
            this.propertyKeyId = tokenWrite.propertyKeyGetOrCreateForName("name");
            this.relPropertyKeyId = tokenWrite.propertyKeyGetOrCreateForName("duration");
            tx.commit();
        }
    }
}

