/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.device.DeviceMapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.NativeIndexFileFilter;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
class KernelDiagnosticsIT {
    @Inject
    private GraphDatabaseAPI db;
    @Inject
    private FileSystemAbstraction fs;

    KernelDiagnosticsIT() {
    }

    @ParameterizedTest
    @EnumSource(value=IndexType.class, mode=EnumSource.Mode.EXCLUDE, names={"LOOKUP"})
    void shouldIncludeNativeIndexFilesInTotalMappedSize(IndexType indexType) {
        this.createIndexAndData(indexType);
        DatabaseLayout databaseLayout = this.db.databaseLayout();
        DeviceMapper deviceMapper = (DeviceMapper)this.db.getDependencyResolver().resolveDependency(DeviceMapper.class);
        StorageEngineFactory storageEngineFactory = StorageEngineFactory.defaultStorageEngine();
        StoreFilesDiagnostics files = new StoreFilesDiagnostics(storageEngineFactory, this.fs, databaseLayout, deviceMapper);
        SizeCapture capture = new SizeCapture();
        files.dump(capture::log);
        Assertions.assertNotNull((Object)capture.size);
        long expected = KernelDiagnosticsIT.manuallyCountTotalMappedFileSize(databaseLayout.databaseDirectory());
        Assertions.assertEquals((Object)ByteUnit.bytesToString((long)expected), (Object)capture.size);
    }

    private void createIndexAndData(IndexType indexType) {
        Label label = Label.label((String)("Label-" + indexType));
        String key = "key";
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                tx.createNode(new Label[]{label}).setProperty(key, (Object)("" + i));
            }
            tx.commit();
        }
        tx = this.db.beginTx();
        try {
            tx.schema().indexFor(label).on(key).withIndexType(indexType).create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(2L, TimeUnit.MINUTES);
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static long manuallyCountTotalMappedFileSize(Path dbDir) {
        MutableLong result = new MutableLong();
        NativeIndexFileFilter nativeIndexFilter = new NativeIndexFileFilter(dbDir);
        KernelDiagnosticsIT.manuallyCountTotalMappedFileSize(dbDir, result, nativeIndexFilter);
        return result.getValue();
    }

    private static void manuallyCountTotalMappedFileSize(Path dir, MutableLong result, NativeIndexFileFilter nativeIndexFilter) {
        Set storeFiles = Stream.of(StoreType.values()).map(type -> type.getDatabaseFile().getName()).collect(Collectors.toSet());
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir);){
            for (Path path : paths) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    KernelDiagnosticsIT.manuallyCountTotalMappedFileSize(path, result, nativeIndexFilter);
                    continue;
                }
                if (!storeFiles.contains(path.getFileName().toString()) && !nativeIndexFilter.test(path)) continue;
                try {
                    result.add(Files.size(path));
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class SizeCapture {
        private String size;

        private SizeCapture() {
        }

        public void log(String message) {
            if (message.contains("Total size of mapped files")) {
                int beginPos = message.lastIndexOf(": ");
                Assertions.assertTrue((beginPos != -1 ? 1 : 0) != 0);
                this.size = message.substring(beginPos + 2);
            }
        }
    }
}

