/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.tracers;

import java.util.Iterator;
import java.util.function.Consumer;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.LongAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorCounters;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.PageCacheTracerAssertions;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@ExtendWith(value={SoftAssertionsExtension.class})
@DbmsExtension
class TransactionTracingIT {
    private static final int ENTITY_COUNT = 1000;
    @Inject
    private GraphDatabaseAPI database;
    @Inject
    private DatabaseManagementService managementService;
    @InjectSoftAssertions
    private SoftAssertions softly;

    TransactionTracingIT() {
    }

    @Test
    void tracePageCacheAccessOnAllNodesAccess() {
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                transaction.createNode();
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterables.count((Iterable)transaction.getAllNodes())).as("Number of expected nodes", new Object[0])).isEqualTo(1000L);
            PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.database).record(PageCacheTracerAssertions.pins((long)2L).noFaults()).freki(PageCacheTracerAssertions.pins((long)16L).noFaults());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnNodeCreation() {
        try (InternalTransaction transaction = (InternalTransaction)this.database.beginTx();){
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            CommitCursorChecker commitCursorChecker = new CommitCursorChecker(db -> PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)db).record(PageCacheTracerAssertions.pins((long)1001L).faults(2L)).freki(PageCacheTracerAssertions.pins((long)2001L).faults(16L)).matches((PageCursorCounters)cursorContext.getCursorTracer()));
            this.managementService.registerTransactionEventListener(this.database.databaseName(), (TransactionEventListener)commitCursorChecker);
            for (int i = 0; i < 1000; ++i) {
                transaction.createNode();
            }
            this.assertZeroCursor(cursorContext);
            transaction.commit();
            ((BooleanAssert)this.softly.assertThat(commitCursorChecker.isInvoked()).as("Transaction committed", new Object[0])).isTrue();
        }
    }

    @Test
    void tracePageCacheAccessOnAllRelationshipsAccess() {
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode();
                source.createRelationshipTo(transaction.createNode(), RelationshipType.withName((String)"connection"));
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterables.count((Iterable)transaction.getAllRelationships())).as("Number of expected relationships", new Object[0])).isEqualTo(1000L);
            PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.database).record(PageCacheTracerAssertions.pins((long)5L).noFaults()).freki(PageCacheTracerAssertions.pins((long)32L).noFaults().skipUnpins()).matches((PageCursorCounters)cursorContext.getCursorTracer());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnFindNodes() {
        Label marker = Label.label((String)"marker");
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode(new Label[]{marker});
                source.createRelationshipTo(transaction.createNode(), type);
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterators.count((Iterator)transaction.findNodes(marker))).as("Number of expected nodes", new Object[0])).isEqualTo(1000L);
            PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.database).record(PageCacheTracerAssertions.pins((long)1L).noFaults()).freki(PageCacheTracerAssertions.pins((long)1L).noFaults()).matches((PageCursorCounters)cursorContext.getCursorTracer());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnFindRelationships() {
        Label marker = Label.label((String)"marker");
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 1000; ++i) {
                Node source = transaction.createNode(new Label[]{marker});
                source.createRelationshipTo(transaction.createNode(), type);
            }
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            ((LongAssert)this.softly.assertThat(Iterators.count((Iterator)transaction.findRelationships(type))).as("Number of expected relationships", new Object[0])).isEqualTo(1000L);
            PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.database).record(PageCacheTracerAssertions.pins((long)1L).noFaults()).freki(PageCacheTracerAssertions.pins((long)33L).noFaults().skipUnpins()).matches((PageCursorCounters)cursorContext.getCursorTracer());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    @Test
    void tracePageCacheAccessOnDetachDelete() throws KernelException {
        long sourceId;
        RelationshipType type = RelationshipType.withName((String)"connection");
        try (Transaction transaction = this.database.beginTx();){
            Node source = transaction.createNode();
            for (int i = 0; i < 10; ++i) {
                source.createRelationshipTo(transaction.createNode(), type);
            }
            sourceId = source.getId();
            transaction.commit();
        }
        transaction = (InternalTransaction)this.database.beginTx();
        try {
            CursorContext cursorContext = transaction.kernelTransaction().cursorContext();
            this.assertZeroCursor(cursorContext);
            transaction.kernelTransaction().dataWrite().nodeDetachDelete(sourceId);
            PageCacheTracerAssertions.assertThatTracing((GraphDatabaseAPI)this.database).record(PageCacheTracerAssertions.pins((long)2L).noFaults().skipUnpins()).freki(PageCacheTracerAssertions.pins((long)1L).noFaults().skipUnpins()).matches((PageCursorCounters)cursorContext.getCursorTracer());
        }
        finally {
            if (transaction != null) {
                transaction.close();
            }
        }
    }

    private void assertZeroCursor(CursorContext cursorContext) {
        this.softly.assertThat(cursorContext.getCursorTracer().pins()).isEqualTo(0L);
        this.softly.assertThat(cursorContext.getCursorTracer().unpins()).isEqualTo(0L);
        this.softly.assertThat(cursorContext.getCursorTracer().hits()).isEqualTo(0L);
        this.softly.assertThat(cursorContext.getCursorTracer().faults()).isEqualTo(0L);
    }

    private static class CommitCursorChecker
    extends TransactionEventListenerAdapter<Object> {
        private final Consumer<GraphDatabaseAPI> assertion;
        private volatile boolean invoked;

        CommitCursorChecker(Consumer<GraphDatabaseAPI> assertion) {
            this.assertion = assertion;
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void afterCommit(TransactionData data, Object state, GraphDatabaseService databaseService) {
            this.assertion.accept((GraphDatabaseAPI)databaseService);
            this.invoked = true;
        }
    }
}

