/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.noopens;

import java.lang.invoke.MethodHandles;
import java.nio.Buffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@EphemeralTestDirectoryExtension
public class NoOpensIT {
    @Inject
    private TestDirectory testDir;

    @BeforeAll
    static void before() {
        NoOpensIT.assertByteBufferClosed();
    }

    @Test
    void warningFromPageCache() {
        this.runTest("Reflection access to java.nio.DirectByteBuffer is not available, using fallback mode. This could have negative impact on performance and memory usage. Consider adding --add-opens=java.base/java.nio=ALL-UNNAMED to VM options.");
    }

    public static void assertByteBufferClosed() {
        try {
            MethodHandles.privateLookupIn(Buffer.class, MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            return;
        }
        Assertions.fail((String)"java.nio looks to be open for reflection. Re-run test without opening java.nio.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(String warningMessage) {
        DatabaseManagementService dbms = null;
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        try {
            dbms = new TestDatabaseManagementServiceBuilder(this.testDir.homePath()).setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.testDir.getFileSystem())).setInternalLogProvider((InternalLogProvider)logProvider).build();
            GraphDatabaseService db = dbms.database("neo4j");
            try (Transaction tx = db.beginTx();){
                tx.createNode(new Label[]{Label.label((String)"label")}).setProperty("key", (Object)"value");
                tx.commit();
            }
        }
        finally {
            if (dbms != null) {
                dbms.shutdown();
            }
        }
        LogAssertions.assertThat((AssertableLogProvider)logProvider).containsMessages(new String[]{warningMessage});
    }
}

