/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.impl.FallbackBlockSwapper;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={RandomExtension.class})
public class FallbackBlockSwapperIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private RandomSupport random;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void swapOutSwapIn() throws IOException {
        Path file = this.testDirectory.createFile("test");
        byte[] data = this.random.nextBytes(new byte[100]);
        FallbackBlockSwapper swapper = new FallbackBlockSwapper((MemoryTracker)EmptyMemoryTracker.INSTANCE);
        long source = UnsafeUtil.allocateMemory((long)data.length, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (StoreChannel channel = this.fs.write(file);){
            for (int i = 0; i < data.length; ++i) {
                UnsafeUtil.putByte((long)(source + (long)i), (byte)data[i]);
            }
            swapper.swapOut(channel, source, 0L, data.length);
        }
        finally {
            UnsafeUtil.free((long)source, (long)data.length, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
        long target = UnsafeUtil.allocateMemory((long)data.length, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        try (StoreChannel channel = this.fs.read(file);){
            swapper.swapIn(channel, target, 0L, data.length);
            for (int i = 0; i < data.length; ++i) {
                Assertions.assertThat((byte)UnsafeUtil.getByte((long)(target + (long)i))).isEqualTo(data[i]);
            }
        }
        finally {
            UnsafeUtil.free((long)target, (long)data.length, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        }
    }
}

