/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.systemgraph.SecurityGraphDbmsModel;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.SecureHasher;
import org.neo4j.server.security.SystemGraphCredential;
import org.neo4j.server.security.systemgraph.SecurityGraphHelper;
import org.neo4j.string.UTF8;
import org.neo4j.test.extension.ImpermanentDbmsExtension;
import org.neo4j.test.extension.Inject;

@ImpermanentDbmsExtension
public class SecurityGraphHelperTest {
    @Inject
    private DatabaseManagementService dbms;
    private SecurityGraphHelper securityGraphHelper;
    private AbstractSecurityLog securityLog;
    GraphDatabaseService system;

    @BeforeEach
    void setUp() {
        this.system = this.dbms.database("system");
        this.securityLog = (AbstractSecurityLog)Mockito.mock(AbstractSecurityLog.class);
        this.securityGraphHelper = new SecurityGraphHelper((Supplier)Suppliers.lazySingleton(() -> this.system), new SecureHasher(), this.securityLog);
        Mockito.when((Object)this.securityLog.isDebugEnabled()).thenReturn((Object)true);
    }

    @Test
    void getUserByNameShouldReturnNullUserIdIsNull() {
        User result = this.securityGraphHelper.getUserByName(null);
        Assertions.assertThat((Object)result).isNull();
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).debug("Looking up user 'null'");
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).debug("Cannot look up user 'null'");
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).isDebugEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.securityLog});
    }

    @Test
    void getUserByIdShouldReturnUserWithNativeAuthForLegacyUserWhenCredentialsSet() {
        SystemGraphCredential credential = SystemGraphCredential.createCredentialForPassword((byte[])UTF8.encode((String)"password"), (SecureHasher)new SecureHasher());
        this.createUser(new User("alice", "userId", (Credential)credential, false, false));
        User result = this.securityGraphHelper.getUserByName("alice");
        Assertions.assertThat((String)result.id()).isEqualTo("userId");
        Assertions.assertThat((String)result.name()).isEqualTo("alice");
        Assertions.assertThat((Collection)result.auth()).isEqualTo(Set.of(new User.Auth("native", "userId")));
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).debug("Looking up user 'alice'");
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).debug("Found user: User[name=alice, id=userId, credential=*****, passwordChangeRequired=false, suspended=false, auth=[Auth[provider=native, id=userId]]]");
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).isDebugEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.securityLog});
    }

    @Test
    void getUserByIdShouldReturnUserWithoutNativeAuthForLegacyUserWhenCredentialsNotSet() {
        this.createUser(new User("alice", "userId", null, false, false));
        User result = this.securityGraphHelper.getUserByName("alice");
        Assertions.assertThat((String)result.id()).isEqualTo("userId");
        Assertions.assertThat((String)result.name()).isEqualTo("alice");
        Assertions.assertThat((Collection)result.auth()).isEqualTo(Set.of());
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).debug("Looking up user 'alice'");
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).debug("Found user: User[name=alice, id=userId, credential=null, passwordChangeRequired=false, suspended=false, auth=[]]");
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).isDebugEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.securityLog});
    }

    @Test
    void getUserByIdShouldReturnNullWhenUserDoesNotExist() {
        User result = this.securityGraphHelper.getUserByName("alice");
        Assertions.assertThat((Object)result).isNull();
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).debug("Looking up user 'alice'");
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).debug("User 'alice' not found");
        ((AbstractSecurityLog)Mockito.verify((Object)this.securityLog)).isDebugEnabled();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.securityLog});
    }

    void createUser(User user) {
        try (Transaction tx = this.system.beginTx();){
            Node userNode = tx.createNode(new Label[]{SecurityGraphDbmsModel.USER_LABEL});
            userNode.setProperty("name", (Object)user.name());
            userNode.setProperty("id", (Object)user.id());
            if (user.credential() != null && user.credential().value() != null) {
                userNode.setProperty("credentials", (Object)user.credential().value().serialize());
                userNode.setProperty("passwordChangeRequired", (Object)user.passwordChangeRequired());
            }
            tx.commit();
        }
    }
}

