/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.KeepFirstDuplicateBuilder;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponentWithVersion;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.systemgraph.SecurityGraphDbmsModel;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponentVersion;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class UserSecurityGraphComponentIT {
    @Inject
    private static TestDirectory directory;
    private static DatabaseManagementService dbms;
    private static GraphDatabaseFacade system;
    private static SystemGraphComponents internalSystemGraphComponents;
    private static UserSecurityGraphComponent userSecurityGraphComponent;
    private static AuthManager authManager;
    private static final SystemGraphComponent.Name testComponent;

    UserSecurityGraphComponentIT() {
    }

    @BeforeAll
    static void setup() {
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.auth_enabled, (Object)Boolean.TRUE).set(GraphDatabaseInternalSettings.automatic_upgrade_enabled, (Object)Boolean.FALSE).build();
        KeepFirstDuplicateBuilder internalSystemGraphComponentsBuilder = new KeepFirstDuplicateBuilder();
        internalSystemGraphComponentsBuilder.register((SystemGraphComponent)new StubComponent(ComponentVersion.DBMS_RUNTIME_COMPONENT.name()));
        internalSystemGraphComponentsBuilder.register((SystemGraphComponent)new StubComponent(ComponentVersion.SECURITY_USER_COMPONENT.name()));
        dbms = new TestDatabaseManagementServiceBuilder(directory.homePath()).impermanent().setConfig(cfg).setExternalDependencies((DependencyResolver)Dependencies.dependenciesOf((Object)internalSystemGraphComponentsBuilder)).noOpSystemGraphInitializer().build();
        system = (GraphDatabaseFacade)dbms.database("system");
        DependencyResolver resolver = system.getDependencyResolver();
        authManager = (AuthManager)resolver.resolveDependency(AuthManager.class);
        userSecurityGraphComponent = new UserSecurityGraphComponent((UserRepository)new InMemoryUserRepository(), Config.defaults(), (LogProvider)NullLogProvider.getInstance(), (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG);
        internalSystemGraphComponents = (SystemGraphComponents)resolver.resolveDependency(SystemGraphComponents.class);
    }

    @BeforeEach
    void clear() throws Exception {
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> Iterables.forEach((Iterable)tx.getAllNodes(), n -> {
            Iterables.forEach((Iterable)n.getRelationships(), Entity::delete);
            n.delete();
        })));
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> tx.schema().getConstraints().forEach(ConstraintDefinition::drop)));
        internalSystemGraphComponents.initializeSystemGraph((GraphDatabaseService)system);
    }

    @AfterAll
    static void tearDown() {
        dbms.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"supportedPreviousVersions"})
    void shouldAuthenticate(UserSecurityGraphComponentVersion version) throws Exception {
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        LoginContext loginContext = authManager.login(AuthToken.newBasicAuthToken((String)"neo4j", (String)"neo4j"), ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertThat((Comparable)loginContext.subject().getAuthenticationResult()).isEqualTo((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
    }

    @Test
    void shouldInitializeDefaultVersion() throws Exception {
        userSecurityGraphComponent.initializeSystemGraph((GraphDatabaseService)system, true);
        SystemGraphComponents systemGraphComponents = UserSecurityGraphComponentIT.systemGraphComponentsPlus(internalSystemGraphComponents, new SystemGraphComponent[]{userSecurityGraphComponent});
        HashMap componentStatuses = new HashMap();
        SystemGraphComponent.Name overallStatus = new SystemGraphComponent.Name("overall-status");
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            systemGraphComponents.forEach(component -> componentStatuses.put(component.componentName(), component.detect(tx)));
            componentStatuses.put(overallStatus, systemGraphComponents.detect(tx));
        }));
        Set<SystemGraphComponent.Name> expectedComponents = Set.of(ComponentVersion.DBMS_RUNTIME_COMPONENT, ComponentVersion.MULTI_DATABASE_COMPONENT, ComponentVersion.SECURITY_USER_COMPONENT, ComponentVersion.COMMUNITY_TOPOLOGY_GRAPH_COMPONENT, overallStatus);
        Assertions.assertThat(componentStatuses.keySet()).containsExactlyInAnyOrderElementsOf(expectedComponents);
        for (SystemGraphComponent.Name component : expectedComponents) {
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((SystemGraphComponent.Status)componentStatuses.get(component))).as("Component status should all be current", new Object[0])).isEqualTo((Object)SystemGraphComponent.Status.CURRENT);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"versionAndStatusProvider"})
    void shouldInitializeAndUpgradeSystemGraph(UserSecurityGraphComponentVersion version, SystemGraphComponent.Status initialStatus) throws Exception {
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        UserSecurityGraphComponentIT.assertCanUpgradeThisVersionAndThenUpgradeIt(initialStatus);
    }

    @ParameterizedTest
    @MethodSource(value={"versionAndStatusProvider"})
    void shouldInitializeAndUpgradeSystemGraphWithoutDefaultUser(UserSecurityGraphComponentVersion version, SystemGraphComponent.Status initialStatus) throws Exception {
        Config config = Config.defaults();
        config.set(GraphDatabaseInternalSettings.create_default_user, (Object)false);
        UserSecurityGraphComponentIT.initUserSecurityComponent(version, config);
        UserSecurityGraphComponentIT.assertCanUpgradeThisVersionAndThenUpgradeIt(initialStatus);
    }

    static Stream<Arguments> versionAndStatusProvider() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_43D4, SystemGraphComponent.Status.REQUIRES_UPGRADE}), Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_50, SystemGraphComponent.Status.REQUIRES_UPGRADE}), Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_521, SystemGraphComponent.Status.CURRENT}));
    }

    @ParameterizedTest
    @MethodSource(value={"beforeUserIdConstraint"})
    void shouldAddConstraintForUserIdsOnUpgradeFromOlderSystemDb(UserSecurityGraphComponentVersion version) throws Exception {
        Iterable constraints;
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        SystemGraphComponents systemGraphComponents = UserSecurityGraphComponentIT.systemGraphComponentsPlus(internalSystemGraphComponents, new SystemGraphComponent[]{userSecurityGraphComponent});
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            constraints = tx.schema().getConstraints(SecurityGraphDbmsModel.USER_LABEL);
            for (ConstraintDefinition constraint : constraints) {
                for (String property : constraint.getPropertyKeys()) {
                    Assertions.assertThat((String)property).isIn(new Object[]{"name"});
                }
            }
            tx.commit();
        }
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        try {
            constraints = tx.schema().getConstraints(SecurityGraphDbmsModel.USER_LABEL);
            for (ConstraintDefinition constraint : constraints) {
                for (String property : constraint.getPropertyKeys()) {
                    Assertions.assertThat((String)property).isIn(new Object[]{"name", "id"});
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"beforeUserAuth"})
    void shouldAddUserAuthOnUpgradeFromOlderSystemDb(UserSecurityGraphComponentVersion version) throws Exception {
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        SystemGraphComponents systemGraphComponents = UserSecurityGraphComponentIT.systemGraphComponentsPlus(internalSystemGraphComponents, new SystemGraphComponent[]{userSecurityGraphComponent});
        KnownCommunitySecurityComponentVersion builder = userSecurityGraphComponent.findSecurityGraphComponentVersion((ComponentVersion)version);
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            builder.addUser((Transaction)tx, "alice", (Credential)SecurityTestUtils.credentialFor((String)"abc123"), false, false);
            tx.commit();
        }
        Assertions.assertThat((boolean)this.hasSingleNativeAuthWithUserId("neo4j")).isFalse();
        Assertions.assertThat((boolean)this.hasSingleNativeAuthWithUserId("alice")).isFalse();
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        Assertions.assertThat((boolean)this.hasSingleNativeAuthWithUserId("neo4j")).isTrue();
        Assertions.assertThat((boolean)this.hasSingleNativeAuthWithUserId("alice")).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"beforeUserAuth"})
    void shouldNotGetDuplicateAuthObjectOnUpgradeFromOlderSystemDb(UserSecurityGraphComponentVersion version) throws Exception {
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        SystemGraphComponents systemGraphComponents = UserSecurityGraphComponentIT.systemGraphComponentsPlus(internalSystemGraphComponents, new SystemGraphComponent[]{userSecurityGraphComponent});
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            tx.execute("ALTER USER neo4j SET PASSWORD 'abcd1234'").close();
            tx.commit();
        }
        Assertions.assertThat((boolean)this.hasSingleNativeAuthWithUserId("neo4j")).isTrue();
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        Assertions.assertThat((boolean)this.hasSingleNativeAuthWithUserId("neo4j")).isTrue();
    }

    @ParameterizedTest
    @MethodSource(value={"beforeUserAuth"})
    void shouldAddConstraintForUserAuthOnUpgradeFromOlderSystemDb(UserSecurityGraphComponentVersion version) throws Exception {
        Object constraints;
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        SystemGraphComponents systemGraphComponents = UserSecurityGraphComponentIT.systemGraphComponentsPlus(internalSystemGraphComponents, new SystemGraphComponent[]{userSecurityGraphComponent});
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            constraints = tx.schema().getConstraints(SecurityGraphDbmsModel.AUTH_LABEL);
            Assertions.assertThatIterable((Iterable)constraints).isEmpty();
            tx.commit();
        }
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        try {
            constraints = tx.schema().getConstraints(SecurityGraphDbmsModel.AUTH_LABEL).iterator();
            Assertions.assertThat((Iterator)constraints).hasNext();
            ConstraintDefinition constraint = (ConstraintDefinition)constraints.next();
            Assertions.assertThatIterable((Iterable)constraint.getPropertyKeys()).containsExactlyInAnyOrder((Object[])new String[]{"id", "provider"});
            Assertions.assertThat((Iterator)constraints).isExhausted();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    void shouldInitializeLatestCorrectly() {
        KeepFirstDuplicateBuilder builder = new KeepFirstDuplicateBuilder();
        builder.register((SystemGraphComponent)userSecurityGraphComponent);
        SystemGraphComponents systemGraphComponents = builder.build();
        systemGraphComponents.initializeSystemGraph((GraphDatabaseService)system);
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            ConstraintDefinition constraint2;
            Node user = tx.findNode(SecurityGraphDbmsModel.USER_LABEL, "name", (Object)"neo4j");
            Object userId = user.getProperty("id", null);
            Assertions.assertThat((Object)userId).isNotNull();
            Relationship authRel = user.getSingleRelationship(SecurityGraphDbmsModel.HAS_AUTH_TYPE, Direction.OUTGOING);
            Assertions.assertThat((Object)authRel).isNotNull();
            Node authNode = authRel.getEndNode();
            Object provider = authNode.getProperty("provider");
            Object authId = authNode.getProperty("id", (Object)0);
            Assertions.assertThat((Object)provider).isEqualTo((Object)"native");
            Assertions.assertThat((Object)authId).isEqualTo(userId);
            Iterable constraints = tx.schema().getConstraints(SecurityGraphDbmsModel.USER_LABEL);
            for (ConstraintDefinition constraint2 : constraints) {
                for (String property : constraint2.getPropertyKeys()) {
                    Assertions.assertThat((String)property).isIn(new Object[]{"name", "id"});
                }
            }
            Iterator authConstraint = tx.schema().getConstraints(SecurityGraphDbmsModel.AUTH_LABEL).iterator();
            Assertions.assertThat(authConstraint).hasNext();
            constraint2 = (ConstraintDefinition)authConstraint.next();
            Assertions.assertThat((String)constraint2.getName()).isEqualTo("auth-constraint");
            Assertions.assertThatIterable((Iterable)constraint2.getPropertyKeys()).containsExactlyInAnyOrder((Object[])new String[]{"id", "provider"});
            Assertions.assertThat(authConstraint).isExhausted();
            tx.commit();
        }
    }

    private static SystemGraphComponents systemGraphComponentsPlus(SystemGraphComponents existing, SystemGraphComponent ... components) {
        KeepFirstDuplicateBuilder builder = new KeepFirstDuplicateBuilder();
        for (SystemGraphComponent component : components) {
            builder.register(component);
        }
        existing.forEach(arg_0 -> ((KeepFirstDuplicateBuilder)builder).register(arg_0));
        return builder.build();
    }

    private static Stream<Arguments> supportedPreviousVersions() {
        return Arrays.stream(UserSecurityGraphComponentVersion.values()).filter(version -> version.runtimeSupported() && !version.isCurrent(Config.defaults())).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Stream<Arguments> beforeUserIdConstraint() {
        return Arrays.stream(UserSecurityGraphComponentVersion.values()).filter(version -> version.runtimeSupported() && version.getVersion() < UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_50.getVersion()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Stream<Arguments> beforeUserAuth() {
        return Arrays.stream(UserSecurityGraphComponentVersion.values()).filter(version -> version.runtimeSupported() && version.getVersion() < UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_521.getVersion()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static void assertCanUpgradeThisVersionAndThenUpgradeIt(SystemGraphComponent.Status initialState) throws Exception {
        SystemGraphComponents internalSystemGraphComponents = (SystemGraphComponents)system.getDependencyResolver().resolveDependency(SystemGraphComponents.class);
        SystemGraphComponents systemGraphComponents = UserSecurityGraphComponentIT.systemGraphComponentsPlus(internalSystemGraphComponents, new SystemGraphComponent[]{userSecurityGraphComponent});
        UserSecurityGraphComponentIT.assertStatus(systemGraphComponents, Map.of(ComponentVersion.DBMS_RUNTIME_COMPONENT, SystemGraphComponent.Status.CURRENT, ComponentVersion.MULTI_DATABASE_COMPONENT, SystemGraphComponent.Status.CURRENT, ComponentVersion.SECURITY_USER_COMPONENT, initialState, ComponentVersion.COMMUNITY_TOPOLOGY_GRAPH_COMPONENT, SystemGraphComponent.Status.CURRENT, testComponent, initialState));
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        UserSecurityGraphComponentIT.assertStatus(systemGraphComponents, Map.of(ComponentVersion.DBMS_RUNTIME_COMPONENT, SystemGraphComponent.Status.CURRENT, ComponentVersion.MULTI_DATABASE_COMPONENT, SystemGraphComponent.Status.CURRENT, ComponentVersion.SECURITY_USER_COMPONENT, SystemGraphComponent.Status.CURRENT, ComponentVersion.COMMUNITY_TOPOLOGY_GRAPH_COMPONENT, SystemGraphComponent.Status.CURRENT, testComponent, SystemGraphComponent.Status.CURRENT));
    }

    private static void assertStatus(SystemGraphComponents systemGraphComponents, Map<SystemGraphComponent.Name, SystemGraphComponent.Status> expected) throws Exception {
        HashMap statuses = new HashMap();
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            systemGraphComponents.forEach(component -> statuses.put(component.componentName(), component.detect(tx)));
            statuses.put(testComponent, systemGraphComponents.detect(tx));
        }));
        Assertions.assertThat(statuses).isEqualTo(expected);
    }

    private boolean hasSingleNativeAuthWithUserId(String username) {
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            Node authNode;
            Node user = tx.findNode(SecurityGraphDbmsModel.USER_LABEL, "name", (Object)username);
            Relationship authRel = user.getSingleRelationship(SecurityGraphDbmsModel.HAS_AUTH_TYPE, Direction.OUTGOING);
            if (authRel != null && "native".equals((authNode = authRel.getEndNode()).getProperty("provider"))) {
                Object userId = user.getProperty("id", (Object)-1);
                boolean bl = userId.equals(authNode.getProperty("id", (Object)0));
                return bl;
            }
        }
        return false;
    }

    private static void initUserSecurityComponent(UserSecurityGraphComponentVersion version) throws Exception {
        UserSecurityGraphComponentIT.initUserSecurityComponent(version, Config.defaults());
    }

    private static void initUserSecurityComponent(UserSecurityGraphComponentVersion version, Config config) throws Exception {
        KnownCommunitySecurityComponentVersion builder = userSecurityGraphComponent.findSecurityGraphComponentVersion((ComponentVersion)version);
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> tx.schema().constraintFor(SecurityGraphDbmsModel.USER_LABEL).assertPropertyIsUnique("name").create()));
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> builder.upgradeSecurityGraphSchema(tx, UserSecurityGraphComponentVersion.FIRST_VALID_COMMUNITY_SECURITY_COMPONENT_VERSION)));
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx1 -> builder.setupUsers(tx1, config)));
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> builder.setVersionProperty(tx, version.getVersion())));
        userSecurityGraphComponent.postInitialization((GraphDatabaseService)system, true);
    }

    private static void inTx(ThrowingConsumer<Transaction, Exception> consumer) throws Exception {
        try (Transaction tx = system.beginTx();){
            consumer.accept((Object)tx);
            tx.commit();
        }
    }

    static {
        testComponent = new SystemGraphComponent.Name("test-component");
    }

    static class StubComponent
    implements SystemGraphComponentWithVersion {
        private final SystemGraphComponent.Name name;

        public StubComponent(String name) {
            this.name = new SystemGraphComponent.Name(name);
        }

        public SystemGraphComponent.Name componentName() {
            return this.name;
        }

        public int getLatestSupportedVersion() {
            return 0;
        }

        public SystemGraphComponent.Status detect(Transaction tx) {
            return SystemGraphComponent.Status.CURRENT;
        }

        public void initializeSystemGraph(GraphDatabaseService system, boolean firstInitialization) {
        }

        public void upgradeToCurrent(GraphDatabaseService system) {
        }
    }
}

