/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectAssertions;
import org.neo4j.gqlstatus.GqlExceptionLikeAssert;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.utils.TestDirectory;

@DbmsExtension(configurationCallback="configure")
class BasicAuthIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private DbmsController dbmsController;
    @Inject
    private AuthManager authManager;

    BasicAuthIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.auth_enabled, (Object)false);
    }

    @Test
    void shouldCreateUserWithAuthDisabled() throws Exception {
        GraphDatabaseService systemDatabase = this.managementService.database("system");
        try (Transaction tx = systemDatabase.beginTx();){
            tx.execute("CREATE USER foo SET PASSWORD 'barpassword'").close();
            tx.commit();
        }
        this.dbmsController.restartDbms(builder -> builder.setConfig(GraphDatabaseSettings.auth_enabled, (Object)true));
        LoginContext loginContext = this.authManager.login(AuthToken.newBasicAuthToken((String)"foo", (String)"wrong"), ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertThat((Comparable)loginContext.subject().getAuthenticationResult()).isEqualTo((Object)AuthenticationResult.FAILURE);
        loginContext = this.authManager.login(AuthToken.newBasicAuthToken((String)"foo", (String)"barpassword"), ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertThat((Comparable)loginContext.subject().getAuthenticationResult()).isEqualTo((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
    }

    @Test
    void shouldFailImpersonate() throws Exception {
        GraphDatabaseService systemDatabase = this.managementService.database("system");
        try (Transaction tx = systemDatabase.beginTx();){
            tx.execute("CREATE USER foo SET PASSWORD 'barpassword' CHANGE NOT REQUIRED").close();
            tx.execute("CREATE USER baz SET PASSWORD 'barpassword'").close();
            tx.commit();
        }
        this.dbmsController.restartDbms(builder -> builder.setConfig(GraphDatabaseSettings.auth_enabled, (Object)true));
        LoginContext loginContext = this.authManager.login(AuthToken.newBasicAuthToken((String)"foo", (String)"barpassword"), ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertThat((Comparable)loginContext.subject().getAuthenticationResult()).isEqualTo((Object)AuthenticationResult.SUCCESS);
        ((GqlExceptionLikeAssert)((GqlExceptionLikeAssert)((GqlExceptionLikeAssert)ErrorGqlStatusObjectAssertions.assertThatThrownBy(() -> this.authManager.impersonate(loginContext, "baz")).isInstanceOf(InvalidArgumentException.class)).hasMessage("Impersonation is not supported in community edition.")).hasGqlStatus(GqlStatusInfoCodes.STATUS_51N27)).hasStatusDescription("error: system configuration or operation exception - not supported in this edition. Impersonation is not supported in community edition.");
    }

    @Test
    void shouldFailImpersonateWithAuthDisabled() throws Exception {
        GraphDatabaseService systemDatabase = this.managementService.database("system");
        try (Transaction tx = systemDatabase.beginTx();){
            tx.execute("CREATE USER foo SET PASSWORD 'barpassword'").close();
            tx.commit();
        }
        LoginContext loginContext = this.authManager.login(Collections.emptyMap(), ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertThat((Comparable)loginContext.subject().getAuthenticationResult()).isEqualTo((Object)AuthenticationResult.SUCCESS);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.authManager.impersonate(loginContext, "foo")).isInstanceOf(InvalidArgumentException.class)).hasMessage("Impersonation is not supported with auth disabled.");
    }
}

