/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.DbmsController;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.rule.TestDirectory;

@DbmsExtension(configurationCallback="configure")
class BasicAuthIT {
    @Inject
    private TestDirectory testDirectory;
    @Inject
    private DatabaseManagementService managementService;
    @Inject
    private DbmsController dbmsController;
    @Inject
    private AuthManager authManager;

    BasicAuthIT() {
    }

    @ExtensionCallback
    void configure(TestDatabaseManagementServiceBuilder builder) {
        builder.setConfig(GraphDatabaseSettings.auth_enabled, (Object)false);
    }

    @Test
    void shouldCreateUserWithAuthDisabled() throws Exception {
        GraphDatabaseService systemDatabase = this.managementService.database("system");
        try (Transaction tx = systemDatabase.beginTx();){
            tx.execute("CREATE USER foo SET PASSWORD 'bar'").close();
            tx.commit();
        }
        this.dbmsController.restartDbms(builder -> builder.setConfig(GraphDatabaseSettings.auth_enabled, (Object)true));
        LoginContext loginContext = this.authManager.login(AuthToken.newBasicAuthToken((String)"foo", (String)"wrong"), ClientConnectionInfo.EMBEDDED_CONNECTION);
        MatcherAssert.assertThat((Object)loginContext.subject().getAuthenticationResult(), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
        loginContext = this.authManager.login(AuthToken.newBasicAuthToken((String)"foo", (String)"bar"), ClientConnectionInfo.EMBEDDED_CONNECTION);
        MatcherAssert.assertThat((Object)loginContext.subject().getAuthenticationResult(), (Matcher)Matchers.equalTo((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED));
    }
}

