/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.junit.jupiter.api.Assertions;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.systemgraph.BasicSystemGraphRealm;
import org.neo4j.server.security.systemgraph.SystemGraphRealmHelper;
import org.neo4j.string.UTF8;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.rule.TestDirectory;

public class BasicSystemGraphRealmTestHelper {
    private static Map<String, Object> testAuthenticationToken(String username, String password) {
        TreeMap<String, Object> authToken = new TreeMap<String, Object>();
        authToken.put("principal", username);
        authToken.put("credentials", UTF8.encode((String)password));
        authToken.put("scheme", "basic");
        return authToken;
    }

    public static void assertAuthenticationSucceeds(SystemGraphRealmHelper realmHelper, String username, String password) throws Exception {
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(realmHelper, username, password, false);
    }

    public static void assertAuthenticationSucceeds(SystemGraphRealmHelper realmHelper, String username, String password, boolean changeRequired) throws Exception {
        User user = realmHelper.getUser(username);
        Assertions.assertTrue((boolean)user.credentials().matchesPassword(SecurityTestUtils.password((String)password)));
        Assertions.assertEquals((Object)changeRequired, (Object)user.passwordChangeRequired());
    }

    public static void assertAuthenticationFails(SystemGraphRealmHelper realmHelper, String username, String password) throws Exception {
        User user = realmHelper.getUser(username);
        Assertions.assertFalse((boolean)user.credentials().matchesPassword(SecurityTestUtils.password((String)password)));
    }

    static void assertAuthenticationFailsWithTooManyAttempts(BasicSystemGraphRealm realm, String username, String badPassword, int attempts) throws InvalidAuthTokenException {
        for (int i = 0; i < attempts; ++i) {
            LoginContext login = realm.login(BasicSystemGraphRealmTestHelper.testAuthenticationToken(username, badPassword), ClientConnectionInfo.EMBEDDED_CONNECTION);
            if (AuthenticationResult.SUCCESS.equals((Object)login.subject().getAuthenticationResult())) {
                Assertions.fail((String)"Unexpectedly succeeded in logging in");
                continue;
            }
            if (!AuthenticationResult.TOO_MANY_ATTEMPTS.equals((Object)login.subject().getAuthenticationResult())) continue;
            return;
        }
        Assertions.fail((String)("Did not get an ExcessiveAttemptsException after " + attempts + " attempts."));
    }

    public static User createUser(String userName, String password, boolean pwdChangeRequired) {
        return new User.Builder(userName, (Credential)SecurityTestUtils.credentialFor((String)password)).withRequiredPasswordChange(pwdChangeRequired).build();
    }

    public static class TestDatabaseManager
    extends LifecycleAdapter
    implements DatabaseManager<StandaloneDatabaseContext> {
        protected GraphDatabaseFacade testSystemDb;
        protected final DatabaseManagementService managementService;
        private final DatabaseIdRepository.Caching databaseIdRepository = new TestDatabaseIdRepository();

        protected TestDatabaseManager(TestDirectory testDir) {
            this.managementService = this.createManagementService(testDir);
            this.testSystemDb = (GraphDatabaseFacade)this.managementService.database("system");
        }

        protected DatabaseManagementService createManagementService(TestDirectory testDir) {
            return new TestDatabaseManagementServiceBuilder(testDir.homePath()).impermanent().noOpSystemGraphInitializer().setConfig(GraphDatabaseSettings.auth_enabled, (Object)false).build();
        }

        public DatabaseManagementService getManagementService() {
            return this.managementService;
        }

        public Optional<StandaloneDatabaseContext> getDatabaseContext(NamedDatabaseId namedDatabaseId) {
            if (namedDatabaseId.isSystemDatabase()) {
                DependencyResolver dependencyResolver = this.testSystemDb.getDependencyResolver();
                Database database = (Database)dependencyResolver.resolveDependency(Database.class);
                return Optional.of(new StandaloneDatabaseContext(database));
            }
            return Optional.empty();
        }

        public StandaloneDatabaseContext createDatabase(NamedDatabaseId namedDatabaseId) {
            throw new UnsupportedOperationException("Call to createDatabase not expected");
        }

        public void dropDatabase(NamedDatabaseId namedDatabaseId) {
        }

        public void stopDatabase(NamedDatabaseId namedDatabaseId) {
        }

        public void startDatabase(NamedDatabaseId namedDatabaseId) {
        }

        public DatabaseIdRepository.Caching databaseIdRepository() {
            return this.databaseIdRepository;
        }

        public SortedMap<NamedDatabaseId, StandaloneDatabaseContext> registeredDatabases() {
            return Collections.emptySortedMap();
        }
    }
}

