/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.time.Clock;
import java.util.function.Supplier;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.security.FormatException;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.dbms.database.DefaultSystemGraphComponent;
import org.neo4j.dbms.database.DefaultSystemGraphInitializer;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.security.BasicSystemGraphRealmTestHelper;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.BasicSystemGraphRealm;
import org.neo4j.server.security.systemgraph.SystemGraphRealmHelper;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
class BasicSystemGraphRealmIT {
    private BasicSystemGraphRealmTestHelper.TestDatabaseManager dbManager;
    private SystemGraphRealmHelper realmHelper;
    private Config defaultConfig;
    @Inject
    private TestDirectory testDirectory;
    private UserRepository oldUsers;
    private UserRepository initialPassword;
    private BasicSystemGraphRealm realm;
    private SystemGraphInitializer systemGraphInitializer;

    BasicSystemGraphRealmIT() {
    }

    @BeforeEach
    void setUp() {
        this.dbManager = new BasicSystemGraphRealmTestHelper.TestDatabaseManager(this.testDirectory);
        SecureHasher secureHasher = new SecureHasher();
        this.realmHelper = new SystemGraphRealmHelper(SystemGraphRealmHelper.makeSystemSupplier((DatabaseManager)this.dbManager), secureHasher);
        this.defaultConfig = Config.defaults();
        this.oldUsers = new InMemoryUserRepository();
        this.initialPassword = new InMemoryUserRepository();
    }

    @AfterEach
    void tearDown() {
        this.dbManager.getManagementService().shutdown();
    }

    @Test
    void shouldCreateDefaultUserIfNoneExist() throws Throwable {
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "neo4j", true);
    }

    @Test
    void shouldLoadInitialUserWithInitialPassword() throws Throwable {
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "123", false));
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "123");
    }

    @Test
    void shouldLoadInitialUserWithInitialPasswordOnRestart() throws Throwable {
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "neo4j", true);
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "abc", false));
        this.systemGraphInitializer.start();
        BasicSystemGraphRealmTestHelper.assertAuthenticationFails(this.realmHelper, "neo4j", "neo4j");
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "abc");
    }

    @Test
    void shouldNotLoadInitialUserWithInitialPasswordOnRestartWhenAlreadyChanged() throws Throwable {
        this.startSystemGraphRealm();
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "neo4j2", false));
        this.systemGraphInitializer.start();
        this.initialPassword.clear();
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "abc", false));
        this.systemGraphInitializer.start();
        BasicSystemGraphRealmTestHelper.assertAuthenticationFails(this.realmHelper, "neo4j", "neo4j");
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "neo4j2");
        BasicSystemGraphRealmTestHelper.assertAuthenticationFails(this.realmHelper, "neo4j", "abc");
    }

    @Test
    void shouldNotAddInitialUserIfUsersExist() throws Throwable {
        User initUser;
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "123", false));
        this.oldUsers.create(BasicSystemGraphRealmTestHelper.createUser("oldUser", "321", false));
        this.startSystemGraphRealm();
        try {
            initUser = this.realmHelper.getUser("neo4j");
        }
        catch (FormatException | InvalidArgumentsException e) {
            initUser = null;
        }
        Assertions.assertNull((Object)initUser);
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "oldUser", "321");
    }

    @Test
    void shouldNotUpdateUserIfInitialUserExist() throws Throwable {
        this.oldUsers.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "oldPassword", true));
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "newPassword", false));
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "oldPassword", true);
    }

    @Test
    void shouldRateLimitAuthentication() throws Throwable {
        int maxFailedAttempts = (Integer)Config.defaults().get(GraphDatabaseSettings.auth_max_failed_attempts);
        this.oldUsers.create(BasicSystemGraphRealmTestHelper.createUser("alice", "correct", false));
        this.oldUsers.create(BasicSystemGraphRealmTestHelper.createUser("bob", "password", false));
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "alice", "correct");
        BasicSystemGraphRealmTestHelper.assertAuthenticationFailsWithTooManyAttempts(this.realm, "alice", "bad", maxFailedAttempts + 1);
        BasicSystemGraphRealmTestHelper.assertAuthenticationFailsWithTooManyAttempts(this.realm, "bob", "worse", maxFailedAttempts + 1);
    }

    @Test
    void shouldHandleCustomDefaultDatabase() throws Throwable {
        this.defaultConfig.set(GraphDatabaseSettings.default_database, (Object)"foo");
        this.oldUsers.create(BasicSystemGraphRealmTestHelper.createUser("alice", "foo", false));
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "alice", "foo");
    }

    @Test
    void shouldHandleSwitchOfDefaultDatabase() throws Throwable {
        this.oldUsers.create(BasicSystemGraphRealmTestHelper.createUser("alice", "bar", false));
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "alice", "bar");
        this.defaultConfig.set(GraphDatabaseSettings.default_database, (Object)"foo");
        this.systemGraphInitializer.start();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "alice", "bar");
        this.defaultConfig.set(GraphDatabaseSettings.default_database, (Object)"neo4j");
        this.systemGraphInitializer.start();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "alice", "bar");
    }

    private void startSystemGraphRealm() throws Exception {
        Config config = Config.defaults((Setting)DatabaseManagementSystemSettings.auth_store_directory, (Object)this.testDirectory.directory("data/dbms"));
        SystemGraphComponents systemGraphComponents = new SystemGraphComponents();
        systemGraphComponents.register((SystemGraphComponent)new DefaultSystemGraphComponent(config));
        systemGraphComponents.register((SystemGraphComponent)new UserSecurityGraphComponent((AbstractSecurityLog)Mockito.mock(AbstractSecurityLog.class), this.oldUsers, this.initialPassword, config));
        Supplier systemGraphSupplier = SystemGraphRealmHelper.makeSystemSupplier((DatabaseManager)this.dbManager);
        this.systemGraphInitializer = new DefaultSystemGraphInitializer(systemGraphSupplier, systemGraphComponents);
        this.systemGraphInitializer.start();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy(Clock.systemUTC(), config);
        this.realm = new BasicSystemGraphRealm(this.realmHelper, (AuthenticationStrategy)authStrategy);
    }
}

