/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.DefaultSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponentVersion;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@TestDirectoryExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class UserSecurityGraphComponentTest {
    @Inject
    private static TestDirectory directory;
    private static DatabaseManagementService dbms;
    private static GraphDatabaseFacade system;
    private static SystemGraphComponents systemGraphComponents;
    private static UserSecurityGraphComponent userSecurityGraphComponent;
    private static AuthManager authManager;

    UserSecurityGraphComponentTest() {
    }

    @BeforeAll
    static void setup() throws IOException, InvalidArgumentsException {
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.auth_enabled, (Object)Boolean.TRUE).set(GraphDatabaseSettings.allow_single_automatic_upgrade, (Object)Boolean.FALSE).build();
        dbms = new TestDatabaseManagementServiceBuilder(directory.homePath()).impermanent().setConfig(cfg).noOpSystemGraphInitializer().build();
        system = (GraphDatabaseFacade)dbms.database("system");
        DependencyResolver resolver = system.getDependencyResolver();
        systemGraphComponents = (SystemGraphComponents)resolver.resolveDependency(SystemGraphComponents.class);
        authManager = (AuthManager)resolver.resolveDependency(AuthManager.class);
        systemGraphComponents.deregister("security-users");
        InMemoryUserRepository oldUsers = new InMemoryUserRepository();
        User oldUser = new User.Builder("alice", (Credential)SecurityTestUtils.credentialFor((String)"secret")).withRequiredPasswordChange(false).build();
        oldUsers.create(oldUser);
        InMemoryUserRepository initialPassword = new InMemoryUserRepository();
        userSecurityGraphComponent = new UserSecurityGraphComponent((AbstractSecurityLog)CommunitySecurityLog.NULL_LOG, (UserRepository)oldUsers, (UserRepository)initialPassword, Config.defaults());
        systemGraphComponents.register((SystemGraphComponent)userSecurityGraphComponent);
        systemGraphComponents.deregister("dbms-runtime");
    }

    @BeforeEach
    void clear() throws Exception {
        UserSecurityGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> tx.getAllNodes().stream().forEach(n -> {
            n.getRelationships().forEach(Relationship::delete);
            n.delete();
        })));
    }

    @AfterAll
    static void tearDown() {
        dbms.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"supportedPreviousVersions"})
    void shouldAuthenticate(UserSecurityGraphComponentVersion version) throws Exception {
        UserSecurityGraphComponentTest.initializeLatestSystem();
        UserSecurityGraphComponentTest.initUserSecurityComponent(version);
        LoginContext loginContext = authManager.login(AuthToken.newBasicAuthToken((String)"neo4j", (String)"neo4j"), ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertThat((Comparable)loginContext.subject().getAuthenticationResult()).isEqualTo((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
    }

    @Test
    void shouldInitializeDefaultVersion() throws Exception {
        systemGraphComponents.initializeSystemGraph((GraphDatabaseService)system);
        HashMap statuses = new HashMap();
        UserSecurityGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            systemGraphComponents.forEach(component -> statuses.put(component.componentName(), component.detect(tx)));
            statuses.put("dbms-status", systemGraphComponents.detect(tx));
        }));
        MatcherAssert.assertThat((String)"Expecting three components", (Object)statuses.size(), (Matcher)Matchers.is((Object)3));
        MatcherAssert.assertThat((String)"System graph status", (Object)((SystemGraphComponent.Status)statuses.get("multi-database")), (Matcher)Matchers.is((Object)SystemGraphComponent.Status.CURRENT));
        MatcherAssert.assertThat((String)"Users status", (Object)((SystemGraphComponent.Status)statuses.get("security-users")), (Matcher)Matchers.is((Object)SystemGraphComponent.Status.CURRENT));
        MatcherAssert.assertThat((String)"Overall status", (Object)((SystemGraphComponent.Status)statuses.get("dbms-status")), (Matcher)Matchers.is((Object)SystemGraphComponent.Status.CURRENT));
    }

    @ParameterizedTest
    @MethodSource(value={"versionAndStatusProvider"})
    void shouldInitializeAndUpgradeSystemGraph(UserSecurityGraphComponentVersion version, SystemGraphComponent.Status initialStatus) throws Exception {
        UserSecurityGraphComponentTest.initializeLatestSystem();
        UserSecurityGraphComponentTest.initUserSecurityComponent(version);
        UserSecurityGraphComponentTest.assertCanUpgradeThisVersionAndThenUpgradeIt(initialStatus);
    }

    static Stream<Arguments> versionAndStatusProvider() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_35, SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE}), Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_40, SystemGraphComponent.Status.REQUIRES_UPGRADE}), Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_41, SystemGraphComponent.Status.REQUIRES_UPGRADE}), Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_43D4, SystemGraphComponent.Status.CURRENT}));
    }

    @Test
    void shouldAddUserOnUpgradeFrom3_5() throws Exception {
        UserSecurityGraphComponentTest.initializeLatestSystem();
        UserSecurityGraphComponentTest.initUserSecurityComponent(UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_35);
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        HashMap<String, Object> usernameAndIds = this.getUserNamesAndIds();
        MatcherAssert.assertThat((Object)usernameAndIds.get("alice"), (Matcher)Matchers.notNullValue());
    }

    @ParameterizedTest
    @MethodSource(value={"supportedPreviousVersions"})
    void shouldAddUserIdsOnUpgradeFromOlderSystemDb(UserSecurityGraphComponentVersion version) throws Exception {
        UserSecurityGraphComponentTest.initializeLatestSystem();
        UserSecurityGraphComponentTest.initUserSecurityComponent(version);
        this.createUser(version, "alice");
        HashMap<String, Object> usernameAndIdsBeforeUpgrade = this.getUserNamesAndIds();
        MatcherAssert.assertThat((Object)usernameAndIdsBeforeUpgrade.get("neo4j"), (Matcher)Matchers.equalTo(null));
        MatcherAssert.assertThat((Object)usernameAndIdsBeforeUpgrade.get("alice"), (Matcher)Matchers.equalTo(null));
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        HashMap<String, Object> usernameAndIdsAfterUpgrade = this.getUserNamesAndIds();
        MatcherAssert.assertThat((Object)usernameAndIdsAfterUpgrade.get("neo4j"), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)usernameAndIdsAfterUpgrade.get("alice"), (Matcher)Matchers.notNullValue());
    }

    private static Stream<Arguments> supportedPreviousVersions() {
        return Arrays.stream(UserSecurityGraphComponentVersion.values()).filter(version -> version.runtimeSupported() && version.getVersion() < UserSecurityGraphComponentVersion.LATEST_COMMUNITY_SECURITY_COMPONENT_VERSION).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static void assertCanUpgradeThisVersionAndThenUpgradeIt(SystemGraphComponent.Status initialState) throws Exception {
        SystemGraphComponents systemGraphComponents = (SystemGraphComponents)system.getDependencyResolver().resolveDependency(SystemGraphComponents.class);
        UserSecurityGraphComponentTest.assertStatus(Map.of("multi-database", SystemGraphComponent.Status.CURRENT, "security-users", initialState, "dbms-status", initialState));
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        UserSecurityGraphComponentTest.assertStatus(Map.of("multi-database", SystemGraphComponent.Status.CURRENT, "security-users", SystemGraphComponent.Status.CURRENT, "dbms-status", SystemGraphComponent.Status.CURRENT));
    }

    private static void assertStatus(Map<String, SystemGraphComponent.Status> expected) throws Exception {
        HashMap statuses = new HashMap();
        UserSecurityGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            systemGraphComponents.forEach(component -> statuses.put(component.componentName(), component.detect(tx)));
            statuses.put("dbms-status", systemGraphComponents.detect(tx));
        }));
        for (Map.Entry<String, SystemGraphComponent.Status> entry : expected.entrySet()) {
            MatcherAssert.assertThat((String)entry.getKey(), (Object)((SystemGraphComponent.Status)statuses.get(entry.getKey())), (Matcher)Matchers.is((Object)entry.getValue()));
        }
    }

    private HashMap<String, Object> getUserNamesAndIds() {
        HashMap<String, Object> usernameAndIds = new HashMap<String, Object>();
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            ResourceIterator nodes = tx.findNodes(KnownCommunitySecurityComponentVersion.USER_LABEL);
            while (nodes.hasNext()) {
                Object userId;
                Node userNode = (Node)nodes.next();
                String username = userNode.getProperty("name").toString();
                try {
                    userId = userNode.getProperty("id");
                }
                catch (NotFoundException e) {
                    userId = null;
                }
                usernameAndIds.put(username, userId);
            }
        }
        return usernameAndIds;
    }

    private void createUser(UserSecurityGraphComponentVersion version, String name) {
        KnownCommunitySecurityComponentVersion builder = userSecurityGraphComponent.findSecurityGraphComponentVersion((ComponentVersion)version);
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            builder.addUser((Transaction)tx, name, (Credential)SecurityTestUtils.credentialFor((String)"abc123"), false, false);
            tx.commit();
        }
    }

    private static void initializeLatestSystem() throws Exception {
        DefaultSystemGraphComponent systemGraphComponent = new DefaultSystemGraphComponent(Config.defaults());
        systemGraphComponent.initializeSystemGraph((GraphDatabaseService)system, true);
    }

    private static void initUserSecurityComponent(UserSecurityGraphComponentVersion version) throws Exception {
        KnownCommunitySecurityComponentVersion builder = userSecurityGraphComponent.findSecurityGraphComponentVersion((ComponentVersion)version);
        UserSecurityGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> userSecurityGraphComponent.initializeSystemGraphConstraints(tx)));
        switch (version) {
            case COMMUNITY_SECURITY_40: {
                UserSecurityGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)arg_0 -> ((KnownCommunitySecurityComponentVersion)builder).setupUsers(arg_0)));
                break;
            }
            case COMMUNITY_SECURITY_41: 
            case COMMUNITY_SECURITY_43D4: {
                UserSecurityGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)arg_0 -> ((KnownCommunitySecurityComponentVersion)builder).setupUsers(arg_0)));
                UserSecurityGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> builder.setVersionProperty(tx, version.getVersion())));
                break;
            }
        }
    }

    private static void inTx(ThrowingConsumer<Transaction, Exception> consumer) throws Exception {
        try (Transaction tx = system.beginTx();){
            consumer.accept((Object)tx);
            tx.commit();
        }
    }
}

