/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponentVersion;
import org.neo4j.server.security.systemgraph.versions.KnownCommunitySecurityComponentVersion;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class UserSecurityGraphComponentIT {
    @Inject
    private static TestDirectory directory;
    private static DatabaseManagementService dbms;
    private static GraphDatabaseFacade system;
    private static SystemGraphComponents systemGraphComponents;
    private static UserSecurityGraphComponent userSecurityGraphComponent;
    private static AuthManager authManager;

    UserSecurityGraphComponentIT() {
    }

    @BeforeAll
    static void setup() {
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.auth_enabled, (Object)Boolean.TRUE).set(GraphDatabaseInternalSettings.allow_single_automatic_upgrade, (Object)Boolean.FALSE).build();
        dbms = new TestDatabaseManagementServiceBuilder(directory.homePath()).impermanent().setConfig(cfg).noOpSystemGraphInitializer().build();
        system = (GraphDatabaseFacade)dbms.database("system");
        DependencyResolver resolver = system.getDependencyResolver();
        authManager = (AuthManager)resolver.resolveDependency(AuthManager.class);
        userSecurityGraphComponent = new UserSecurityGraphComponent((UserRepository)new InMemoryUserRepository(), Config.defaults(), (LogProvider)NullLogProvider.getInstance(), (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG);
        systemGraphComponents = (SystemGraphComponents)resolver.resolveDependency(SystemGraphComponents.class);
        systemGraphComponents.deregister("dbms-runtime");
    }

    @BeforeEach
    void clear() throws Exception {
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> Iterables.forEach((Iterable)tx.getAllNodes(), n -> {
            Iterables.forEach((Iterable)n.getRelationships(), Entity::delete);
            n.delete();
        })));
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> tx.schema().getConstraints().forEach(ConstraintDefinition::drop)));
        systemGraphComponents.deregister("security-users");
        systemGraphComponents.initializeSystemGraph((GraphDatabaseService)system);
    }

    @AfterAll
    static void tearDown() {
        dbms.shutdown();
    }

    @ParameterizedTest
    @MethodSource(value={"supportedPreviousVersions"})
    void shouldAuthenticate(UserSecurityGraphComponentVersion version) throws Exception {
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        LoginContext loginContext = authManager.login(AuthToken.newBasicAuthToken((String)"neo4j", (String)"neo4j"), ClientConnectionInfo.EMBEDDED_CONNECTION);
        Assertions.assertThat((Comparable)loginContext.subject().getAuthenticationResult()).isEqualTo((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
    }

    @Test
    void shouldInitializeDefaultVersion() throws Exception {
        userSecurityGraphComponent.initializeSystemGraph((GraphDatabaseService)system, true);
        systemGraphComponents.register((SystemGraphComponent)userSecurityGraphComponent);
        HashMap statuses = new HashMap();
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            systemGraphComponents.forEach(component -> statuses.put(component.componentName(), component.detect(tx)));
            statuses.put("dbms-status", systemGraphComponents.detect(tx));
        }));
        org.junit.jupiter.api.Assertions.assertEquals((int)statuses.size(), (int)4, (String)"Expecting four components");
        org.junit.jupiter.api.Assertions.assertEquals((Object)SystemGraphComponent.Status.CURRENT, statuses.get("multi-database"), (String)"System graph status");
        org.junit.jupiter.api.Assertions.assertEquals((Object)SystemGraphComponent.Status.CURRENT, statuses.get("security-users"), (String)"Users status");
        org.junit.jupiter.api.Assertions.assertEquals((Object)SystemGraphComponent.Status.CURRENT, statuses.get("community-topology-graph"), (String)"Community topology graph status");
        org.junit.jupiter.api.Assertions.assertEquals((Object)SystemGraphComponent.Status.CURRENT, statuses.get("dbms-status"), (String)"Overall status");
    }

    @ParameterizedTest
    @MethodSource(value={"versionAndStatusProvider"})
    void shouldInitializeAndUpgradeSystemGraph(UserSecurityGraphComponentVersion version, SystemGraphComponent.Status initialStatus) throws Exception {
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        UserSecurityGraphComponentIT.assertCanUpgradeThisVersionAndThenUpgradeIt(initialStatus);
    }

    static Stream<Arguments> versionAndStatusProvider() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_40, SystemGraphComponent.Status.REQUIRES_UPGRADE}), Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_41, SystemGraphComponent.Status.REQUIRES_UPGRADE}), Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_43D4, SystemGraphComponent.Status.REQUIRES_UPGRADE}), Arguments.arguments((Object[])new Object[]{UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_50, SystemGraphComponent.Status.CURRENT}));
    }

    @ParameterizedTest
    @MethodSource(value={"beforeUserId"})
    void shouldAddUserIdsOnUpgradeFromOlderSystemDb(UserSecurityGraphComponentVersion version) throws Exception {
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        this.createUser(version, "alice");
        HashMap<String, Object> usernameAndIdsBeforeUpgrade = this.getUserNamesAndIds();
        Assertions.assertThat((Object)usernameAndIdsBeforeUpgrade.get("neo4j")).isNull();
        Assertions.assertThat((Object)usernameAndIdsBeforeUpgrade.get("alice")).isNull();
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        HashMap<String, Object> usernameAndIdsAfterUpgrade = this.getUserNamesAndIds();
        Assertions.assertThat((Object)usernameAndIdsAfterUpgrade.get("neo4j")).isNotNull();
        Assertions.assertThat((Object)usernameAndIdsAfterUpgrade.get("alice")).isNotNull();
    }

    @ParameterizedTest
    @MethodSource(value={"beforeUserIdConstraint"})
    void shouldAddConstraintForUserIdsOnUpgradeFromOlderSystemDb(UserSecurityGraphComponentVersion version) throws Exception {
        Iterable constraints;
        UserSecurityGraphComponentIT.initUserSecurityComponent(version);
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            constraints = tx.schema().getConstraints(KnownCommunitySecurityComponentVersion.USER_LABEL);
            for (ConstraintDefinition constraint : constraints) {
                for (String property : constraint.getPropertyKeys()) {
                    Assertions.assertThat((String)property).isIn(new Object[]{"name"});
                }
            }
            tx.commit();
        }
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
        try {
            constraints = tx.schema().getConstraints(KnownCommunitySecurityComponentVersion.USER_LABEL);
            for (ConstraintDefinition constraint : constraints) {
                for (String property : constraint.getPropertyKeys()) {
                    Assertions.assertThat((String)property).isIn(new Object[]{"name", "id"});
                }
            }
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static Stream<Arguments> supportedPreviousVersions() {
        return Arrays.stream(UserSecurityGraphComponentVersion.values()).filter(version -> version.runtimeSupported() && !version.isCurrent()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Stream<Arguments> beforeUserId() {
        return Arrays.stream(UserSecurityGraphComponentVersion.values()).filter(version -> version.runtimeSupported() && version.getVersion() < UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_43D4.getVersion()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static Stream<Arguments> beforeUserIdConstraint() {
        return Arrays.stream(UserSecurityGraphComponentVersion.values()).filter(version -> version.runtimeSupported() && version.getVersion() < UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_50.getVersion()).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private static void assertCanUpgradeThisVersionAndThenUpgradeIt(SystemGraphComponent.Status initialState) throws Exception {
        SystemGraphComponents systemGraphComponents = (SystemGraphComponents)system.getDependencyResolver().resolveDependency(SystemGraphComponents.class);
        UserSecurityGraphComponentIT.assertStatus(Map.of("multi-database", SystemGraphComponent.Status.CURRENT, "security-users", initialState, "community-topology-graph", SystemGraphComponent.Status.CURRENT, "dbms-status", initialState));
        systemGraphComponents.upgradeToCurrent((GraphDatabaseService)system);
        UserSecurityGraphComponentIT.assertStatus(Map.of("multi-database", SystemGraphComponent.Status.CURRENT, "security-users", SystemGraphComponent.Status.CURRENT, "community-topology-graph", SystemGraphComponent.Status.CURRENT, "dbms-status", SystemGraphComponent.Status.CURRENT));
    }

    private static void assertStatus(Map<String, SystemGraphComponent.Status> expected) throws Exception {
        HashMap statuses = new HashMap();
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            systemGraphComponents.forEach(component -> statuses.put(component.componentName(), component.detect(tx)));
            statuses.put("dbms-status", systemGraphComponents.detect(tx));
        }));
        for (Map.Entry<String, SystemGraphComponent.Status> entry : expected.entrySet()) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)entry.getValue(), statuses.get(entry.getKey()), (String)entry.getKey());
        }
    }

    private HashMap<String, Object> getUserNamesAndIds() {
        HashMap<String, Object> usernameAndIds = new HashMap<String, Object>();
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);
             ResourceIterator nodes = tx.findNodes(KnownCommunitySecurityComponentVersion.USER_LABEL);){
            while (nodes.hasNext()) {
                Object userId;
                Node userNode = (Node)nodes.next();
                String username = userNode.getProperty("name").toString();
                try {
                    userId = userNode.getProperty("id");
                }
                catch (NotFoundException e) {
                    userId = null;
                }
                usernameAndIds.put(username, userId);
            }
        }
        return usernameAndIds;
    }

    private void createUser(UserSecurityGraphComponentVersion version, String name) {
        KnownCommunitySecurityComponentVersion builder = userSecurityGraphComponent.findSecurityGraphComponentVersion((ComponentVersion)version);
        try (InternalTransaction tx = system.beginTransaction(KernelTransaction.Type.EXPLICIT, LoginContext.AUTH_DISABLED);){
            builder.addUser((Transaction)tx, name, (Credential)SecurityTestUtils.credentialFor((String)"abc123"), false, false);
            tx.commit();
        }
    }

    private static void initUserSecurityComponent(UserSecurityGraphComponentVersion version) throws Exception {
        KnownCommunitySecurityComponentVersion builder = userSecurityGraphComponent.findSecurityGraphComponentVersion((ComponentVersion)version);
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> tx.schema().constraintFor(KnownCommunitySecurityComponentVersion.USER_LABEL).assertPropertyIsUnique("name").create()));
        UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)arg_0 -> ((KnownCommunitySecurityComponentVersion)builder).setupUsers(arg_0)));
        if (version != UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_40) {
            UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> builder.setVersionProperty(tx, version.getVersion())));
        }
        if (version.getVersion() >= UserSecurityGraphComponentVersion.COMMUNITY_SECURITY_50.getVersion()) {
            UserSecurityGraphComponentIT.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> tx.schema().constraintFor(KnownCommunitySecurityComponentVersion.USER_LABEL).assertPropertyIsUnique("id").create()));
        }
        userSecurityGraphComponent.postInitialization((GraphDatabaseService)system, true);
        systemGraphComponents.register((SystemGraphComponent)userSecurityGraphComponent);
    }

    private static void inTx(ThrowingConsumer<Transaction, Exception> consumer) throws Exception {
        try (Transaction tx = system.beginTx();){
            consumer.accept((Object)tx);
            tx.commit();
        }
    }
}

