/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.time.Clock;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.cypher.internal.security.SecureHasher;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DefaultSystemGraphComponent;
import org.neo4j.dbms.database.DefaultSystemGraphInitializer;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.security.BasicSystemGraphRealmTestHelper;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.systemgraph.SystemGraphRealmHelper;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
class UserSecurityGraphInitializationIT {
    private BasicSystemGraphRealmTestHelper.TestDatabaseContextProvider dbManager;
    private SystemGraphRealmHelper realmHelper;
    @Inject
    private TestDirectory testDirectory;
    private UserRepository initialPassword;
    private SystemGraphInitializer systemGraphInitializer;

    UserSecurityGraphInitializationIT() {
    }

    @BeforeEach
    void setUp() {
        this.dbManager = new BasicSystemGraphRealmTestHelper.TestDatabaseContextProvider(this.testDirectory);
        SecureHasher secureHasher = new SecureHasher();
        this.realmHelper = new SystemGraphRealmHelper(SystemGraphRealmHelper.makeSystemSupplier((DatabaseContextProvider)this.dbManager), secureHasher);
        this.initialPassword = new InMemoryUserRepository();
    }

    @AfterEach
    void tearDown() {
        this.dbManager.getManagementService().shutdown();
    }

    @Test
    void shouldCreateDefaultUserIfNoneExist() throws Throwable {
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "neo4j", true);
    }

    @Test
    void shouldLoadInitialUserWithInitialPassword() throws Throwable {
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "123", false));
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "123");
    }

    @Test
    void shouldLoadInitialUserWithInitialPasswordOnRestart() throws Throwable {
        this.startSystemGraphRealm();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "neo4j", true);
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "abc", false));
        this.systemGraphInitializer.start();
        BasicSystemGraphRealmTestHelper.assertAuthenticationFails(this.realmHelper, "neo4j", "neo4j");
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "abc");
    }

    @Test
    void shouldNotLoadInitialUserWithInitialPasswordOnRestartWhenAlreadyChanged() throws Throwable {
        this.startSystemGraphRealm();
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "neo4j2", false));
        this.systemGraphInitializer.start();
        this.initialPassword.clear();
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "abc", false));
        this.systemGraphInitializer.start();
        BasicSystemGraphRealmTestHelper.assertAuthenticationFails(this.realmHelper, "neo4j", "neo4j");
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "neo4j2");
        BasicSystemGraphRealmTestHelper.assertAuthenticationFails(this.realmHelper, "neo4j", "abc");
    }

    @Test
    void shouldNotLoadInitialUserWithInitialPasswordWhenOtherUsersExist() throws Throwable {
        this.startSystemGraphRealm();
        try (Transaction tx = this.dbManager.testSystemDb.beginTx();){
            tx.execute("CREATE USER Alice SET PASSWORD 'meh'");
            tx.commit();
        }
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "neo4j2", false));
        this.systemGraphInitializer.start();
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(this.realmHelper, "neo4j", "neo4j", true);
        BasicSystemGraphRealmTestHelper.assertAuthenticationFails(this.realmHelper, "neo4j", "neo4j2");
    }

    @Test
    void shouldNotReCreateInitialUser() throws Throwable {
        this.startSystemGraphRealm();
        try (Transaction tx = this.dbManager.testSystemDb.beginTx();){
            tx.execute(String.format("DROP USER %s", "neo4j"));
            tx.commit();
        }
        this.initialPassword.create(BasicSystemGraphRealmTestHelper.createUser("neo4j", "neo4j2", false));
        this.systemGraphInitializer.start();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.realmHelper.getUser("neo4j")).isInstanceOf(InvalidArgumentsException.class)).hasMessage(String.format("User '%s' does not exist.", "neo4j"));
    }

    private void startSystemGraphRealm() throws Exception {
        Config config = Config.defaults((Setting)GraphDatabaseInternalSettings.auth_store_directory, (Object)this.testDirectory.directory("data/dbms"));
        SystemGraphComponents systemGraphComponents = new SystemGraphComponents();
        systemGraphComponents.register((SystemGraphComponent)new DefaultSystemGraphComponent(config, Clock.systemUTC()));
        systemGraphComponents.register((SystemGraphComponent)new UserSecurityGraphComponent(this.initialPassword, config, (LogProvider)NullLogProvider.getInstance(), (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG));
        Supplier systemGraphSupplier = SystemGraphRealmHelper.makeSystemSupplier((DatabaseContextProvider)this.dbManager);
        this.systemGraphInitializer = new DefaultSystemGraphInitializer(systemGraphSupplier, systemGraphComponents);
        this.systemGraphInitializer.start();
    }
}

