/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.time.Clock;
import java.util.Iterator;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.DefaultSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphComponent;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class CommunityTopologyGraphComponentTest {
    @Inject
    private static TestDirectory directory;
    private static DatabaseManagementService dbms;
    private static GraphDatabaseService system;

    CommunityTopologyGraphComponentTest() {
    }

    @BeforeAll
    static void setup() {
        dbms = new TestDatabaseManagementServiceBuilder(directory.homePath()).impermanent().setConfig(Map.of(GraphDatabaseInternalSettings.trace_cursors, true)).noOpSystemGraphInitializer().build();
        system = dbms.database("system");
    }

    @BeforeEach
    void clear() throws Exception {
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> Iterables.forEach((Iterable)tx.getAllNodes(), n -> {
            Iterables.forEach((Iterable)n.getRelationships(), Entity::delete);
            n.delete();
        })));
    }

    @AfterAll
    static void tearDown() {
        dbms.shutdown();
    }

    @Test
    void shouldDetectUninitialized() throws Exception {
        CommunityTopologyGraphComponentTest.initializeSystem();
        CommunityTopologyGraphComponent component = new CommunityTopologyGraphComponent(Config.defaults(), (InternalLogProvider)NullLogProvider.getInstance());
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            SystemGraphComponent.Status status = component.detect(tx);
            Assertions.assertThat((Comparable)status).isEqualTo((Object)SystemGraphComponent.Status.UNINITIALIZED);
        }));
    }

    @Test
    void shouldDetectStatusForLatest() throws Exception {
        CommunityTopologyGraphComponentTest.initializeSystem();
        CommunityTopologyGraphComponent component = new CommunityTopologyGraphComponent(Config.defaults(), (InternalLogProvider)NullLogProvider.getInstance());
        component.initializeSystemGraph(system, true);
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            SystemGraphComponent.Status status = component.detect(tx);
            Assertions.assertThat((Comparable)status).isEqualTo((Object)SystemGraphComponent.Status.CURRENT);
        }));
    }

    @Test
    void shouldSetAccessToReadWriteOnInitialization() throws Exception {
        CommunityTopologyGraphComponentTest.initializeSystem();
        CommunityTopologyGraphComponent component = new CommunityTopologyGraphComponent(Config.defaults(), (InternalLogProvider)NullLogProvider.getInstance());
        component.initializeSystemGraph(system, true);
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            Node defaultDbNode = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)"neo4j");
            String defaultDbAccess = defaultDbNode.getProperty("access").toString();
            Assertions.assertThat((String)defaultDbAccess).isEqualTo(TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
            Node systemDbNode = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)"system");
            String systemDbAccess = systemDbNode.getProperty("access").toString();
            Assertions.assertThat((String)systemDbAccess).isEqualTo(TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
        }));
    }

    @Test
    void shouldSetAccessToReadWriteOnUpgrade() throws Exception {
        CommunityTopologyGraphComponentTest.initializeSystem();
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            Node dbNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_LABEL});
            dbNode.setProperty("name", (Object)"custom");
        }));
        CommunityTopologyGraphComponent component = new CommunityTopologyGraphComponent(Config.defaults(), (InternalLogProvider)NullLogProvider.getInstance());
        component.initializeSystemGraph(system, true);
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            Node dbNode = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)"custom");
            String dbAccess = dbNode.getProperty("access").toString();
            Assertions.assertThat((String)dbAccess).isEqualTo(TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
            Node defaultDbNode = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)"neo4j");
            String defaultDbAccess = defaultDbNode.getProperty("access").toString();
            Assertions.assertThat((String)defaultDbAccess).isEqualTo(TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
            Node systemDbNode = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)"system");
            String systemDbAccess = systemDbNode.getProperty("access").toString();
            Assertions.assertThat((String)systemDbAccess).isEqualTo(TopologyGraphDbmsModel.DatabaseAccess.READ_WRITE.toString());
        }));
    }

    @Test
    void shouldHavePrimaryAliasOnInitialization() throws Exception {
        CommunityTopologyGraphComponentTest.initializeSystem();
        CommunityTopologyGraphComponent component = new CommunityTopologyGraphComponent(Config.defaults(), (InternalLogProvider)NullLogProvider.getInstance());
        component.initializeSystemGraph(system, true);
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            CommunityTopologyGraphComponentTest.shouldHavePrimaryAlias("neo4j", tx);
            CommunityTopologyGraphComponentTest.shouldHavePrimaryAlias("system", tx);
        }));
    }

    @Test
    void shouldHavePrimaryAliasOnUpgrade() throws Exception {
        CommunityTopologyGraphComponentTest.initializeSystem();
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            Node dbNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_LABEL});
            dbNode.setProperty("name", (Object)"custom");
        }));
        CommunityTopologyGraphComponent component = new CommunityTopologyGraphComponent(Config.defaults(), (InternalLogProvider)NullLogProvider.getInstance());
        component.initializeSystemGraph(system, true);
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            CommunityTopologyGraphComponentTest.shouldHavePrimaryAlias("custom", tx);
            CommunityTopologyGraphComponentTest.shouldHavePrimaryAlias("neo4j", tx);
            CommunityTopologyGraphComponentTest.shouldHavePrimaryAlias("system", tx);
        }));
    }

    @Test
    void shouldHavePrimaryAliasOnUpgradeFromV0ToV1() throws Exception {
        CommunityTopologyGraphComponentTest.initializeSystem();
        CommunityTopologyGraphComponent component = new CommunityTopologyGraphComponent(Config.defaults(), (InternalLogProvider)NullLogProvider.getInstance());
        component.initializeSystemGraph(system, true);
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            Node nameNode = tx.findNode(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "name", (Object)"neo4j");
            nameNode.getRelationships().forEach(Entity::delete);
            nameNode.delete();
        }));
        CommunityTopologyGraphComponentTest.setComponentVersionTo(0);
        component.upgradeToCurrent(system);
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> CommunityTopologyGraphComponentTest.shouldHavePrimaryAlias("neo4j", tx)));
    }

    @Test
    void shouldHaveNamespaceAndDisplayNameOnUpgradeToV1() throws Exception {
        CommunityTopologyGraphComponentTest.initializeSystem();
        CommunityTopologyGraphComponent component = new CommunityTopologyGraphComponent(Config.defaults(), (InternalLogProvider)NullLogProvider.getInstance());
        component.initializeSystemGraph(system, true);
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL);){
                nodes.forEachRemaining(node -> {
                    node.removeProperty("namespace");
                    node.removeProperty("displayName");
                });
            }
        }));
        CommunityTopologyGraphComponentTest.setComponentVersionTo(0);
        component.upgradeToCurrent(system);
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL);){
                nodes.forEachRemaining(node -> {
                    String name = (String)node.getProperty("name");
                    Assertions.assertThat((Object)node.getProperty("displayName")).isEqualTo((Object)name);
                    Assertions.assertThat((Object)node.getProperty("namespace")).isEqualTo((Object)"system-root");
                });
            }
        }));
    }

    private static void shouldHavePrimaryAlias(String dbName, Transaction tx) {
        Node dbAlias = tx.findNode(TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "name", (Object)dbName);
        ((ObjectAssert)Assertions.assertThat((Object)dbAlias).describedAs("No aliases found for database: " + dbName, new Object[0])).isNotNull();
        Assertions.assertThat((Object)dbAlias.getProperty("primary")).isEqualTo((Object)true);
        Iterables.forEach((Iterable)dbAlias.getRelationships(new RelationshipType[]{TopologyGraphDbmsModel.TARGETS_RELATIONSHIP}), target -> Assertions.assertThat((boolean)target.getEndNode().hasLabel(TopologyGraphDbmsModel.DATABASE_LABEL)).isTrue());
    }

    private static void setComponentVersionTo(int n) throws Exception {
        CommunityTopologyGraphComponentTest.inTx((ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> ((Node)Iterators.first((Iterator)tx.findNodes(Label.label((String)"Version")))).setProperty(ComponentVersion.COMMUNITY_TOPOLOGY_GRAPH_COMPONENT.name(), (Object)n)));
    }

    private static void initializeSystem() throws Exception {
        DefaultSystemGraphComponent systemGraphComponent = new DefaultSystemGraphComponent(Config.defaults(), Clock.systemUTC());
        systemGraphComponent.initializeSystemGraph(system, true);
    }

    private static void inTx(ThrowingConsumer<Transaction, Exception> consumer) throws Exception {
        try (Transaction tx = system.beginTx();){
            consumer.accept((Object)tx);
            tx.commit();
        }
    }
}

