/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.security;

import java.util.Collections;
import java.util.NavigableMap;
import java.util.Optional;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.security.auth.SecurityTestUtils;
import org.neo4j.server.security.systemgraph.SecurityGraphHelper;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.utils.TestDirectory;

public class BasicSystemGraphRealmTestHelper {
    public static void assertAuthenticationSucceeds(SecurityGraphHelper realmHelper, String username, String password) {
        BasicSystemGraphRealmTestHelper.assertAuthenticationSucceeds(realmHelper, username, password, false);
    }

    public static void assertAuthenticationSucceeds(SecurityGraphHelper realmHelper, String username, String password, boolean changeRequired) {
        User user = realmHelper.getUserByName(username);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)user.credential().value().matchesPassword(SecurityTestUtils.password((String)password)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)user.passwordChangeRequired()).withFailMessage("Expected change required to be %s, but was %s", new Object[]{changeRequired, user.passwordChangeRequired()})).isEqualTo(changeRequired);
    }

    public static void assertAuthenticationFails(SecurityGraphHelper realmHelper, String username, String password) {
        User user = realmHelper.getUserByName(username);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)user.credential().value().matchesPassword(SecurityTestUtils.password((String)password)));
    }

    public static User createUser(String userName, String password, boolean pwdChangeRequired) {
        return new User(userName, null, (Credential)SecurityTestUtils.credentialFor((String)password), pwdChangeRequired, false);
    }

    public static class TestDatabaseContextProvider
    extends LifecycleAdapter
    implements DatabaseContextProvider<StandaloneDatabaseContext> {
        protected GraphDatabaseFacade testSystemDb;
        protected final DatabaseManagementService managementService;
        private final DatabaseIdRepository databaseIdRepository = new TestDatabaseIdRepository();

        protected TestDatabaseContextProvider(TestDirectory testDir) {
            this.managementService = this.createManagementService(testDir);
            this.testSystemDb = (GraphDatabaseFacade)this.managementService.database("system");
        }

        protected DatabaseManagementService createManagementService(TestDirectory testDir) {
            return new TestDatabaseManagementServiceBuilder(testDir.homePath()).impermanent().noOpSystemGraphInitializer().setConfig(GraphDatabaseSettings.auth_enabled, (Object)false).build();
        }

        public DatabaseManagementService getManagementService() {
            return this.managementService;
        }

        public Optional<StandaloneDatabaseContext> getDatabaseContext(NamedDatabaseId namedDatabaseId) {
            if (namedDatabaseId.isSystemDatabase()) {
                DependencyResolver dependencyResolver = this.testSystemDb.getDependencyResolver();
                Database database = (Database)dependencyResolver.resolveDependency(Database.class);
                return Optional.of(new StandaloneDatabaseContext(database));
            }
            return Optional.empty();
        }

        public Optional<StandaloneDatabaseContext> getDatabaseContext(String databaseName) {
            return this.databaseIdRepository().getByName(databaseName).flatMap(this::getDatabaseContext);
        }

        public Optional<StandaloneDatabaseContext> getDatabaseContext(DatabaseId databaseId) {
            return this.databaseIdRepository().getById(databaseId).flatMap(this::getDatabaseContext);
        }

        public DatabaseIdRepository databaseIdRepository() {
            return this.databaseIdRepository;
        }

        public NavigableMap<NamedDatabaseId, StandaloneDatabaseContext> registeredDatabases() {
            return Collections.emptyNavigableMap();
        }
    }
}

