/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.model;

import java.util.Objects;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.Event;
import org.neo4j.cdc.client.model.EventType;
import org.neo4j.cdc.client.model.State;

public abstract class EntityEvent<T extends State>
implements Event {
    private final String elementId;
    private final EventType eventType;
    private final T before;
    private final T after;
    private final EntityOperation operation;

    protected EntityEvent(String elementId, EventType eventType, EntityOperation operation, T before, T after) {
        this.elementId = Objects.requireNonNull(elementId);
        this.eventType = Objects.requireNonNull(eventType);
        this.operation = Objects.requireNonNull(operation);
        this.before = before;
        this.after = after;
    }

    public String getElementId() {
        return this.elementId;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    public EntityOperation getOperation() {
        return this.operation;
    }

    public T getBefore() {
        return this.before;
    }

    public T getAfter() {
        return this.after;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityEvent that = (EntityEvent)o;
        if (!this.elementId.equals(that.elementId)) {
            return false;
        }
        if (this.eventType != that.eventType) {
            return false;
        }
        if (!Objects.equals(this.before, that.before)) {
            return false;
        }
        if (!Objects.equals(this.after, that.after)) {
            return false;
        }
        return this.operation == that.operation;
    }

    public int hashCode() {
        int result = this.elementId.hashCode();
        result = 31 * result + this.eventType.hashCode();
        result = 31 * result + (this.before != null ? this.before.hashCode() : 0);
        result = 31 * result + (this.after != null ? this.after.hashCode() : 0);
        result = 31 * result + this.operation.hashCode();
        return result;
    }
}

