/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.pattern;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.pattern.Pattern;
import org.neo4j.cdc.client.selector.NodeSelector;
import org.neo4j.cdc.client.selector.Selector;

public class NodePattern
implements Pattern {
    @NotNull
    private final Set<String> labels;
    @NotNull
    private final Map<String, Object> keyFilters;
    @NotNull
    private final Set<String> includeProperties;
    @NotNull
    private final Set<String> excludeProperties;
    private String executingUser;
    private String authenticatedUser;
    private Map<String, Object> txMetadata;
    private EntityOperation entityOperation;
    private Set<String> changesTo = Collections.emptySet();

    public NodePattern(@NotNull Set<String> labels, @NotNull Map<String, Object> keyFilters, @NotNull Set<String> includeProperties, @NotNull Set<String> excludeProperties) {
        this.labels = Objects.requireNonNull(labels);
        this.keyFilters = Objects.requireNonNull(keyFilters);
        this.includeProperties = Objects.requireNonNull(includeProperties);
        this.excludeProperties = Objects.requireNonNull(excludeProperties);
    }

    @NotNull
    public Set<String> getLabels() {
        return this.labels;
    }

    @NotNull
    public Map<String, Object> getKeyFilters() {
        return this.keyFilters;
    }

    @NotNull
    public Set<String> getIncludeProperties() {
        return this.includeProperties;
    }

    @NotNull
    public Set<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePattern that = (NodePattern)o;
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.keyFilters, that.keyFilters)) {
            return false;
        }
        if (!Objects.equals(this.includeProperties, that.includeProperties)) {
            return false;
        }
        return Objects.equals(this.excludeProperties, that.excludeProperties);
    }

    public int hashCode() {
        int result = this.labels.hashCode();
        result = 31 * result + this.keyFilters.hashCode();
        result = 31 * result + this.includeProperties.hashCode();
        result = 31 * result + this.excludeProperties.hashCode();
        return result;
    }

    public String toString() {
        return "NodePattern{labels=" + String.valueOf(this.labels) + ", keyFilters=" + String.valueOf(this.keyFilters) + ", includeProperties=" + String.valueOf(this.includeProperties) + ", excludeProperties=" + String.valueOf(this.excludeProperties) + "}";
    }

    @Override
    @NotNull
    public Set<Selector> toSelector() {
        return Set.of(((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)((NodeSelector.NodeSelectorBuilder)NodeSelector.builder().withOperation(this.entityOperation)).withChangesTo(this.changesTo)).withLabels(this.labels).withKey(this.keyFilters).withExecutingUser(this.executingUser)).withAuthenticatedUser(this.authenticatedUser)).withTxMetadata(this.txMetadata)).includingProperties(this.includeProperties)).excludingProperties(this.excludeProperties)).build());
    }

    @Override
    public void withOperation(EntityOperation operation) {
        this.entityOperation = operation;
    }

    @Override
    public void withChangesTo(Set<String> changesTo) {
        this.changesTo = changesTo;
    }

    @Override
    public void withExecutingUser(String user) {
        this.executingUser = user;
    }

    @Override
    public void withAuthenticatedUser(String user) {
        this.authenticatedUser = user;
    }

    @Override
    public void withTxMetadata(Map<String, Object> metadata) {
        this.txMetadata = metadata;
    }
}

