/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.pattern;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.pattern.NodePattern;
import org.neo4j.cdc.client.pattern.Pattern;
import org.neo4j.cdc.client.selector.RelationshipNodeSelector;
import org.neo4j.cdc.client.selector.RelationshipSelector;
import org.neo4j.cdc.client.selector.Selector;

public class RelationshipPattern
implements Pattern {
    @Nullable
    private final String type;
    @NotNull
    private final NodePattern start;
    @NotNull
    private final NodePattern end;
    private final boolean bidirectional;
    @NotNull
    private final Map<String, Object> keyFilters;
    @NotNull
    private final Set<String> includeProperties;
    @NotNull
    private final Set<String> excludeProperties;
    private String executingUser;
    private String authenticatedUser;
    private Map<String, Object> txMetadata;
    private EntityOperation entityOperation;
    private Set<String> changesTo = Collections.emptySet();

    public RelationshipPattern(@Nullable String type, @NotNull NodePattern start, @NotNull NodePattern end, boolean bidirectional, @NotNull Map<String, Object> keyFilters, @NotNull Set<String> includeProperties, @NotNull Set<String> excludeProperties) {
        this.type = type;
        this.start = start;
        this.end = end;
        this.bidirectional = bidirectional;
        this.keyFilters = keyFilters;
        this.includeProperties = includeProperties;
        this.excludeProperties = excludeProperties;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @NotNull
    public NodePattern getStart() {
        return this.start;
    }

    @NotNull
    public NodePattern getEnd() {
        return this.end;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    @NotNull
    public Map<String, Object> getKeyFilters() {
        return this.keyFilters;
    }

    @NotNull
    public Set<String> getIncludeProperties() {
        return this.includeProperties;
    }

    @NotNull
    public Set<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipPattern that = (RelationshipPattern)o;
        if (this.bidirectional != that.bidirectional) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.start, that.start)) {
            return false;
        }
        if (!Objects.equals(this.end, that.end)) {
            return false;
        }
        if (!Objects.equals(this.keyFilters, that.keyFilters)) {
            return false;
        }
        if (!Objects.equals(this.includeProperties, that.includeProperties)) {
            return false;
        }
        return Objects.equals(this.excludeProperties, that.excludeProperties);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        result = 31 * result + (this.bidirectional ? 1 : 0);
        result = 31 * result + this.keyFilters.hashCode();
        result = 31 * result + this.includeProperties.hashCode();
        result = 31 * result + this.excludeProperties.hashCode();
        return result;
    }

    public String toString() {
        return "RelationshipPattern{type='" + this.type + "', start=" + String.valueOf(this.start) + ", end=" + String.valueOf(this.end) + ", bidirectional=" + this.bidirectional + ", keyFilters=" + String.valueOf(this.keyFilters) + ", includeProperties=" + String.valueOf(this.includeProperties) + ", excludeProperties=" + String.valueOf(this.excludeProperties) + "}";
    }

    @Override
    @NotNull
    public Set<Selector> toSelector() {
        HashSet<Selector> result = new HashSet<Selector>();
        result.add(((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)RelationshipSelector.builder().withOperation(this.entityOperation)).withChangesTo(this.changesTo)).withType(this.type).withStart(RelationshipNodeSelector.builder().withLabels(this.start.getLabels()).withKey(this.start.getKeyFilters()).build()).withEnd(RelationshipNodeSelector.builder().withLabels(this.end.getLabels()).withKey(this.end.getKeyFilters()).build()).withKey(this.keyFilters).withExecutingUser(this.executingUser)).withAuthenticatedUser(this.authenticatedUser)).withTxMetadata(this.txMetadata)).includingProperties(this.includeProperties)).excludingProperties(this.excludeProperties)).build());
        if (this.bidirectional) {
            result.add(((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)((RelationshipSelector.RelationshipSelectorBuilder)RelationshipSelector.builder().withOperation(this.entityOperation)).withChangesTo(this.changesTo)).withType(this.type).withStart(RelationshipNodeSelector.builder().withLabels(this.end.getLabels()).withKey(this.end.getKeyFilters()).build()).withEnd(RelationshipNodeSelector.builder().withLabels(this.start.getLabels()).withKey(this.start.getKeyFilters()).build()).withKey(this.keyFilters).withExecutingUser(this.executingUser)).withAuthenticatedUser(this.authenticatedUser)).withTxMetadata(this.txMetadata)).includingProperties(this.includeProperties)).excludingProperties(this.excludeProperties)).build());
        }
        return result;
    }

    @Override
    public void withOperation(EntityOperation operation) {
        this.entityOperation = operation;
    }

    @Override
    public void withChangesTo(Set<String> changesTo) {
        this.changesTo = changesTo;
    }

    @Override
    public void withExecutingUser(String user) {
        this.executingUser = user;
    }

    @Override
    public void withAuthenticatedUser(String user) {
        this.authenticatedUser = user;
    }

    @Override
    public void withTxMetadata(Map<String, Object> metadata) {
        this.txMetadata = metadata;
    }
}

