/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.neo4j.cdc.client.CDCService;
import org.neo4j.cdc.client.ResultMapper;
import org.neo4j.cdc.client.SessionConfigSupplier;
import org.neo4j.cdc.client.TransactionConfigSupplier;
import org.neo4j.cdc.client.model.ChangeEvent;
import org.neo4j.cdc.client.model.ChangeIdentifier;
import org.neo4j.cdc.client.selector.Selector;
import org.neo4j.driver.Driver;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.types.MapAccessor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CDCClient
implements CDCService {
    private final Logger log = LoggerFactory.getLogger(CDCClient.class);
    private static final String CDC_EARLIEST_STATEMENT = "call db.cdc.earliest()";
    private static final String CDC_CURRENT_STATEMENT = "call db.cdc.current()";
    private static final String CDC_QUERY_STATEMENT = "call db.cdc.query($from, $selectors)";
    private final Driver driver;
    private final List<Selector> selectors;
    private final SessionConfigSupplier sessionConfigSupplier;
    private final TransactionConfigSupplier transactionConfigSupplier;
    private final Duration streamingPollInterval;

    public CDCClient(Driver driver, Selector ... selectors) {
        this(driver, Duration.ofSeconds(1L), selectors);
    }

    public CDCClient(Driver driver, Duration streamingPollInterval, Selector ... selectors) {
        this.driver = Objects.requireNonNull(driver);
        this.sessionConfigSupplier = () -> SessionConfig.builder().build();
        this.transactionConfigSupplier = () -> TransactionConfig.builder().build();
        this.streamingPollInterval = Objects.requireNonNull(streamingPollInterval);
        this.selectors = selectors == null ? List.of() : Arrays.asList(selectors);
    }

    public CDCClient(Driver driver, SessionConfigSupplier sessionConfigSupplier, Selector ... selectors) {
        this(driver, sessionConfigSupplier, Duration.ofSeconds(1L), selectors);
    }

    public CDCClient(Driver driver, SessionConfigSupplier sessionConfigSupplier, Duration streamingPollInterval, Selector ... selectors) {
        this.driver = Objects.requireNonNull(driver);
        this.sessionConfigSupplier = sessionConfigSupplier;
        this.transactionConfigSupplier = () -> TransactionConfig.builder().build();
        this.streamingPollInterval = Objects.requireNonNull(streamingPollInterval);
        this.selectors = selectors == null ? List.of() : Arrays.asList(selectors);
    }

    public CDCClient(Driver driver, SessionConfigSupplier sessionConfigSupplier, TransactionConfigSupplier transactionConfigSupplier, Duration streamingPollInterval, Selector ... selectors) {
        this.driver = Objects.requireNonNull(driver);
        this.sessionConfigSupplier = sessionConfigSupplier;
        this.transactionConfigSupplier = transactionConfigSupplier;
        this.streamingPollInterval = Objects.requireNonNull(streamingPollInterval);
        this.selectors = selectors == null ? List.of() : Arrays.asList(selectors);
    }

    @Override
    public Mono<ChangeIdentifier> earliest() {
        return this.queryForChangeIdentifier(CDC_EARLIEST_STATEMENT, "db.cdc.earliest");
    }

    @Override
    public Mono<ChangeIdentifier> current() {
        return this.queryForChangeIdentifier(CDC_CURRENT_STATEMENT, "db.cdc.current");
    }

    @Override
    public Flux<ChangeEvent> query(ChangeIdentifier from) {
        return Flux.usingWhen((Publisher)Mono.fromSupplier(() -> this.driver.rxSession(this.sessionConfigSupplier.sessionConfig())), session -> Flux.from((Publisher)session.readTransaction(tx -> {
            Map params = Map.of("from", from.getId(), "selectors", this.selectors.stream().map(Selector::asMap).collect(Collectors.toList()));
            this.log.trace("running db.cdc.query using parameters {}", params);
            RxResult result = tx.run(CDC_QUERY_STATEMENT, params);
            return Flux.from((Publisher)result.records()).map(MapAccessor::asMap).map(ResultMapper::parseChangeEvent);
        }, this.transactionConfigSupplier.transactionConfig())), RxSession::close).map(this::applyPropertyFilters).doOnSubscribe(s -> this.log.trace("subscribed to cdc query")).doOnComplete(() -> this.log.trace("subscription to cdc query completed"));
    }

    @Override
    public Flux<ChangeEvent> stream(ChangeIdentifier from) {
        AtomicReference<ChangeIdentifier> cursor = new AtomicReference<ChangeIdentifier>(from);
        Flux query = Flux.usingWhen((Publisher)Mono.fromSupplier(() -> this.driver.rxSession(this.sessionConfigSupplier.sessionConfig())), session -> Flux.from((Publisher)session.readTransaction(tx -> {
            Mono current = Mono.from((Publisher)tx.run("CALL db.cdc.current()").records()).map(MapAccessor::asMap).map(ResultMapper::parseChangeIdentifier);
            Map params = Map.of("from", ((ChangeIdentifier)cursor.get()).getId(), "selectors", this.selectors.stream().map(Selector::asMap).collect(Collectors.toList()));
            this.log.trace("running db.cdc.query using parameters {}", params);
            RxResult result = tx.run(CDC_QUERY_STATEMENT, params);
            return current.flatMapMany(changeId -> Flux.from((Publisher)result.records()).map(MapAccessor::asMap).map(ResultMapper::parseChangeEvent).switchIfEmpty((Publisher)Flux.defer(() -> {
                cursor.set((ChangeIdentifier)changeId);
                return Flux.empty();
            })));
        }, this.transactionConfigSupplier.transactionConfig())), RxSession::close);
        return Flux.concat((Publisher[])new Publisher[]{query, Mono.delay((Duration)this.streamingPollInterval).mapNotNull(x -> null)}).map(this::applyPropertyFilters).doOnNext(e -> cursor.set(e.getId())).repeat().doOnSubscribe(s -> this.log.trace("subscribed to cdc stream")).doOnComplete(() -> this.log.trace("subscription to cdc stream completed"));
    }

    private ChangeEvent applyPropertyFilters(ChangeEvent original) {
        if (this.selectors.isEmpty()) {
            return original;
        }
        for (Selector selector : this.selectors) {
            if (!selector.matches(original)) continue;
            return selector.applyProperties(original);
        }
        return original;
    }

    private Mono<ChangeIdentifier> queryForChangeIdentifier(String query, String description) {
        return Mono.usingWhen((Publisher)Mono.fromSupplier(() -> this.driver.rxSession(this.sessionConfigSupplier.sessionConfig())), session -> Mono.from((Publisher)session.readTransaction(tx -> {
            RxResult result = tx.run(query);
            return Mono.from((Publisher)result.records()).map(MapAccessor::asMap).map(ResultMapper::parseChangeIdentifier);
        }, this.transactionConfigSupplier.transactionConfig())), RxSession::close).doOnSubscribe(s -> this.log.trace("subscribed to {}", (Object)description)).doOnSuccess(c -> this.log.trace("subscription to {} completed with '{}'", (Object)description, c)).doOnError(t -> this.log.error("subscription to {} failed", (Object)description, t));
    }
}

