/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.neo4j.cdc.client.model.EntityEvent;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.EventType;
import org.neo4j.cdc.client.model.ModelUtils;
import org.neo4j.cdc.client.model.Node;
import org.neo4j.cdc.client.model.RelationshipState;

public class RelationshipEvent
extends EntityEvent<RelationshipState> {
    private final Node start;
    private final Node end;
    private final String type;
    private final List<Map<String, Object>> keys;

    public RelationshipEvent(String elementId, String type, Node start, Node end, List<Map<String, Object>> keys, EntityOperation operation, RelationshipState before, RelationshipState after) {
        super(elementId, EventType.RELATIONSHIP, operation, before, after);
        this.start = Objects.requireNonNull(start);
        this.end = Objects.requireNonNull(end);
        this.type = Objects.requireNonNull(type);
        this.keys = keys;
    }

    public Node getStart() {
        return this.start;
    }

    public Node getEnd() {
        return this.end;
    }

    public String getType() {
        return this.type;
    }

    public List<Map<String, Object>> getKeys() {
        return this.keys;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelationshipEvent that = (RelationshipEvent)o;
        if (!this.start.equals(that.start)) {
            return false;
        }
        if (!this.end.equals(that.end)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return Objects.equals(this.keys, that.keys);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.keys != null ? this.keys.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("RelationshipEvent{elementId=%s, start=%s, end=%s, type='%s', keys=%s, operation=%s, before=%s, after=%s}", new Object[]{this.getElementId(), this.start, this.end, this.type, this.keys, this.getOperation(), this.getBefore(), this.getAfter()});
    }

    public static RelationshipEvent fromMap(Map<?, ?> map) {
        Map<String, Object> cypherMap = ModelUtils.checkedMap(Objects.requireNonNull(map), String.class, Object.class);
        String elementId = MapUtils.getString(cypherMap, (Object)"elementId");
        EntityOperation operation = EntityOperation.fromShorthand(MapUtils.getString(cypherMap, (Object)"operation"));
        String type = MapUtils.getString(cypherMap, (Object)"type");
        Node start = Node.fromMap(ModelUtils.getMap(cypherMap, "start", String.class, Object.class));
        Node end = Node.fromMap(ModelUtils.getMap(cypherMap, "end", String.class, Object.class));
        List<Map<String, Object>> key = ModelUtils.getRelationshipKeys(cypherMap);
        Map<String, Object> state = ModelUtils.checkedMap(Objects.requireNonNull(MapUtils.getMap(cypherMap, (Object)"state")), String.class, Object.class);
        RelationshipState before = RelationshipState.fromMap(MapUtils.getMap(state, (Object)"before"));
        RelationshipState after = RelationshipState.fromMap(MapUtils.getMap(state, (Object)"after"));
        return new RelationshipEvent(elementId, type, start, end, key, operation, before, after);
    }
}

