/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.selector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cdc.client.model.ChangeEvent;
import org.neo4j.cdc.client.model.EntityEvent;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.NodeEvent;
import org.neo4j.cdc.client.model.NodeState;
import org.neo4j.cdc.client.model.RelationshipEvent;
import org.neo4j.cdc.client.model.RelationshipState;
import org.neo4j.cdc.client.model.State;
import org.neo4j.cdc.client.selector.Selector;

public class EntitySelector
implements Selector {
    @Nullable
    private final EntityOperation operation;
    @NotNull
    private final Set<String> changesTo;
    @NotNull
    private final Set<String> includeProperties;
    @NotNull
    private final Set<String> excludeProperties;
    @Nullable
    private final String executingUser;
    @Nullable
    private final String authenticatedUser;
    @NotNull
    private final Map<String, Object> txMetadata;

    protected EntitySelector(@Nullable EntityOperation operation, @NotNull Set<String> changesTo, @Nullable String executingUser, @Nullable String authenticatedUser, @NotNull Map<String, Object> txMetadata, @NotNull Set<String> includeProperties, @NotNull Set<String> excludeProperties) {
        this.operation = operation;
        this.changesTo = Objects.requireNonNull(changesTo);
        this.includeProperties = Objects.requireNonNull(includeProperties);
        this.excludeProperties = Objects.requireNonNull(excludeProperties);
        this.executingUser = executingUser;
        this.authenticatedUser = authenticatedUser;
        this.txMetadata = txMetadata;
    }

    @Nullable
    public EntityOperation getOperation() {
        return this.operation;
    }

    @NotNull
    public Set<String> getChangesTo() {
        return this.changesTo;
    }

    @Nullable
    public String getExecutingUser() {
        return this.executingUser;
    }

    @Nullable
    public String getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    @NotNull
    public Map<String, Object> getTxMetadata() {
        return this.txMetadata;
    }

    @NotNull
    public Set<String> getIncludeProperties() {
        return this.includeProperties;
    }

    @NotNull
    public Set<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    @Override
    public boolean matches(ChangeEvent e) {
        if (!(e.getEvent() instanceof EntityEvent)) {
            return false;
        }
        EntityEvent event = (EntityEvent)e.getEvent();
        if (this.operation != null && event.getOperation() != this.operation) {
            return false;
        }
        if (!this.changesTo.isEmpty()) {
            switch (event.getOperation()) {
                case CREATE: {
                    if (this.changesTo.stream().allMatch(p -> ((State)event.getAfter()).getProperties().containsKey(p))) break;
                    return false;
                }
                case DELETE: {
                    if (this.changesTo.stream().allMatch(p -> ((State)event.getBefore()).getProperties().containsKey(p))) break;
                    return false;
                }
                case UPDATE: {
                    boolean allUpdated = this.changesTo.stream().allMatch(prop -> {
                        Object newValue;
                        if (!((State)event.getBefore()).getProperties().containsKey(prop) && !((State)event.getAfter()).getProperties().containsKey(prop)) {
                            return false;
                        }
                        Object oldValue = ((State)event.getBefore()).getProperties().get(prop);
                        return !Objects.equals(oldValue, newValue = ((State)event.getAfter()).getProperties().get(prop));
                    });
                    if (allUpdated) break;
                    return false;
                }
            }
        }
        if (this.executingUser != null && !e.getMetadata().getExecutingUser().equals(this.executingUser)) {
            return false;
        }
        if (this.authenticatedUser != null && !e.getMetadata().getAuthenticatedUser().equals(this.authenticatedUser)) {
            return false;
        }
        return e.getMetadata().getTxMetadata().entrySet().containsAll(this.txMetadata.entrySet());
    }

    @Override
    public ChangeEvent applyProperties(ChangeEvent e) {
        if (this.includeProperties.isEmpty() && this.excludeProperties.isEmpty()) {
            return e;
        }
        switch (e.getEvent().getEventType()) {
            case NODE: {
                NodeState afterState;
                NodeEvent nodeEvent = (NodeEvent)e.getEvent();
                NodeState beforeState = (NodeState)nodeEvent.getBefore();
                if (beforeState != null) {
                    beforeState = new NodeState(beforeState.getLabels(), this.filterProps(beforeState.getProperties()));
                }
                if ((afterState = (NodeState)nodeEvent.getAfter()) != null) {
                    afterState = new NodeState(afterState.getLabels(), this.filterProps(afterState.getProperties()));
                }
                return new ChangeEvent(e.getId(), e.getTxId(), e.getSeq(), e.getMetadata(), new NodeEvent(nodeEvent.getElementId(), nodeEvent.getOperation(), nodeEvent.getLabels(), nodeEvent.getKeys(), beforeState, afterState));
            }
            case RELATIONSHIP: {
                RelationshipState afterState;
                RelationshipEvent relationshipEvent = (RelationshipEvent)e.getEvent();
                RelationshipState beforeState = (RelationshipState)relationshipEvent.getBefore();
                if (beforeState != null) {
                    beforeState = new RelationshipState(this.filterProps(beforeState.getProperties()));
                }
                if ((afterState = (RelationshipState)relationshipEvent.getAfter()) != null) {
                    afterState = new RelationshipState(this.filterProps(afterState.getProperties()));
                }
                return new ChangeEvent(e.getId(), e.getTxId(), e.getSeq(), e.getMetadata(), new RelationshipEvent(relationshipEvent.getElementId(), relationshipEvent.getType(), relationshipEvent.getStart(), relationshipEvent.getEnd(), relationshipEvent.getKeys(), relationshipEvent.getOperation(), beforeState, afterState));
            }
        }
        return e;
    }

    @NotNull
    private Map<String, Object> filterProps(Map<String, Object> props) {
        return props.entrySet().stream().filter(entry -> {
            if (this.excludeProperties.contains(entry.getKey())) {
                return false;
            }
            return this.includeProperties.isEmpty() || this.includeProperties.contains("*") || this.includeProperties.contains(entry.getKey());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("select", "e");
        if (this.operation != null) {
            result.put("operation", this.operation.shorthand);
        }
        if (!this.changesTo.isEmpty()) {
            result.put("changesTo", this.changesTo);
        }
        if (this.authenticatedUser != null) {
            result.put("authenticatedUser", this.authenticatedUser);
        }
        if (this.executingUser != null) {
            result.put("executingUser", this.executingUser);
        }
        if (!this.txMetadata.isEmpty()) {
            result.put("txMetadata", this.txMetadata);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntitySelector that = (EntitySelector)o;
        return this.operation == that.operation && this.changesTo.equals(that.changesTo) && this.includeProperties.equals(that.includeProperties) && this.excludeProperties.equals(that.excludeProperties) && Objects.equals(this.executingUser, that.executingUser) && Objects.equals(this.authenticatedUser, that.authenticatedUser) && this.txMetadata.equals(that.txMetadata);
    }

    public int hashCode() {
        int result = Objects.hashCode((Object)this.operation);
        result = 31 * result + this.changesTo.hashCode();
        result = 31 * result + this.includeProperties.hashCode();
        result = 31 * result + this.excludeProperties.hashCode();
        result = 31 * result + Objects.hashCode(this.executingUser);
        result = 31 * result + Objects.hashCode(this.authenticatedUser);
        result = 31 * result + this.txMetadata.hashCode();
        return result;
    }

    public static Builder<?, ?> builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder<?, ?>, S extends EntitySelector> {
        protected EntityOperation operation = null;
        protected Set<String> changesTo = Collections.emptySet();
        protected Set<String> includeProperties = Collections.emptySet();
        protected Set<String> excludeProperties = Collections.emptySet();
        protected String executingUser = null;
        protected String authenticatedUser = null;
        protected Map<String, Object> txMetadata = null;

        protected Builder() {
        }

        public T withOperation(EntityOperation operation) {
            this.operation = operation;
            return (T)this;
        }

        public T withChangesTo(Set<String> changesTo) {
            this.changesTo = changesTo;
            return (T)this;
        }

        public T withExecutingUser(String executingUser) {
            this.executingUser = executingUser;
            return (T)this;
        }

        public T withAuthenticatedUser(String authenticatedUser) {
            this.authenticatedUser = authenticatedUser;
            return (T)this;
        }

        public T withTxMetadata(Map<String, Object> txMetadata) {
            this.txMetadata = txMetadata;
            return (T)this;
        }

        public T includingProperties(Set<String> includeProperties) {
            this.includeProperties = includeProperties;
            return (T)this;
        }

        public T excludingProperties(Set<String> excludeProperties) {
            this.excludeProperties = excludeProperties;
            return (T)this;
        }

        public S build() {
            return (S)new EntitySelector(this.operation, Objects.requireNonNullElseGet(this.changesTo, Collections::emptySet), this.executingUser, this.authenticatedUser, Objects.requireNonNullElseGet(this.txMetadata, Collections::emptyMap), Objects.requireNonNullElseGet(this.includeProperties, Collections::emptySet), Objects.requireNonNullElseGet(this.excludeProperties, Collections::emptySet));
        }
    }
}

