/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.authn.keycloak;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.keycloak.authorization.client.Configuration;
import org.neo4j.connectors.authn.AuthenticationToken;
import org.neo4j.connectors.authn.AuthenticationTokenSupplierFactory;
import org.neo4j.connectors.authn.keycloak.KeycloakOIDCAuthenticationSupplier;

public class KeycloakOIDCAuthenticationSupplierFactory
implements AuthenticationTokenSupplierFactory {
    public String getName() {
        return "keycloak";
    }

    public Supplier<AuthenticationToken> create(String username, String password, Map<String, String> parameters) {
        String url = Objects.requireNonNull(parameters.get("authServerUrl"));
        String realm = Objects.requireNonNull(parameters.get("realm"));
        String clientId = Objects.requireNonNull(parameters.get("clientId"));
        String clientSecret = Objects.requireNonNull(parameters.get("clientSecret"));
        return new KeycloakOIDCAuthenticationSupplier(username, password, new Configuration(url, realm, clientId, Map.of("secret", clientSecret), (HttpClient)HttpClients.createMinimal()));
    }
}

