/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.authn;

import java.time.Instant;
import java.util.Map;
import org.neo4j.connectors.authn.BearerAuthenticationToken;
import org.neo4j.connectors.authn.CustomAuthenticationToken;
import org.neo4j.connectors.authn.DisabledAuthenticationToken;
import org.neo4j.connectors.authn.KerberosAuthenticationToken;
import org.neo4j.connectors.authn.UserNameAndPasswordAuthenticationToken;

public interface AuthenticationToken {
    public static AuthenticationToken bearer(String token) {
        return AuthenticationToken.bearer(token, null);
    }

    public static AuthenticationToken bearer(String token, Instant expiresAt) {
        return new BearerAuthenticationToken(token, expiresAt);
    }

    public static AuthenticationToken kerberos(String token) {
        return new KerberosAuthenticationToken(token);
    }

    public static AuthenticationToken none() {
        return DisabledAuthenticationToken.NONE;
    }

    public static AuthenticationToken usernameAndPassword(String username, String password) {
        return AuthenticationToken.usernameAndPassword(username, password, null);
    }

    public static AuthenticationToken usernameAndPassword(String username, String password, String realm) {
        return new UserNameAndPasswordAuthenticationToken(username, password, realm);
    }

    public static AuthenticationToken custom(String principal, String credentials, String realm, String scheme) {
        return AuthenticationToken.custom(principal, credentials, realm, scheme, null);
    }

    public static AuthenticationToken custom(String principal, String credentials, String realm, String scheme, Map<String, Object> parameters) {
        return new CustomAuthenticationToken(principal, credentials, realm, scheme, parameters);
    }
}

