/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.common.driver.reauth;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.connectors.common.driver.reauth.ReAuthDriver;
import org.neo4j.connectors.common.driver.reauth.ReAuthRxSession;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.AsyncTransactionWork;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.AbstractQueryRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReAuthAsyncSession
implements AsyncSession {
    private static final Logger log = LoggerFactory.getLogger(ReAuthRxSession.class);
    private final ReAuthDriver driver;
    private final AtomicReference<AsyncSession> delegate = new AtomicReference();
    private final Supplier<AsyncSession> sessionSupplier;

    public ReAuthAsyncSession(ReAuthDriver driver, Supplier<AsyncSession> sessionSupplier) {
        this.driver = driver;
        this.sessionSupplier = sessionSupplier;
        this.delegate.set(sessionSupplier.get());
    }

    public CompletionStage<AsyncTransaction> beginTransactionAsync() {
        return this.beginTransactionAsync(TransactionConfig.empty());
    }

    public CompletionStage<AsyncTransaction> beginTransactionAsync(TransactionConfig config) {
        return this.withExpiringAsyncSession(() -> this.delegate.get().beginTransactionAsync(config));
    }

    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.readTransactionAsync(work, TransactionConfig.empty());
    }

    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.withExpiringAsyncSession(() -> this.delegate.get().readTransactionAsync(work, config));
    }

    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.writeTransactionAsync(work, TransactionConfig.empty());
    }

    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.withExpiringAsyncSession(() -> this.delegate.get().writeTransactionAsync(work, config));
    }

    public CompletionStage<ResultCursor> runAsync(String query, TransactionConfig config) {
        return this.runAsync(new Query(query, Collections.emptyMap()), config);
    }

    public CompletionStage<ResultCursor> runAsync(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.runAsync(new Query(query, parameters), config);
    }

    public CompletionStage<ResultCursor> runAsync(Query query, TransactionConfig config) {
        return this.withExpiringAsyncSession(() -> this.delegate.get().runAsync(query, config));
    }

    public Bookmark lastBookmark() {
        return this.delegate.get().lastBookmark();
    }

    public CompletionStage<Void> closeAsync() {
        return this.delegate.get().closeAsync();
    }

    public CompletionStage<ResultCursor> runAsync(String query, Value parameters) {
        return this.runAsync(new Query(query, parameters), TransactionConfig.empty());
    }

    public CompletionStage<ResultCursor> runAsync(String query, Map<String, Object> parameters) {
        return this.runAsync(new Query(query, parameters), TransactionConfig.empty());
    }

    public CompletionStage<ResultCursor> runAsync(String query, Record parameters) {
        return this.runAsync(new Query(query, AbstractQueryRunner.parameters((Record)parameters)), TransactionConfig.empty());
    }

    public CompletionStage<ResultCursor> runAsync(String query) {
        return this.runAsync(new Query(query, Collections.emptyMap()), TransactionConfig.empty());
    }

    public CompletionStage<ResultCursor> runAsync(Query query) {
        return this.runAsync(query, TransactionConfig.empty());
    }

    private <T> CompletionStage<T> withExpiringAsyncSession(Supplier<CompletionStage<T>> block) {
        return this.driver.withRefreshAsync(block, () -> {
            log.debug("Creating new session to replace expired one");
            AsyncSession oldSession = this.delegate.getAndSet(this.sessionSupplier.get());
            return oldSession.closeAsync().handle((v, e) -> {
                if (e != null) {
                    log.debug("Failed to close async session", e);
                }
                return CompletableFuture.completedFuture(v);
            }).thenCompose(Function.identity());
        });
    }
}

