/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.common.driver.reauth;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.connectors.common.driver.reauth.ReAuthAsyncSession;
import org.neo4j.connectors.common.driver.reauth.ReAuthRxSession;
import org.neo4j.connectors.common.driver.reauth.ReAuthSession;
import org.neo4j.connectors.common.driver.reauth.Utils;
import org.neo4j.connectors.common.driver.reauth.tracking.TrackingDriver;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.exceptions.SecurityException;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.types.TypeSystem;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ReAuthDriver
implements Driver {
    private static final Logger log = LoggerFactory.getLogger(ReAuthDriver.class);
    private static final long DEFAULT_CLEANUP_INTERVAL_MILLIS = 300000L;
    private final Supplier<Driver> driverFactory;
    private final AtomicReference<TrackingDriver> currentDriver = new AtomicReference();
    private final ReentrantLock currentDriverLock = new ReentrantLock();
    final List<TrackingDriver> expiredDrivers = new CopyOnWriteArrayList<TrackingDriver>();
    private final ScheduledExecutorService cleanupExecutor;

    ReAuthDriver(Driver currentDriver, Supplier<Driver> driverFactory) {
        this(currentDriver, driverFactory, 300000L);
    }

    ReAuthDriver(Supplier<Driver> driverFactory) {
        this(driverFactory.get(), driverFactory, 300000L);
    }

    ReAuthDriver(Supplier<Driver> driverFactory, long cleanupIntervalMillis) {
        this(driverFactory.get(), driverFactory, cleanupIntervalMillis);
    }

    ReAuthDriver(Driver currentDriver, Supplier<Driver> driverFactory, long cleanupIntervalMillis) {
        this.driverFactory = driverFactory;
        this.currentDriver.set(new TrackingDriver(currentDriver));
        this.cleanupExecutor = Executors.newSingleThreadScheduledExecutor();
        this.cleanupExecutor.scheduleAtFixedRate(this::cleanUpExpiredDrivers, cleanupIntervalMillis, cleanupIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public boolean isEncrypted() {
        return this.currentDriver.get().isEncrypted();
    }

    public Session session() {
        return this.session(SessionConfig.defaultConfig());
    }

    public Session session(SessionConfig sessionConfig) {
        return this.checkExpiration(() -> new ReAuthSession(this, () -> this.currentDriver.get().session(sessionConfig)));
    }

    public RxSession rxSession() {
        return this.rxSession(SessionConfig.defaultConfig());
    }

    public RxSession rxSession(SessionConfig sessionConfig) {
        return this.checkExpiration(() -> new ReAuthRxSession(this, () -> this.currentDriver.get().rxSession(sessionConfig)));
    }

    public AsyncSession asyncSession() {
        return this.asyncSession(SessionConfig.defaultConfig());
    }

    public AsyncSession asyncSession(SessionConfig sessionConfig) {
        return this.checkExpiration(() -> new ReAuthAsyncSession(this, () -> this.currentDriver.get().asyncSession(sessionConfig)));
    }

    public void close() {
        this.expiredDrivers.forEach(Utils::closeQuietly);
        this.currentDriver.get().close();
        this.cleanupExecutor.shutdownNow();
    }

    public CompletionStage<Void> closeAsync() {
        CompletionStage<Void> closeAsync = this.currentDriver.get().closeAsync();
        return this.expiredDrivers.stream().map(Driver::closeAsync).reduce(closeAsync, (acc, ca) -> acc.thenCombine(ca, (a, b) -> b));
    }

    public Metrics metrics() {
        return this.currentDriver.get().metrics();
    }

    public boolean isMetricsEnabled() {
        return this.currentDriver.get().isMetricsEnabled();
    }

    public TypeSystem defaultTypeSystem() {
        return this.currentDriver.get().defaultTypeSystem();
    }

    public void verifyConnectivity() {
        this.currentDriver.get().verifyConnectivity();
    }

    public CompletionStage<Void> verifyConnectivityAsync() {
        return this.currentDriver.get().verifyConnectivityAsync();
    }

    public boolean supportsMultiDb() {
        return this.currentDriver.get().supportsMultiDb();
    }

    public CompletionStage<Boolean> supportsMultiDbAsync() {
        return this.currentDriver.get().supportsMultiDbAsync();
    }

    void cleanUpExpiredDrivers() {
        List<TrackingDriver> driverWithNoConnections = this.expiredDrivers.stream().filter(driver -> driver.getOpenSessionCount() == 0).collect(Collectors.toList());
        driverWithNoConnections.forEach(Utils::closeQuietly);
        this.expiredDrivers.removeAll(driverWithNoConnections);
    }

    private <T> T checkExpiration(Supplier<T> block) {
        return this.withRefresh(block, () -> {});
    }

    void withLock(Runnable block) {
        this.currentDriverLock.lock();
        try {
            block.run();
        }
        finally {
            this.currentDriverLock.unlock();
        }
    }

    <T> T withRefresh(Supplier<T> block, Runnable refresh) {
        int driverHashCode = System.identityHashCode(this.currentDriver.get());
        try {
            return block.get();
        }
        catch (SecurityException e) {
            this.withLock(() -> {
                log.debug("Caught authentication exception. Try to refresh the driver and retry.");
                this.rotateCurrentDriver(driverHashCode);
                refresh.run();
            });
            return block.get();
        }
    }

    <T> Publisher<T> withRxRefresh(Supplier<Publisher<T>> block, Supplier<Publisher<Void>> refresh) {
        return Mono.defer(() -> {
            int driverHashCode = System.identityHashCode(this.currentDriver.get());
            return Mono.from((Publisher)((Publisher)block.get())).onErrorResume(SecurityException.class, arg_0 -> this.lambda$withRxRefresh$15(driverHashCode, (Supplier)refresh, (Supplier)block, arg_0));
        });
    }

    <T> CompletionStage<T> withRefreshAsync(Supplier<CompletionStage<T>> block, Supplier<CompletionStage<Void>> refresh) {
        int driverHashCode = System.identityHashCode(this.currentDriver.get());
        return block.get().handle((value, e) -> {
            if (e == null) {
                return CompletableFuture.completedFuture(value);
            }
            if (e instanceof SecurityException || e.getCause() instanceof SecurityException) {
                return ((CompletableFuture)CompletableFuture.runAsync(() -> this.withLock(() -> {
                    log.debug("Caught authentication exception. Try to refresh the driver and retry.");
                    this.rotateCurrentDriver(driverHashCode);
                })).thenCompose(arg_0 -> ReAuthDriver.lambda$withRefreshAsync$19((Supplier)refresh, arg_0))).thenCompose(arg_0 -> ReAuthDriver.lambda$withRefreshAsync$20((Supplier)block, arg_0));
            }
            return Utils.failedStage(e);
        }).thenCompose(Function.identity());
    }

    void rotateCurrentDriver(int hashCode) {
        if (System.identityHashCode(this.currentDriver.get()) == hashCode) {
            this.expiredDrivers.add(this.currentDriver.get());
            this.currentDriver.set(new TrackingDriver(this.driverFactory.get()));
        }
    }

    private static /* synthetic */ CompletionStage lambda$withRefreshAsync$20(Supplier block, Void vd) {
        return (CompletionStage)block.get();
    }

    private static /* synthetic */ CompletionStage lambda$withRefreshAsync$19(Supplier refresh, Void vd) {
        return (CompletionStage)refresh.get();
    }

    private /* synthetic */ Mono lambda$withRxRefresh$15(int driverHashCode, Supplier refresh, Supplier block, SecurityException e) {
        return Mono.fromRunnable(() -> this.withLock(() -> {
            log.debug("Caught authentication exception. Try to refresh the driver and retry.");
            this.rotateCurrentDriver(driverHashCode);
        })).then(Mono.defer(() -> ReAuthDriver.lambda$withRxRefresh$13((Supplier)refresh))).then(Mono.defer(() -> ReAuthDriver.lambda$withRxRefresh$14((Supplier)block)));
    }

    private static /* synthetic */ Mono lambda$withRxRefresh$14(Supplier block) {
        return Mono.from((Publisher)((Publisher)block.get()));
    }

    private static /* synthetic */ Mono lambda$withRxRefresh$13(Supplier refresh) {
        return Mono.from((Publisher)((Publisher)refresh.get()));
    }
}

