/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.common.driver.reauth;

import java.net.URI;
import java.util.Map;
import java.util.function.Supplier;
import org.neo4j.connectors.authn.AuthenticationToken;
import org.neo4j.connectors.authn.BearerAuthenticationToken;
import org.neo4j.connectors.authn.CustomAuthenticationToken;
import org.neo4j.connectors.authn.DisabledAuthenticationToken;
import org.neo4j.connectors.authn.ExpiringAuthenticationToken;
import org.neo4j.connectors.authn.KerberosAuthenticationToken;
import org.neo4j.connectors.authn.UserNameAndPasswordAuthenticationToken;
import org.neo4j.connectors.common.driver.reauth.ReAuthDriver;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;

public final class ReAuthDriverFactory {
    private ReAuthDriverFactory() {
    }

    public static Driver driver(String uri, Supplier<AuthenticationToken> authTokenSupplier) {
        return ReAuthDriverFactory.driver(URI.create(uri), authTokenSupplier, Config.defaultConfig());
    }

    public static Driver driver(URI uri, Supplier<AuthenticationToken> authTokenSupplier) {
        return ReAuthDriverFactory.driver(uri, authTokenSupplier, Config.defaultConfig());
    }

    public static Driver driver(String uri, Supplier<AuthenticationToken> authTokenSupplier, Config config) {
        return ReAuthDriverFactory.driver(URI.create(uri), authTokenSupplier, config);
    }

    public static Driver driver(URI uri, Supplier<AuthenticationToken> authTokenSupplier, Config config) {
        AuthenticationToken authenticationToken = authTokenSupplier.get();
        Driver originalDriver = GraphDatabase.driver((URI)uri, (AuthToken)ReAuthDriverFactory.convertToAuthToken(authenticationToken), (Config)config);
        if (!(authenticationToken instanceof ExpiringAuthenticationToken)) {
            return originalDriver;
        }
        Supplier<Driver> refresher = () -> {
            AuthenticationToken refreshedToken = (AuthenticationToken)authTokenSupplier.get();
            return GraphDatabase.driver((URI)uri, (AuthToken)ReAuthDriverFactory.convertToAuthToken(refreshedToken), (Config)config);
        };
        return new ReAuthDriver(originalDriver, refresher);
    }

    private static AuthToken convertToAuthToken(AuthenticationToken token) throws IllegalArgumentException {
        if (token instanceof BearerAuthenticationToken) {
            BearerAuthenticationToken bearerToken = (BearerAuthenticationToken)token;
            return AuthTokens.bearer((String)bearerToken.getToken());
        }
        if (token instanceof KerberosAuthenticationToken) {
            KerberosAuthenticationToken kerberosToken = (KerberosAuthenticationToken)token;
            return AuthTokens.kerberos((String)kerberosToken.getToken());
        }
        if (token instanceof UserNameAndPasswordAuthenticationToken) {
            UserNameAndPasswordAuthenticationToken userNameAndPasswordToken = (UserNameAndPasswordAuthenticationToken)token;
            return AuthTokens.basic((String)userNameAndPasswordToken.getUsername(), (String)userNameAndPasswordToken.getPassword(), (String)userNameAndPasswordToken.getRealm());
        }
        if (token instanceof DisabledAuthenticationToken) {
            return AuthTokens.none();
        }
        if (token instanceof CustomAuthenticationToken) {
            CustomAuthenticationToken customToken = (CustomAuthenticationToken)token;
            return AuthTokens.custom((String)customToken.getPrincipal(), (String)customToken.getCredentials(), (String)customToken.getRealm(), (String)customToken.getScheme(), (Map)customToken.getParameters());
        }
        throw new IllegalArgumentException(String.format("Authentication token of class %s is not supported", token.getClass()));
    }
}

