/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.common.driver.reauth;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.neo4j.connectors.common.driver.reauth.ReAuthDriver;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.AbstractQueryRunner;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransaction;
import org.neo4j.driver.reactive.RxTransactionWork;
import org.neo4j.driver.summary.ResultSummary;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class ReAuthRxSession
implements RxSession {
    private static final Logger log = LoggerFactory.getLogger(ReAuthRxSession.class);
    private final ReAuthDriver driver;
    private final AtomicReference<RxSession> delegate = new AtomicReference();
    private final Supplier<RxSession> sessionSupplier;

    public ReAuthRxSession(ReAuthDriver driver, Supplier<RxSession> sessionSupplier) {
        this.driver = driver;
        this.sessionSupplier = sessionSupplier;
        this.delegate.set(sessionSupplier.get());
    }

    public Publisher<RxTransaction> beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    public Publisher<RxTransaction> beginTransaction(TransactionConfig config) {
        return this.withExpiringRxSession(() -> this.delegate.get().beginTransaction(config));
    }

    public <T> Publisher<T> readTransaction(RxTransactionWork<? extends Publisher<T>> work) {
        return this.readTransaction(work, TransactionConfig.empty());
    }

    public <T> Publisher<T> readTransaction(RxTransactionWork<? extends Publisher<T>> work, TransactionConfig config) {
        return this.withExpiringRxSession(() -> this.delegate.get().readTransaction(work, config));
    }

    public <T> Publisher<T> writeTransaction(RxTransactionWork<? extends Publisher<T>> work) {
        return this.writeTransaction(work, TransactionConfig.empty());
    }

    public <T> Publisher<T> writeTransaction(RxTransactionWork<? extends Publisher<T>> work, TransactionConfig config) {
        return this.withExpiringRxSession(() -> this.delegate.get().writeTransaction(work, config));
    }

    public RxResult run(String query, TransactionConfig config) {
        return this.run(new Query(query, Collections.emptyMap()), config);
    }

    public RxResult run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Query(query, parameters), config);
    }

    public RxResult run(Query query, TransactionConfig config) {
        return new ReAuthRxResult(() -> this.delegate.get().run(query, config));
    }

    public Bookmark lastBookmark() {
        return this.delegate.get().lastBookmark();
    }

    public <T> Publisher<T> close() {
        return this.delegate.get().close();
    }

    public RxResult run(String query, Value parameters) {
        return this.run(new Query(query, parameters), TransactionConfig.empty());
    }

    public RxResult run(String query, Map<String, Object> parameters) {
        return this.run(new Query(query, parameters), TransactionConfig.empty());
    }

    public RxResult run(String query, Record parameters) {
        return this.run(new Query(query, AbstractQueryRunner.parameters((Record)parameters)), TransactionConfig.empty());
    }

    public RxResult run(String query) {
        return this.run(new Query(query, Collections.emptyMap()), TransactionConfig.empty());
    }

    public RxResult run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    <T> Publisher<T> withExpiringRxSession(Supplier<Publisher<T>> block) {
        return this.withExpiringRxSession(block, () -> {});
    }

    <T> Publisher<T> withExpiringRxSession(Supplier<Publisher<T>> block, Runnable additionalRefresh) {
        return this.driver.withRxRefresh(block, () -> {
            log.debug("Creating new session to replace expired one");
            RxSession oldSession = this.delegate.getAndSet(this.sessionSupplier.get());
            return Mono.from((Publisher)oldSession.close()).then(Mono.fromRunnable((Runnable)additionalRefresh)).doOnError(e -> log.debug("Failed to close reactive session", e)).onErrorComplete();
        });
    }

    private class ReAuthRxResult
    implements RxResult {
        private final AtomicReference<RxResult> delegate = new AtomicReference();
        private final Supplier<RxResult> resultSupplier;

        private ReAuthRxResult(Supplier<RxResult> resultSupplier) {
            this.resultSupplier = resultSupplier;
            this.delegate.set(resultSupplier.get());
        }

        public Publisher<List<String>> keys() {
            return this.withExpiringRxResult(() -> this.delegate.get().keys());
        }

        public Publisher<Record> records() {
            return this.withExpiringRxResult(() -> this.delegate.get().records());
        }

        public Publisher<ResultSummary> consume() {
            return this.withExpiringRxResult(() -> this.delegate.get().consume());
        }

        private <T> Publisher<T> withExpiringRxResult(Supplier<Publisher<T>> block) {
            return ReAuthRxSession.this.withExpiringRxSession(block, () -> this.delegate.set(this.resultSupplier.get()));
        }
    }
}

