/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.common.driver.reauth;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.neo4j.connectors.common.driver.reauth.ReAuthDriver;
import org.neo4j.connectors.common.driver.reauth.Utils;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.TransactionWork;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.AbstractQueryRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReAuthSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(ReAuthSession.class);
    private final ReAuthDriver driver;
    private final AtomicReference<Session> delegate = new AtomicReference();
    private final Supplier<Session> sessionSupplier;

    ReAuthSession(ReAuthDriver driver, Supplier<Session> sessionSupplier) {
        this.driver = driver;
        this.sessionSupplier = sessionSupplier;
        this.delegate.set(sessionSupplier.get());
    }

    public Transaction beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    public Transaction beginTransaction(TransactionConfig config) {
        return this.withExpiringSession(() -> this.delegate.get().beginTransaction(config));
    }

    public <T> T readTransaction(TransactionWork<T> work) {
        return this.readTransaction(work, TransactionConfig.empty());
    }

    public <T> T readTransaction(TransactionWork<T> work, TransactionConfig config) {
        return (T)this.withExpiringSession(() -> this.delegate.get().readTransaction(work, config));
    }

    public <T> T writeTransaction(TransactionWork<T> work) {
        return this.writeTransaction(work, TransactionConfig.empty());
    }

    public <T> T writeTransaction(TransactionWork<T> work, TransactionConfig config) {
        return (T)this.withExpiringSession(() -> this.delegate.get().writeTransaction(work, config));
    }

    public Result run(String query, TransactionConfig config) {
        return this.run(new Query(query, Collections.emptyMap()), config);
    }

    public Result run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Query(query, parameters), config);
    }

    public Result run(Query query, TransactionConfig config) {
        return this.withExpiringSession(() -> this.delegate.get().run(query, config));
    }

    public Bookmark lastBookmark() {
        return this.delegate.get().lastBookmark();
    }

    @Deprecated
    public void reset() {
        this.delegate.get().reset();
    }

    public void close() {
        this.delegate.get().close();
    }

    public Result run(String query, Value parameters) {
        return this.run(new Query(query, parameters), TransactionConfig.empty());
    }

    public Result run(String query, Map<String, Object> parameters) {
        return this.run(new Query(query, parameters), TransactionConfig.empty());
    }

    public Result run(String query, Record parameters) {
        return this.run(new Query(query, AbstractQueryRunner.parameters((Record)parameters)), TransactionConfig.empty());
    }

    public Result run(String query) {
        return this.run(new Query(query, Collections.emptyMap()), TransactionConfig.empty());
    }

    public Result run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    public boolean isOpen() {
        return this.delegate.get().isOpen();
    }

    private <T> T withExpiringSession(Supplier<T> block) {
        return this.driver.withRefresh(block, () -> {
            log.debug("Creating new session to replace expired one");
            Utils.closeQuietly((AutoCloseable)this.delegate.getAndSet(this.sessionSupplier.get()));
        });
    }
}

