/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.common.driver.reauth.tracking;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.neo4j.connectors.common.driver.reauth.tracking.TrackingDriver;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.async.AsyncTransaction;
import org.neo4j.driver.async.AsyncTransactionWork;
import org.neo4j.driver.async.ResultCursor;

public class TrackedAsyncSession
implements AsyncSession {
    private final TrackingDriver driver;
    private final AsyncSession delegate;

    public TrackedAsyncSession(TrackingDriver driver, AsyncSession delegate) {
        this.driver = driver;
        this.delegate = delegate;
    }

    public CompletionStage<AsyncTransaction> beginTransactionAsync() {
        return this.delegate.beginTransactionAsync();
    }

    public CompletionStage<AsyncTransaction> beginTransactionAsync(TransactionConfig config) {
        return this.delegate.beginTransactionAsync(config);
    }

    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.delegate.readTransactionAsync(work);
    }

    public <T> CompletionStage<T> readTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.delegate.readTransactionAsync(work, config);
    }

    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work) {
        return this.delegate.writeTransactionAsync(work);
    }

    public <T> CompletionStage<T> writeTransactionAsync(AsyncTransactionWork<CompletionStage<T>> work, TransactionConfig config) {
        return this.delegate.writeTransactionAsync(work, config);
    }

    public CompletionStage<ResultCursor> runAsync(String query, TransactionConfig config) {
        return this.delegate.runAsync(query, config);
    }

    public CompletionStage<ResultCursor> runAsync(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.delegate.runAsync(query, parameters, config);
    }

    public CompletionStage<ResultCursor> runAsync(Query query, TransactionConfig config) {
        return this.delegate.runAsync(query, config);
    }

    public Bookmark lastBookmark() {
        return this.delegate.lastBookmark();
    }

    public CompletionStage<Void> closeAsync() {
        return this.delegate.closeAsync().thenRun(this.driver::onSessionClosure);
    }

    public CompletionStage<ResultCursor> runAsync(String query, Value parameters) {
        return this.delegate.runAsync(query, parameters);
    }

    public CompletionStage<ResultCursor> runAsync(String query, Map<String, Object> parameters) {
        return this.delegate.runAsync(query, parameters);
    }

    public CompletionStage<ResultCursor> runAsync(String query, Record parameters) {
        return this.delegate.runAsync(query, parameters);
    }

    public CompletionStage<ResultCursor> runAsync(String query) {
        return this.delegate.runAsync(query);
    }

    public CompletionStage<ResultCursor> runAsync(Query query) {
        return this.delegate.runAsync(query);
    }
}

