/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.common.driver.reauth.tracking;

import java.util.Map;
import org.neo4j.connectors.common.driver.reauth.tracking.TrackingDriver;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransaction;
import org.neo4j.driver.reactive.RxTransactionWork;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class TrackedRxSession
implements RxSession {
    private final TrackingDriver driver;
    private final RxSession delegate;

    public TrackedRxSession(TrackingDriver driver, RxSession delegate) {
        this.driver = driver;
        this.delegate = delegate;
    }

    public Publisher<RxTransaction> beginTransaction() {
        return this.delegate.beginTransaction();
    }

    public Publisher<RxTransaction> beginTransaction(TransactionConfig config) {
        return this.delegate.beginTransaction(config);
    }

    public <T> Publisher<T> readTransaction(RxTransactionWork<? extends Publisher<T>> work) {
        return this.delegate.readTransaction(work);
    }

    public <T> Publisher<T> readTransaction(RxTransactionWork<? extends Publisher<T>> work, TransactionConfig config) {
        return this.delegate.readTransaction(work, config);
    }

    public <T> Publisher<T> writeTransaction(RxTransactionWork<? extends Publisher<T>> work) {
        return this.delegate.writeTransaction(work);
    }

    public <T> Publisher<T> writeTransaction(RxTransactionWork<? extends Publisher<T>> work, TransactionConfig config) {
        return this.delegate.writeTransaction(work, config);
    }

    public RxResult run(String query, TransactionConfig config) {
        return this.delegate.run(query, config);
    }

    public RxResult run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.delegate.run(query, parameters, config);
    }

    public RxResult run(Query query, TransactionConfig config) {
        return this.delegate.run(query, config);
    }

    public Bookmark lastBookmark() {
        return this.delegate.lastBookmark();
    }

    public <T> Publisher<T> close() {
        return Mono.from((Publisher)this.delegate.close()).then(Mono.fromRunnable(this.driver::onSessionClosure));
    }

    public RxResult run(String query, Value parameters) {
        return this.delegate.run(query, parameters);
    }

    public RxResult run(String query, Map<String, Object> parameters) {
        return this.delegate.run(query, parameters);
    }

    public RxResult run(String query, Record parameters) {
        return this.delegate.run(query, parameters);
    }

    public RxResult run(String query) {
        return this.delegate.run(query);
    }

    public RxResult run(Query query) {
        return this.delegate.run(query);
    }
}

