/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.common.driver.reauth.tracking;

import java.util.Map;
import java.util.Objects;
import org.neo4j.connectors.common.driver.reauth.tracking.TrackingDriver;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.TransactionWork;
import org.neo4j.driver.Value;

public class TrackedSession
implements Session {
    private final TrackingDriver driver;
    private final Session delegate;

    public TrackedSession(TrackingDriver driver, Session delegate) {
        this.driver = Objects.requireNonNull(driver);
        this.delegate = Objects.requireNonNull(delegate);
    }

    public Transaction beginTransaction() {
        return this.delegate.beginTransaction();
    }

    public Transaction beginTransaction(TransactionConfig config) {
        return this.delegate.beginTransaction(config);
    }

    public <T> T readTransaction(TransactionWork<T> work) {
        return (T)this.delegate.readTransaction(work);
    }

    public <T> T readTransaction(TransactionWork<T> work, TransactionConfig config) {
        return (T)this.delegate.readTransaction(work, config);
    }

    public <T> T writeTransaction(TransactionWork<T> work) {
        return (T)this.delegate.writeTransaction(work);
    }

    public <T> T writeTransaction(TransactionWork<T> work, TransactionConfig config) {
        return (T)this.delegate.writeTransaction(work, config);
    }

    public Result run(String query, TransactionConfig config) {
        return this.delegate.run(query, config);
    }

    public Result run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.delegate.run(query, parameters, config);
    }

    public Result run(Query query, TransactionConfig config) {
        return this.delegate.run(query, config);
    }

    public Bookmark lastBookmark() {
        return this.delegate.lastBookmark();
    }

    @Deprecated
    public void reset() {
        this.delegate.reset();
    }

    public void close() {
        this.delegate.close();
        this.driver.onSessionClosure();
    }

    public Result run(String query, Value parameters) {
        return this.delegate.run(query, parameters);
    }

    public Result run(String query, Map<String, Object> parameters) {
        return this.delegate.run(query, parameters);
    }

    public Result run(String query, Record parameters) {
        return this.delegate.run(query, parameters);
    }

    public Result run(String query) {
        return this.delegate.run(query);
    }

    public Result run(Query query) {
        return this.delegate.run(query);
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }
}

