/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.common.driver.reauth.tracking;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.connectors.common.driver.reauth.tracking.TrackedAsyncSession;
import org.neo4j.connectors.common.driver.reauth.tracking.TrackedRxSession;
import org.neo4j.connectors.common.driver.reauth.tracking.TrackedSession;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.types.TypeSystem;

public class TrackingDriver
implements Driver {
    private final Driver delegate;
    private final AtomicInteger sessionCount = new AtomicInteger(0);

    public TrackingDriver(Driver delegate) {
        this.delegate = delegate;
    }

    public boolean isEncrypted() {
        return this.delegate.isEncrypted();
    }

    public Session session() {
        return this.session(SessionConfig.defaultConfig());
    }

    public Session session(SessionConfig sessionConfig) {
        Session session = this.delegate.session(sessionConfig);
        this.sessionCount.incrementAndGet();
        return new TrackedSession(this, session);
    }

    public RxSession rxSession() {
        return this.rxSession(SessionConfig.defaultConfig());
    }

    public RxSession rxSession(SessionConfig sessionConfig) {
        RxSession session = this.delegate.rxSession(sessionConfig);
        this.sessionCount.incrementAndGet();
        return new TrackedRxSession(this, session);
    }

    public AsyncSession asyncSession() {
        return this.asyncSession(SessionConfig.defaultConfig());
    }

    public AsyncSession asyncSession(SessionConfig sessionConfig) {
        AsyncSession session = this.delegate.asyncSession(sessionConfig);
        this.sessionCount.incrementAndGet();
        return new TrackedAsyncSession(this, session);
    }

    public void close() {
        this.delegate.close();
    }

    public CompletionStage<Void> closeAsync() {
        return this.delegate.closeAsync();
    }

    public Metrics metrics() {
        return this.delegate.metrics();
    }

    public boolean isMetricsEnabled() {
        return this.delegate.isMetricsEnabled();
    }

    public TypeSystem defaultTypeSystem() {
        return this.delegate.defaultTypeSystem();
    }

    public void verifyConnectivity() {
        this.delegate.verifyConnectivity();
    }

    public CompletionStage<Void> verifyConnectivityAsync() {
        return this.delegate.verifyConnectivityAsync();
    }

    public boolean supportsMultiDb() {
        return this.delegate.supportsMultiDb();
    }

    public CompletionStage<Boolean> supportsMultiDbAsync() {
        return this.delegate.supportsMultiDbAsync();
    }

    public void onSessionClosure() {
        this.sessionCount.decrementAndGet();
    }

    public int getOpenSessionCount() {
        return this.sessionCount.get();
    }
}

