/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [https://neo4j.com]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.neo4j.cypher.internal.ast

import org.neo4j.cypher.internal.CypherVersion
import org.neo4j.cypher.internal.CypherVersionHelpers.arbitrarySemanticContext
import org.neo4j.cypher.internal.ast.semantics.SemanticCheck
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckContext
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckResult
import org.neo4j.cypher.internal.ast.semantics.SemanticState
import org.neo4j.cypher.internal.util.NotImplementedErrorMessageProvider

object SemanticCheckInTest {

  implicit class SemanticCheckWithDefaultContext(check: SemanticCheck) {

    @deprecated("handle cypher versioning properly in your tests!", "2025.06")
    def run(state: SemanticState): SemanticCheckResult = check.run(state, arbitrarySemanticContext())

    @deprecated("handle cypher versioning properly in your tests!", "2025.06")
    def runWithCypher5(state: SemanticState): SemanticCheckResult =
      check.run(state, SemanticCheckContext(CypherVersion.Cypher5, NotImplementedErrorMessageProvider))

    def run(state: SemanticState, version: CypherVersion): SemanticCheckResult = check.run(
      state,
      SemanticCheckContext(version, NotImplementedErrorMessageProvider)
    )
  }
}
