/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckContext;
import org.neo4j.cypher.internal.ast.semantics.SemanticCheckContext$;
import org.neo4j.cypher.internal.util.ErrorMessageProvider;
import org.neo4j.cypher.internal.util.NotImplementedErrorMessageProvider$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.matchers.should.Matchers$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.util.Random$;

public final class CypherVersionHelpers$ {
    public static final CypherVersionHelpers$ MODULE$ = new CypherVersionHelpers$();

    public CypherVersion randomVersion() {
        CypherVersion[] values = CypherVersion.values();
        return values[Random$.MODULE$.nextInt(values.length)];
    }

    public SemanticCheckContext arbitrarySemanticContext() {
        return SemanticCheckContext$.MODULE$.apply(this.randomVersion(), (ErrorMessageProvider)NotImplementedErrorMessageProvider$.MODULE$);
    }

    public <T> T equalInVersions(Seq<CypherVersion> versions, Function1<CypherVersion, T> f) {
        CypherVersion baselineVersion = (CypherVersion)versions.apply(Random$.MODULE$.nextInt(versions.size()));
        return (T)versions.foldLeft(f.apply((Object)baselineVersion), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Object baseline = tuple2._1();
                CypherVersion cypherVersion = (CypherVersion)tuple2._2();
                CypherVersion cypherVersion2 = baselineVersion;
                CypherVersion cypherVersion3 = cypherVersion;
                if (!(cypherVersion2 != null ? !cypherVersion2.equals(cypherVersion3) : cypherVersion3 != null)) {
                    return baseline;
                }
            }
            if (tuple2 != null) {
                Object baseline = tuple2._1();
                CypherVersion version = (CypherVersion)tuple2._2();
                Object result = f.apply((Object)version);
                Assertions$.MODULE$.withClue((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Expected the same value but got:\n             |CYPHER " + baselineVersion + ": " + baseline + "\n             |CYPHER " + version + ": " + result + "\n             |")), (Function0 & Serializable)() -> Matchers$.MODULE$.convertToAnyShouldWrapper(result, new Position("CypherVersionTestSupport.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50), Prettifier$.MODULE$.default()).shouldBe(baseline));
                return baseline;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public <T> T equalInAllVersions(Function1<CypherVersion, T> f) {
        return this.equalInVersions((Seq<CypherVersion>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)CypherVersion.values()), f);
    }

    private CypherVersionHelpers$() {
    }
}

