/**
 * Copyright (c) 2002-2010 "Neo Technology,"
 * Network Engine for Objects in Lund AB [http://neotechnology.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package org.neo4j.kernel.ha;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.neo4j.helpers.Pair;

public class TransactionStreams
{
    public static final TransactionStreams EMPTY = new TransactionStreams()
    {
        @Override
        public void add( String resource, TransactionStream stream )
        {
            throw new UnsupportedOperationException( "read-only instance" );
        }
    };
    
    private List<Pair<String, TransactionStream>> streams;
    
    public void add( String resource, TransactionStream stream )
    {
        ensureListInstantiated();
        this.streams.add( new Pair<String, TransactionStream>( resource, stream ) );
    }
    
    public Collection<Pair<String, TransactionStream>> getStreams()
    {
        return streams == null ? Collections.<Pair<String, TransactionStream>>emptyList() :
                Collections.unmodifiableList( streams );
    }
    
    private void ensureListInstantiated()
    {
        if ( streams == null )
        {
            streams = new ArrayList<Pair<String,TransactionStream>>();
        }
    }

    public void close() throws IOException
    {
        if ( streams != null )
        {
            for ( Pair<String, TransactionStream> stream : streams )
            {
                stream.other().close();
            }
        }
    }
}
