/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.shell.impl.RmiLocation;
import slavetest.AbstractHaTest;
import slavetest.CommonJobs;
import slavetest.DoubleLatch;
import slavetest.Fetcher;
import slavetest.Job;
import slavetest.MultiJvmDLFetcher;
import slavetest.StandaloneDb;
import slavetest.StandaloneDbCom;

public class MultiJvmTest
extends AbstractHaTest {
    private static final int MASTER_PORT = 8990;
    private List<StandaloneDbCom> jvms;

    @Override
    protected void initializeDbs(int numSlaves, Map<String, String> config) throws Exception {
        this.jvms = new ArrayList<StandaloneDbCom>();
        try {
            this.createDeadDbs(numSlaves);
            this.startUpMaster(config);
            for (int i = 1; i <= numSlaves; ++i) {
                File slavePath = MultiJvmTest.dbPath(i);
                StandaloneDbCom slaveJvm = this.spawnJvm(slavePath, 8990 + i, i, MultiJvmTest.buildExtraArgs(config));
                this.jvms.add(slaveJvm);
            }
            Thread.sleep(1000L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String[] buildExtraArgs(Map<String, String> config) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            list.add("-" + entry.getKey());
            list.add(entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void shutdownDbsAndVerify() throws Exception {
        this.shutdownDbs();
        EmbeddedGraphDatabase masterDb = new EmbeddedGraphDatabase(MultiJvmTest.dbPath(0).getAbsolutePath());
        try {
            for (int i = 1; i < this.jvms.size(); ++i) {
                EmbeddedGraphDatabase slaveDb = new EmbeddedGraphDatabase(MultiJvmTest.dbPath(i).getAbsolutePath());
                try {
                    this.verify((GraphDatabaseService)masterDb, new GraphDatabaseService[]{slaveDb});
                    continue;
                }
                finally {
                    slaveDb.shutdown();
                }
            }
        }
        finally {
            masterDb.shutdown();
        }
    }

    @Override
    protected void shutdownDbs() throws Exception {
        for (StandaloneDbCom slave : this.jvms) {
            slave.initiateShutdown();
        }
        for (int i = 0; i < this.jvms.size(); ++i) {
            this.waitUntilShutdownFileFound(MultiJvmTest.dbPath(i));
        }
    }

    protected void waitUntilShutdownFileFound(File slavePath) throws Exception {
        File file = new File(slavePath, "shutdown");
        while (!file.exists()) {
            Thread.sleep(100L);
        }
    }

    protected StandaloneDbCom spawnJvm(File path, int port, int machineId, String ... extraArgs) throws Exception {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("java", "-cp", System.getProperty("java.class.path"), StandaloneDb.class.getName(), "-path", path.getAbsolutePath(), "-port", "" + port, "-id", "" + machineId, "-master-id", "0"));
        list.addAll(Arrays.asList(extraArgs));
        Runtime.getRuntime().exec(list.toArray(new String[list.size()]));
        return this.awaitJvmStarted(port);
    }

    private StandaloneDbCom awaitJvmStarted(int port) throws RemoteException {
        long startTime = System.currentTimeMillis();
        RmiLocation location = RmiLocation.location((String)"localhost", (int)port, (String)"interface");
        RemoteException latestException = null;
        StandaloneDbCom result = null;
        while (result == null && System.currentTimeMillis() - startTime < 10000L) {
            try {
                result = (StandaloneDbCom)location.getBoundObject();
            }
            catch (RemoteException e) {
                latestException = e;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ee) {}
            }
        }
        if (result == null) {
            throw latestException;
        }
        return result;
    }

    @Override
    protected void pullUpdates(int ... slaves) throws Exception {
        if (slaves.length == 0) {
            for (int i = 1; i < this.jvms.size(); ++i) {
                this.jvms.get(i).pullUpdates();
            }
        } else {
            for (int slave : slaves) {
                this.jvms.get(slave + 1).pullUpdates();
            }
        }
    }

    @Override
    protected <T> T executeJob(Job<T> job, int onSlave) throws Exception {
        return this.jvms.get(onSlave + 1).executeJob(job);
    }

    @Override
    protected <T> T executeJobOnMaster(Job<T> job) throws Exception {
        return this.jvms.get(0).executeJob(job);
    }

    @Override
    protected void startUpMaster(Map<String, String> config) throws Exception {
        HashMap<String, String> newConfig = new HashMap<String, String>(config);
        newConfig.put("master", "true");
        StandaloneDbCom com = this.spawnJvm(MultiJvmTest.dbPath(0), 8990, 0, MultiJvmTest.buildExtraArgs(newConfig));
        if (this.jvms.isEmpty()) {
            this.jvms.add(com);
        } else {
            this.jvms.set(0, com);
        }
        Thread.sleep(1000L);
    }

    @Override
    protected Job<Void> getMasterShutdownDispatcher() {
        return new CommonJobs.ShutdownJvm(this.jvms.get(0));
    }

    @Override
    protected Fetcher<DoubleLatch> getDoubleLatch() throws Exception {
        return new MultiJvmDLFetcher();
    }
}

