/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.neo4j.kernel.ha.zookeeper.ClusterManager;
import org.neo4j.kernel.ha.zookeeper.LocalZooKeeperCluster;
import slavetest.Job;
import slavetest.MultiJvmTest;
import slavetest.StandaloneDbCom;

@Ignore
public class MultiJvmWithZooKeeperTest
extends MultiJvmTest {
    private static final File BASE_ZOO_KEEPER_DATA_DIR = new File(new File("target"), "zookeeper-data");
    private static final int BASE_HA_SERVER_PORT = 5559;
    private static final int ZOO_KEEPER_CLUSTER_SIZE = 3;
    private static LocalZooKeeperCluster zooKeeperCluster;
    private ClusterManager zooKeeperMasterFetcher;
    private Map<Integer, StandaloneDbCom> jvmByMachineId;

    @Before
    public void startZooKeeperCluster() throws Exception {
        FileUtils.deleteDirectory((File)BASE_ZOO_KEEPER_DATA_DIR);
        zooKeeperCluster = new LocalZooKeeperCluster(3, BASE_ZOO_KEEPER_DATA_DIR);
    }

    @Override
    protected void initializeDbs(int numSlaves, Map<String, String> config) throws Exception {
        this.jvmByMachineId = new HashMap<Integer, StandaloneDbCom>();
        super.initializeDbs(numSlaves, config);
        this.zooKeeperMasterFetcher = new ClusterManager(MultiJvmWithZooKeeperTest.buildZooKeeperServersConfigValue(3));
        for (StandaloneDbCom db : this.jvmByMachineId.values()) {
            db.awaitStarted();
        }
    }

    @Override
    protected StandaloneDbCom spawnJvm(File path, int port, int machineId, String ... extraArgs) throws Exception {
        ArrayList<String> myExtraArgs = new ArrayList<String>();
        myExtraArgs.add("-ha.machine_id");
        myExtraArgs.add("" + (machineId + 1));
        myExtraArgs.add("-ha.zoo_keeper_servers");
        myExtraArgs.add(MultiJvmWithZooKeeperTest.buildZooKeeperServersConfigValue(3));
        myExtraArgs.add("-ha.server");
        myExtraArgs.add(MultiJvmWithZooKeeperTest.buildHaServerConfigValue(machineId));
        myExtraArgs.addAll(Arrays.asList(extraArgs));
        StandaloneDbCom com = super.spawnJvm(path, port, machineId, myExtraArgs.toArray(new String[myExtraArgs.size()]));
        this.jvmByMachineId.put(machineId + 1, com);
        return com;
    }

    private static String buildHaServerConfigValue(int machineId) {
        return "localhost:" + (5559 + machineId);
    }

    private static String buildZooKeeperServersConfigValue(int zooKeeperClusterSize) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < zooKeeperClusterSize; ++i) {
            builder.append((i > 0 ? "," : "") + "localhost:" + zooKeeperCluster.getClientPortPolicy().getPort(i + 1));
        }
        return builder.toString();
    }

    @Override
    protected <T> T executeJobOnMaster(Job<T> job) throws Exception {
        return this.jvmByMachineId.get(1).executeJob(job);
    }

    @After
    public void shutdownZooKeeperCluster() {
        zooKeeperCluster.shutdown();
    }
}

