/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.FakeMasterBroker;
import org.neo4j.kernel.ha.FakeSlaveBroker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterImpl;
import slavetest.AbstractHaTest;
import slavetest.CommonJobs;
import slavetest.DoubleLatch;
import slavetest.Fetcher;
import slavetest.Job;

public class SingleJvmTest
extends AbstractHaTest {
    private MasterImpl master;
    private List<GraphDatabaseService> haDbs;

    protected GraphDatabaseService getSlave(int nr) {
        return this.haDbs.get(nr);
    }

    @Override
    protected void initializeDbs(int numSlaves, Map<String, String> config) {
        try {
            this.createDeadDbs(numSlaves);
            this.haDbs = new ArrayList<GraphDatabaseService>();
            this.startUpMaster(config);
            for (int i = 1; i <= numSlaves; ++i) {
                File slavePath = SingleJvmTest.dbPath(i);
                Broker broker = this.makeSlaveBroker(this.master, 0, i, slavePath.getAbsolutePath());
                HashMap<String, String> cfg = new HashMap<String, String>(config);
                cfg.put("ha.machine_id", Integer.toString(i));
                cfg.put("keep_logical_logs", "true");
                HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(slavePath.getAbsolutePath(), cfg, AbstractBroker.wrapSingleBroker((Broker)broker));
                this.haDbs.add((GraphDatabaseService)db);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void startUpMaster(Map<String, String> extraConfig) {
        int masterId = 0;
        Map config = MapUtil.stringMap(extraConfig, (String[])new String[]{"ha.machine_id", String.valueOf(masterId)});
        Broker broker = this.makeMasterBroker(this.master, masterId, SingleJvmTest.dbPath(0).getAbsolutePath());
        HighlyAvailableGraphDatabase db = new HighlyAvailableGraphDatabase(SingleJvmTest.dbPath(0).getAbsolutePath(), config, AbstractBroker.wrapSingleBroker((Broker)broker));
        this.master = new MasterImpl((GraphDatabaseService)db);
    }

    protected Broker makeMasterBroker(MasterImpl master, int masterId, String path) {
        return new FakeMasterBroker(masterId, path);
    }

    protected Broker makeSlaveBroker(MasterImpl master, int masterId, int id, String path) {
        return new FakeSlaveBroker((Master)master, masterId, id, path);
    }

    protected MasterImpl getMaster() {
        return this.master;
    }

    @Override
    protected void shutdownDbs() {
        for (GraphDatabaseService haDb : this.haDbs) {
            haDb.shutdown();
        }
        this.master.getGraphDb().shutdown();
    }

    @After
    public void verifyAndShutdownDbs() {
        this.verify(this.master.getGraphDb(), this.haDbs.toArray(new GraphDatabaseService[this.haDbs.size()]));
        this.shutdownDbs();
        EmbeddedGraphDatabase masterOfflineDb = new EmbeddedGraphDatabase(SingleJvmTest.dbPath(0).getAbsolutePath());
        GraphDatabaseService[] slaveOfflineDbs = new GraphDatabaseService[this.haDbs.size()];
        for (int i = 1; i <= this.haDbs.size(); ++i) {
            slaveOfflineDbs[i - 1] = new EmbeddedGraphDatabase(SingleJvmTest.dbPath(i).getAbsolutePath());
        }
        this.verify((GraphDatabaseService)masterOfflineDb, slaveOfflineDbs);
        masterOfflineDb.shutdown();
        for (GraphDatabaseService db : slaveOfflineDbs) {
            db.shutdown();
        }
    }

    @Override
    protected <T> T executeJob(Job<T> job, int slave) throws Exception {
        return job.execute(this.haDbs.get(slave));
    }

    @Override
    protected <T> T executeJobOnMaster(Job<T> job) throws Exception {
        return job.execute(this.master.getGraphDb());
    }

    @Override
    protected void pullUpdates(int ... ids) {
        if (ids.length == 0) {
            for (GraphDatabaseService db : this.haDbs) {
                ((HighlyAvailableGraphDatabase)db).pullUpdates();
            }
        } else {
            for (int id : ids) {
                ((HighlyAvailableGraphDatabase)this.haDbs.get(id)).pullUpdates();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMixingEntitiesFromWrongDbs() throws Exception {
        this.initializeDbs(1);
        GraphDatabaseService haDb1 = this.haDbs.get(0);
        GraphDatabaseService mDb = this.master.getGraphDb();
        Transaction tx = mDb.beginTx();
        try {
            Node masterNode = mDb.createNode();
            mDb.getReferenceNode().createRelationshipTo(masterNode, CommonJobs.REL_TYPE);
            tx.success();
        }
        finally {
            tx.finish();
        }
        tx = haDb1.beginTx();
        try {
            Node node = haDb1.createNode();
            mDb.getReferenceNode().createRelationshipTo(node, CommonJobs.KNOWS);
            Assert.fail((String)"Should throw not found exception");
        }
        catch (NotFoundException e) {
        }
        finally {
            tx.finish();
        }
    }

    @Override
    protected Job<Void> getMasterShutdownDispatcher() {
        return new Job<Void>(){

            @Override
            public Void execute(GraphDatabaseService db) {
                SingleJvmTest.this.master.getGraphDb().shutdown();
                return null;
            }
        };
    }

    @Override
    protected Fetcher<DoubleLatch> getDoubleLatch() {
        return new Fetcher<DoubleLatch>(){
            private final DoubleLatch latch = new DoubleLatch(){
                private final CountDownLatch first = new CountDownLatch(1);
                private final CountDownLatch second = new CountDownLatch(1);

                @Override
                public void countDownSecond() {
                    this.second.countDown();
                }

                @Override
                public void countDownFirst() {
                    this.first.countDown();
                }

                @Override
                public void awaitSecond() {
                    this.await(this.second);
                }

                @Override
                public void awaitFirst() {
                    this.await(this.first);
                }

                private void await(CountDownLatch latch) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                        e.printStackTrace();
                    }
                }
            };

            @Override
            public DoubleLatch fetch() {
                return this.latch;
            }

            @Override
            public void close() {
            }
        };
    }
}

