/*
 * Decompiled with CFR 0.152.
 */
package slavetest;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.ha.AbstractBroker;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.FakeMasterBroker;
import org.neo4j.kernel.ha.FakeSlaveBroker;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterClient;
import org.neo4j.shell.impl.RmiLocation;
import slavetest.Job;
import slavetest.StandaloneDbCom;

public class StandaloneDb
extends UnicastRemoteObject
implements StandaloneDbCom {
    private final PrintStream out;
    private final String storeDir;
    private final HighlyAvailableGraphDatabase db;
    private final RmiLocation location;
    private volatile boolean shutdown;
    private final int machineId;

    public StandaloneDb(Args args, RmiLocation location) throws Exception {
        this.storeDir = args.get("path", null);
        this.out = new PrintStream(new File(new File(this.storeDir), "output")){

            @Override
            public void println(String x) {
                super.println(new SimpleDateFormat("HH:mm:ss:SS").format(new Date()) + ": " + x);
            }
        };
        System.setOut(this.out);
        System.setErr(this.out);
        try {
            int tempMachineId;
            System.out.println("About to start");
            HighlyAvailableGraphDatabase haDb = null;
            System.out.println(args.asMap().toString());
            if (args.has("ha.machine_id")) {
                new EmbeddedGraphDatabase(this.storeDir).shutdown();
                tempMachineId = args.getNumber("ha.machine_id", null).intValue();
                Map config = MapUtil.stringMap((String[])new String[]{"ha.machine_id", "" + tempMachineId, "ha.zoo_keeper_servers", args.get("ha.zoo_keeper_servers", null), "ha.server", args.get("ha.server", null), "index", args.get("index", null)});
                haDb = new HighlyAvailableGraphDatabase(this.storeDir, config);
                System.out.println("Started HA db (w/ zoo keeper)");
            } else {
                boolean isMaster = args.getBoolean("master", Boolean.valueOf(false));
                tempMachineId = args.getNumber("id", null).intValue();
                Number masterId = args.getNumber("master-id", null);
                MasterClient master = new MasterClient("localhost", 8901, this.storeDir);
                FakeMasterBroker broker = isMaster ? new FakeMasterBroker(tempMachineId, this.storeDir) : new FakeSlaveBroker((Master)master, masterId.intValue(), tempMachineId, this.storeDir);
                haDb = new HighlyAvailableGraphDatabase(this.storeDir, MapUtil.stringMap((String[])new String[]{"ha.machine_id", "" + tempMachineId, "index", args.get("index", null)}), AbstractBroker.wrapSingleBroker((Broker)broker));
                System.out.println("Started HA db (w/o zoo keeper)");
            }
            this.location = location;
            this.location.ensureRegistryCreated();
            this.location.bind((Remote)this);
            this.machineId = tempMachineId;
            this.db = haDb;
            System.out.println("RMI object bound");
        }
        catch (Exception e) {
            this.println("Exception", e);
            throw e;
        }
    }

    private void println(String string, Throwable t) {
        System.out.println(string);
        t.printStackTrace();
    }

    public static void main(String[] args) throws Exception {
        Args arguments = new Args(args);
        RmiLocation location = RmiLocation.location((String)"localhost", (int)arguments.getNumber("port", null).intValue(), (String)"interface");
        StandaloneDb db = new StandaloneDb(arguments, location);
        db.waitForShutdown();
    }

    private void waitForShutdown() {
        while (!this.shutdown) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }

    @Override
    public void initiateShutdown() throws RemoteException {
        System.out.println("Shutdown initiated");
        this.location.unbind((Remote)this);
        this.db.shutdown();
        this.shutdown = true;
        System.out.println("Shutdown done");
        try {
            new File(new File(this.storeDir), "shutdown").createNewFile();
        }
        catch (IOException e) {
            this.println("Couldn't create file, damn it", e);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                System.exit(0);
            }
        }.start();
    }

    @Override
    public <T> T executeJob(Job<T> job) throws RemoteException {
        System.out.println("Executing job " + job);
        T result = job.execute((GraphDatabaseService)this.db);
        System.out.println("Job " + job + " executed");
        return result;
    }

    @Override
    public void pullUpdates() {
        System.out.println("pullUpdates");
        this.db.pullUpdates();
    }

    @Override
    public int getMachineId() {
        return this.machineId;
    }

    @Override
    public void awaitStarted() {
        while (this.db == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }
}

