/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.KernelExtension;
import org.neo4j.kernel.ha.ConnectionInformation;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.SlaveContext;
import org.neo4j.management.HighAvailability;
import org.neo4j.management.InstanceInfo;
import org.neo4j.management.SlaveInfo;
import org.neo4j.management.impl.Description;
import org.neo4j.management.impl.ManagementBeanProvider;
import org.neo4j.management.impl.Neo4jMBean;

public final class HighAvailabilityBean
extends ManagementBeanProvider {
    private static final DateFormat ISO8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");

    public HighAvailabilityBean() {
        super(HighAvailability.class);
    }

    protected Neo4jMBean createMXBean(KernelExtension.KernelData kernel) throws NotCompliantMBeanException {
        return new HighAvailibilityImpl(this, kernel, true);
    }

    protected Neo4jMBean createMBean(KernelExtension.KernelData kernel) throws NotCompliantMBeanException {
        return new HighAvailibilityImpl(this, kernel);
    }

    @Description(value="Information about an instance participating in a HA cluster")
    private static class HighAvailibilityImpl
    extends Neo4jMBean
    implements HighAvailability {
        private final HighlyAvailableGraphDatabase db;

        HighAvailibilityImpl(ManagementBeanProvider provider, KernelExtension.KernelData kernel) throws NotCompliantMBeanException {
            super(provider, kernel);
            this.db = (HighlyAvailableGraphDatabase)kernel.graphDatabase();
        }

        HighAvailibilityImpl(ManagementBeanProvider provider, KernelExtension.KernelData kernel, boolean isMXBean) {
            super(provider, kernel, isMXBean);
            this.db = (HighlyAvailableGraphDatabase)kernel.graphDatabase();
        }

        @Description(value="The identifier used to identify this machine in the HA cluster")
        public String getMachineId() {
            return Integer.toString(this.db.getMachineId());
        }

        public InstanceInfo[] getInstancesInCluster() {
            ConnectionInformation[] connections = this.db.getBroker().getConnectionInformation();
            InstanceInfo[] result = new InstanceInfo[connections.length];
            for (int i = 0; i < result.length; ++i) {
                ConnectionInformation connection = connections[i];
                result[i] = new InstanceInfo(connection.getJMXServiceURL(), connection.getInstanceId(), connection.getMachineId(), connection.isMaster(), connection.getLastCommitedTransactionId());
            }
            return result;
        }

        @Description(value="Whether this instance is master or not")
        public boolean isMaster() {
            return this.db.getMasterServerIfMaster() != null;
        }

        @Description(value="(If this is a master) Information about the instances connected to this instance")
        public SlaveInfo[] getConnectedSlaves() {
            MasterServer master = this.db.getMasterServerIfMaster();
            if (master == null) {
                return null;
            }
            ArrayList<SlaveInfo> result = new ArrayList<SlaveInfo>();
            for (Map.Entry<Integer, Collection<SlaveContext>> entry : master.getSlaveInformation().entrySet()) {
                result.add(this.slaveInfo(entry.getKey(), entry.getValue()));
            }
            return result.toArray(new SlaveInfo[result.size()]);
        }

        public String getLastUpdateTime() {
            return ISO8601.format(new Date(this.db.lastUpdateTime()));
        }

        @Description(value="(If this is a slave) Update the database on this instance with the latest transactions from the master")
        public String update() {
            long time = System.currentTimeMillis();
            try {
                this.db.pullUpdates();
            }
            catch (Exception e) {
                return "Update failed: " + e;
            }
            time = System.currentTimeMillis() - time;
            return "Update completed in " + time + "ms";
        }

        private SlaveInfo slaveInfo(int machineId, Collection<SlaveContext> contexts) {
            ArrayList<SlaveInfo.SlaveTransaction> txInfo = new ArrayList<SlaveInfo.SlaveTransaction>();
            for (SlaveContext context : contexts) {
                HashMap<Object, Object> lastTransactions = new HashMap<Object, Object>();
                for (Pair<String, Long> tx : context.lastAppliedTransactions()) {
                    lastTransactions.put(tx.first(), tx.other());
                }
                txInfo.add(new SlaveInfo.SlaveTransaction(context.getEventIdentifier(), lastTransactions));
            }
            ConnectionInformation connection = this.db.getBroker().getConnectionInformation(machineId);
            return new SlaveInfo(connection.getJMXServiceURL(), connection.getInstanceId(), machineId, false, connection.getLastCommitedTransactionId(), txInfo.toArray(new SlaveInfo.SlaveTransaction[txInfo.size()]));
        }
    }
}

