/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.ReadableByteChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDbImpl;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.LockManagerFactory;
import org.neo4j.kernel.ha.BranchedDataException;
import org.neo4j.kernel.ha.Broker;
import org.neo4j.kernel.ha.BrokerFactory;
import org.neo4j.kernel.ha.HaCommunicationException;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterIdGeneratorFactory;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.MasterTxIdGenerator;
import org.neo4j.kernel.ha.Response;
import org.neo4j.kernel.ha.ResponseReceiver;
import org.neo4j.kernel.ha.SlaveContext;
import org.neo4j.kernel.ha.SlaveIdGenerator;
import org.neo4j.kernel.ha.SlaveLockManager;
import org.neo4j.kernel.ha.SlaveRelationshipTypeCreator;
import org.neo4j.kernel.ha.SlaveTxIdGenerator;
import org.neo4j.kernel.ha.SlaveTxRollbackHook;
import org.neo4j.kernel.ha.TimeUtil;
import org.neo4j.kernel.ha.TransactionStream;
import org.neo4j.kernel.ha.ZooKeeperLastCommittedTxIdSetter;
import org.neo4j.kernel.ha.zookeeper.Machine;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperBroker;
import org.neo4j.kernel.ha.zookeeper.ZooKeeperException;
import org.neo4j.kernel.impl.core.LastCommittedTxIdSetter;
import org.neo4j.kernel.impl.core.RelationshipTypeCreator;
import org.neo4j.kernel.impl.transaction.TxFinishHook;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.TxIdGeneratorFactory;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.kernel.impl.util.StringLogger;

public class HighlyAvailableGraphDatabase
extends AbstractGraphDatabase
implements GraphDatabaseService,
ResponseReceiver {
    public static final String CONFIG_KEY_HA_MACHINE_ID = "ha.machine_id";
    public static final String CONFIG_KEY_HA_ZOO_KEEPER_SERVERS = "ha.zoo_keeper_servers";
    public static final String CONFIG_KEY_HA_SERVER = "ha.server";
    public static final String CONFIG_KEY_HA_PULL_INTERVAL = "ha.pull_interval";
    public static final String CONFIG_KEY_HA_SKELETON_DB_PATH = "ha.skeleton_db_path";
    private final String storeDir;
    private final Map<String, String> config;
    private final BrokerFactory brokerFactory;
    private final Broker broker;
    private volatile EmbeddedGraphDbImpl localGraph;
    private final int machineId;
    private volatile MasterServer masterServer;
    private ScheduledExecutorService updatePuller;
    private volatile long updateTime = 0L;
    private volatile RuntimeException causeOfShutdown;
    private final List<KernelEventHandler> kernelEventHandlers = new CopyOnWriteArrayList<KernelEventHandler>();
    private final Collection<TransactionEventHandler<?>> transactionEventHandlers = new CopyOnWriteArraySet();
    private final StringLogger msgLog;

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> config) {
        if (config == null) {
            throw new IllegalArgumentException("null config, proper configuration required");
        }
        this.storeDir = storeDir;
        this.config = config;
        config.put("keep_logical_logs", "true");
        this.brokerFactory = this.defaultBrokerFactory(storeDir, config);
        this.machineId = HighlyAvailableGraphDatabase.getMachineIdFromConfig(config);
        this.broker = this.brokerFactory.create(storeDir, config);
        this.msgLog = StringLogger.getLogger((String)(storeDir + "/messages.log"));
        this.startUp();
    }

    public HighlyAvailableGraphDatabase(String storeDir, Map<String, String> config, BrokerFactory brokerFactory) {
        this.storeDir = storeDir;
        this.config = config;
        config.put("keep_logical_logs", "true");
        this.brokerFactory = brokerFactory;
        this.machineId = HighlyAvailableGraphDatabase.getMachineIdFromConfig(config);
        this.broker = brokerFactory.create(storeDir, config);
        this.msgLog = StringLogger.getLogger((String)(storeDir + "/messages.log"));
        this.startUp();
    }

    public static Map<String, String> loadConfigurations(String file) {
        return EmbeddedGraphDatabase.loadConfigurations((String)file);
    }

    private void startUp() {
        this.newMaster(null, new Exception());
        this.localGraph();
    }

    private EmbeddedGraphDbImpl localGraph() {
        if (this.localGraph == null) {
            if (this.causeOfShutdown != null) {
                throw this.causeOfShutdown;
            }
            throw new RuntimeException("Failed to find a master");
        }
        return this.localGraph;
    }

    private BrokerFactory defaultBrokerFactory(String storeDir, Map<String, String> config) {
        return new BrokerFactory(){

            @Override
            public Broker create(String storeDir, Map<String, String> config) {
                return new ZooKeeperBroker(storeDir, HighlyAvailableGraphDatabase.getMachineIdFromConfig(config), HighlyAvailableGraphDatabase.getZooKeeperServersFromConfig(config), HighlyAvailableGraphDatabase.getHaServerFromConfig(config), HighlyAvailableGraphDatabase.this);
            }
        };
    }

    private static String getHaServerFromConfig(Map<?, ?> config) {
        return (String)config.get(CONFIG_KEY_HA_SERVER);
    }

    private static String getZooKeeperServersFromConfig(Map<String, String> config) {
        return config.get(CONFIG_KEY_HA_ZOO_KEEPER_SERVERS);
    }

    private static int getMachineIdFromConfig(Map<String, String> config) {
        return Integer.parseInt(config.get(CONFIG_KEY_HA_MACHINE_ID));
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void pullUpdates() {
        try {
            if (this.masterServer == null) {
                this.receive(((Master)this.broker.getMaster().first()).pullUpdates(this.getSlaveContext(-1)));
            }
        }
        catch (ZooKeeperException e) {
            this.newMaster(null, e);
            throw e;
        }
        catch (HaCommunicationException e) {
            this.newMaster(null, e);
            throw e;
        }
    }

    private void updateTime() {
        this.updateTime = System.currentTimeMillis();
    }

    long lastUpdateTime() {
        return this.updateTime;
    }

    public Config getConfig() {
        return this.localGraph().getConfig();
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    public <T> T getManagementBean(Class<T> type) {
        return (T)this.localGraph().getManagementBean(type);
    }

    protected synchronized void reevaluateMyself(Pair<Master, Machine> master) {
        if (master == null) {
            master = this.broker.getMasterReally();
        }
        boolean restarted = false;
        boolean iAmCurrentlyMaster = this.masterServer != null;
        this.msgLog.logMessage("ReevaluateMyself: machineId=" + this.machineId + " with master[" + master + "] (I am master=" + iAmCurrentlyMaster + ")");
        if (((Machine)master.other()).getMachineId() == this.machineId) {
            if (this.localGraph == null || !iAmCurrentlyMaster) {
                this.internalShutdown();
                this.startAsMaster();
                restarted = true;
            }
            this.broker.rebindMaster();
        } else {
            if (this.localGraph == null || iAmCurrentlyMaster) {
                this.internalShutdown();
                this.startAsSlave();
                restarted = true;
            } else {
                ((SlaveIdGenerator.SlaveIdGeneratorFactory)this.getConfig().getIdGeneratorFactory()).forgetIdAllocationsFromMaster();
            }
            this.tryToEnsureIAmNotABrokenMachine(this.broker.getMaster());
        }
        if (restarted) {
            this.broker.setConnectionInformation(this.localGraph.getKernelData());
            for (TransactionEventHandler<?> transactionEventHandler : this.transactionEventHandlers) {
                this.localGraph().registerTransactionEventHandler(transactionEventHandler);
            }
            for (KernelEventHandler kernelEventHandler : this.kernelEventHandlers) {
                this.localGraph().registerKernelEventHandler(kernelEventHandler);
            }
        }
    }

    private void startAsSlave() {
        this.msgLog.logMessage("Starting[" + this.machineId + "] as slave", true);
        this.localGraph = new EmbeddedGraphDbImpl(this.storeDir, this.config, (GraphDatabaseService)this, (LockManagerFactory)new SlaveLockManager.SlaveLockManagerFactory(this.broker, this), (IdGeneratorFactory)new SlaveIdGenerator.SlaveIdGeneratorFactory(this.broker, this), (RelationshipTypeCreator)new SlaveRelationshipTypeCreator(this.broker, this), (TxIdGeneratorFactory)new SlaveTxIdGenerator.SlaveTxIdGeneratorFactory(this.broker, this), (TxFinishHook)new SlaveTxRollbackHook(this.broker, this), (LastCommittedTxIdSetter)new ZooKeeperLastCommittedTxIdSetter(this.broker));
        this.instantiateAutoUpdatePullerIfConfigSaysSo();
        this.msgLog.logMessage("Started as slave", true);
    }

    private void startAsMaster() {
        this.msgLog.logMessage("Starting[" + this.machineId + "] as master", true);
        this.localGraph = new EmbeddedGraphDbImpl(this.storeDir, this.config, (GraphDatabaseService)this, CommonFactories.defaultLockManagerFactory(), (IdGeneratorFactory)new MasterIdGeneratorFactory(), CommonFactories.defaultRelationshipTypeCreator(), (TxIdGeneratorFactory)new MasterTxIdGenerator.MasterTxIdGeneratorFactory(this.broker), CommonFactories.defaultTxFinishHook(), (LastCommittedTxIdSetter)new ZooKeeperLastCommittedTxIdSetter(this.broker));
        this.masterServer = (MasterServer)this.broker.instantiateMasterServer(this);
        this.msgLog.logMessage("Started as master", true);
    }

    private void tryToEnsureIAmNotABrokenMachine(Pair<Master, Machine> master) {
        try {
            int masterForMastersHighestCommonTxId;
            long myLastCommittedTx;
            long highestCommonTxId;
            if (((Machine)master.other()).getMachineId() == this.machineId) {
                return;
            }
            XaDataSource nioneoDataSource = this.getConfig().getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
            int masterForMyHighestCommonTxId = nioneoDataSource.getMasterForCommittedTx(highestCommonTxId = Math.min(myLastCommittedTx = nioneoDataSource.getLastCommittedTxId(), ((Machine)master.other()).getLastCommittedTxId()));
            if (masterForMyHighestCommonTxId == (masterForMastersHighestCommonTxId = ((Master)master.first()).getMasterIdForCommittedTx(highestCommonTxId))) {
                this.msgLog.logMessage("Master id for last committed tx ok with highestCommonTxId=" + highestCommonTxId + " with masterId=" + masterForMyHighestCommonTxId, true);
                return;
            }
            String msg = "Broken store, my last committed tx,machineId[" + myLastCommittedTx + "," + masterForMyHighestCommonTxId + "] but master says machine id for that txId is " + masterForMastersHighestCommonTxId;
            this.msgLog.logMessage(msg, true);
            BranchedDataException exception = new BranchedDataException(msg);
            this.shutdown(exception);
            throw exception;
        }
        catch (IOException e) {
            this.shutdown(new RuntimeException(e));
            throw new RuntimeException(e);
        }
    }

    private boolean recreateDbSomehow() {
        throw new UnsupportedOperationException();
    }

    private void instantiateAutoUpdatePullerIfConfigSaysSo() {
        String pullInterval = this.config.get(CONFIG_KEY_HA_PULL_INTERVAL);
        if (pullInterval != null) {
            long timeMillis = TimeUtil.parseTimeMillis(pullInterval);
            this.updatePuller = new ScheduledThreadPoolExecutor(1);
            this.updatePuller.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        HighlyAvailableGraphDatabase.this.pullUpdates();
                    }
                    catch (Exception e) {
                        HighlyAvailableGraphDatabase.this.msgLog.logMessage("Pull updates failed", (Throwable)e);
                    }
                }
            }, timeMillis, timeMillis, TimeUnit.MILLISECONDS);
        }
    }

    public Transaction beginTx() {
        return this.localGraph().beginTx();
    }

    public Node createNode() {
        return this.localGraph().createNode();
    }

    public boolean enableRemoteShell() {
        return this.localGraph().enableRemoteShell();
    }

    public boolean enableRemoteShell(Map<String, Serializable> initialProperties) {
        return this.localGraph().enableRemoteShell(initialProperties);
    }

    public Iterable<Node> getAllNodes() {
        return this.localGraph().getAllNodes();
    }

    public Node getNodeById(long id) {
        return this.localGraph().getNodeById(id);
    }

    public Node getReferenceNode() {
        return this.localGraph().getReferenceNode();
    }

    public Relationship getRelationshipById(long id) {
        return this.localGraph().getRelationshipById(id);
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return this.localGraph().getRelationshipTypes();
    }

    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        this.kernelEventHandlers.add(handler);
        return this.localGraph().registerKernelEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        this.transactionEventHandlers.add(handler);
        return this.localGraph().registerTransactionEventHandler(handler);
    }

    public synchronized void internalShutdown() {
        this.msgLog.logMessage("Internal shutdown of HA db[" + this.machineId + "] reference=" + this, true);
        if (this.updatePuller != null) {
            this.msgLog.logMessage("Internal shutdown updatePuller", true);
            this.updatePuller.shutdown();
            this.msgLog.logMessage("Internal shutdown updatePuller DONE", true);
            this.updatePuller = null;
        }
        if (this.masterServer != null) {
            this.msgLog.logMessage("Internal shutdown masterServer", true);
            this.masterServer.shutdown();
            this.msgLog.logMessage("Internal shutdown masterServer DONE", true);
            this.masterServer = null;
        }
        if (this.localGraph != null) {
            this.msgLog.logMessage("Internal shutdown localGraph", true);
            this.localGraph.shutdown();
            this.msgLog.logMessage("Internal shutdown localGraph DONE", true);
            this.localGraph = null;
        }
    }

    public synchronized void shutdown(RuntimeException cause) {
        if (this.causeOfShutdown != null) {
            return;
        }
        this.causeOfShutdown = cause;
        this.msgLog.logMessage("Shutdown[" + this.machineId + "], " + this, true);
        if (this.broker != null) {
            this.broker.shutdown();
        }
        this.internalShutdown();
    }

    public synchronized void shutdown() {
        this.shutdown(new IllegalStateException());
    }

    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.localGraph().unregisterKernelEventHandler(handler);
    }

    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.localGraph().unregisterTransactionEventHandler(handler);
    }

    @Override
    public SlaveContext getSlaveContext(int eventIdentifier) {
        XaDataSourceManager localDataSourceManager = this.getConfig().getTxModule().getXaDataSourceManager();
        Collection dataSources = localDataSourceManager.getAllRegisteredDataSources();
        Pair[] txs = new Pair[dataSources.size()];
        int i = 0;
        for (XaDataSource dataSource : dataSources) {
            txs[i++] = new Pair((Object)dataSource.getName(), (Object)dataSource.getLastCommittedTxId());
        }
        return new SlaveContext(this.machineId, eventIdentifier, txs);
    }

    @Override
    public <T> T receive(Response<T> response) {
        try {
            XaDataSourceManager localDataSourceManager = this.getConfig().getTxModule().getXaDataSourceManager();
            for (Pair<String, TransactionStream> streams : response.transactions().getStreams()) {
                String resourceName = (String)streams.first();
                XaDataSource dataSource = localDataSourceManager.getXaDataSource(resourceName);
                for (Pair<Long, ReadableByteChannel> channel : ((TransactionStream)streams.other()).getChannels()) {
                    dataSource.applyCommittedTransaction(((Long)channel.first()).longValue(), (ReadableByteChannel)channel.other());
                    ((ReadableByteChannel)channel.other()).close();
                }
            }
            this.updateTime();
            return response.response();
        }
        catch (IOException e) {
            this.newMaster(this.broker.getMaster(), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void newMaster(Pair<Master, Machine> master, Exception e) {
        try {
            this.msgLog.logMessage("newMaster(" + master + ") called", (Throwable)e, true);
            this.reevaluateMyself(master);
        }
        catch (ZooKeeperException ee) {
            ee.printStackTrace();
        }
        catch (HaCommunicationException ee) {
            ee.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.msgLog.logMessage("Reevaluation ended in unknown exception " + t + " so shutting down", true);
            this.shutdown(t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t));
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    protected MasterServer getMasterServerIfMaster() {
        return this.masterServer;
    }

    int getMachineId() {
        return this.machineId;
    }

    public boolean isMaster() {
        return this.broker.iAmMaster();
    }

    public boolean isReadOnly() {
        return false;
    }

    public IndexManager index() {
        return this.localGraph().index();
    }
}

