/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.LockStatus;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.MasterServer;
import org.neo4j.kernel.ha.Response;
import org.neo4j.kernel.ha.SlaveContext;
import org.neo4j.kernel.ha.TransactionStream;
import org.neo4j.kernel.ha.TransactionStreams;
import org.neo4j.kernel.impl.nioneo.store.IdRange;

public abstract class CommunicationProtocol {
    public static final int PORT = 8901;
    private static final int MEGA = 0x100000;
    static final int MAX_FRAME_LENGTH = 0x1000000;
    static final ObjectSerializer<Integer> INTEGER_SERIALIZER = new ObjectSerializer<Integer>(){

        @Override
        public void write(Integer responseObject, ChannelBuffer result) throws IOException {
            result.writeInt(responseObject.intValue());
        }
    };
    static final ObjectSerializer<Long> LONG_SERIALIZER = new ObjectSerializer<Long>(){

        @Override
        public void write(Long responseObject, ChannelBuffer result) throws IOException {
            result.writeLong(responseObject.longValue());
        }
    };
    static final ObjectSerializer<Void> VOID_SERIALIZER = new ObjectSerializer<Void>(){

        @Override
        public void write(Void responseObject, ChannelBuffer result) throws IOException {
        }
    };
    static final ObjectSerializer<LockResult> LOCK_SERIALIZER = new ObjectSerializer<LockResult>(){

        @Override
        public void write(LockResult responseObject, ChannelBuffer result) throws IOException {
            result.writeByte(responseObject.getStatus().ordinal());
            if (responseObject.getStatus().hasMessage()) {
                CommunicationProtocol.writeString(result, responseObject.getDeadlockMessage());
            }
        }
    };
    protected static final Deserializer<LockResult> LOCK_RESULT_DESERIALIZER = new Deserializer<LockResult>(){

        @Override
        public LockResult read(ChannelBuffer buffer) throws IOException {
            LockStatus status = LockStatus.values()[buffer.readByte()];
            return status.hasMessage() ? new LockResult(CommunicationProtocol.readString(buffer)) : new LockResult(status);
        }
    };
    protected static final Deserializer<Integer> INTEGER_DESERIALIZER = new Deserializer<Integer>(){

        @Override
        public Integer read(ChannelBuffer buffer) throws IOException {
            return buffer.readInt();
        }
    };
    protected static final Deserializer<Void> VOID_DESERIALIZER = new Deserializer<Void>(){

        @Override
        public Void read(ChannelBuffer buffer) throws IOException {
            return null;
        }
    };
    protected static final Serializer EMPTY_SERIALIZER = new Serializer(){

        @Override
        public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
        }
    };

    protected static ChannelBuffer handleRequest(Master realMaster, ChannelBuffer buffer, Channel channel, MasterServer server) throws IOException {
        RequestType type = RequestType.values()[buffer.readByte()];
        SlaveContext context = null;
        if (type.includesSlaveContext()) {
            context = CommunicationProtocol.readSlaveContext(buffer);
        }
        Pair<ChannelBuffer, ByteBuffer> targetBuffers = server.mapSlave(channel, context);
        ((ChannelBuffer)targetBuffers.first()).clear();
        Response response = type.caller.callMaster(realMaster, context, buffer);
        type.serializer.write(response.response(), (ChannelBuffer)targetBuffers.first());
        if (type.includesSlaveContext()) {
            CommunicationProtocol.writeTransactionStreams(response.transactions(), (ChannelBuffer)targetBuffers.first(), (ByteBuffer)targetBuffers.other());
        }
        if (type == RequestType.FINISH || type == RequestType.PULL_UPDATES) {
            server.unmapSlave(channel, context);
        }
        return (ChannelBuffer)targetBuffers.first();
    }

    private static <T> void writeTransactionStreams(TransactionStreams txStreams, ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
        Collection<Pair<String, TransactionStream>> streams = txStreams.getStreams();
        buffer.writeByte(streams.size());
        for (Pair<String, TransactionStream> streamPair : streams) {
            CommunicationProtocol.writeString(buffer, (String)streamPair.first());
            CommunicationProtocol.writeTransactionStream(buffer, readBuffer, (TransactionStream)streamPair.other());
        }
        txStreams.close();
    }

    protected static TransactionStreams readTransactionStreams(ChannelBuffer buffer) {
        TransactionStreams result = new TransactionStreams();
        for (int count = buffer.readByte(); count > 0; --count) {
            String resource = CommunicationProtocol.readString(buffer);
            TransactionStream stream = CommunicationProtocol.readTransactionStream(buffer);
            result.add(resource, stream);
        }
        return result;
    }

    protected static void writeTransactionStream(ChannelBuffer dest, ByteBuffer readBuffer, TransactionStream transactionStream) throws IOException {
        Collection<Pair<Long, ReadableByteChannel>> channels = transactionStream.getChannels();
        dest.writeInt(channels.size());
        for (Pair<Long, ReadableByteChannel> channel : channels) {
            dest.writeLong(((Long)channel.first()).longValue());
            ByteData data = new ByteData((ReadableByteChannel)channel.other(), readBuffer);
            dest.writeInt(data.size());
            for (byte[] bytes : data) {
                dest.writeBytes(bytes);
            }
            ((ReadableByteChannel)channel.other()).close();
        }
    }

    private static TransactionStream readTransactionStream(ChannelBuffer buffer) {
        ArrayList<Pair<Long, ReadableByteChannel>> channels = new ArrayList<Pair<Long, ReadableByteChannel>>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            long txId = buffer.readLong();
            byte[] data = new byte[buffer.readInt()];
            buffer.readBytes(data);
            ByteArrayChannel channel = new ByteArrayChannel(data);
            channels.add((Pair<Long, ReadableByteChannel>)new Pair((Object)txId, (Object)channel));
        }
        return new TransactionStream(channels);
    }

    protected static IdAllocation readIdAllocation(ChannelBuffer buffer) {
        int numberOfDefragIds = buffer.readInt();
        long[] defragIds = new long[numberOfDefragIds];
        for (int i = 0; i < numberOfDefragIds; ++i) {
            defragIds[i] = buffer.readLong();
        }
        long rangeStart = buffer.readLong();
        int rangeLength = buffer.readInt();
        long highId = buffer.readLong();
        long defragCount = buffer.readLong();
        return new IdAllocation(new IdRange(defragIds, rangeStart, rangeLength), highId, defragCount);
    }

    protected static void writeString(ChannelBuffer buffer, String name) {
        char[] chars = name.toCharArray();
        buffer.writeInt(chars.length);
        for (char ch : chars) {
            buffer.writeChar((int)ch);
        }
    }

    protected static String readString(ChannelBuffer buffer) {
        int length = buffer.readInt();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = buffer.readChar();
        }
        return new String(chars);
    }

    protected static void writeSlaveContext(ChannelBuffer buffer, SlaveContext context) {
        buffer.writeInt(context.machineId());
        buffer.writeInt(context.getEventIdentifier());
        Pair<String, Long>[] txs = context.lastAppliedTransactions();
        buffer.writeByte(txs.length);
        for (Pair<String, Long> tx : txs) {
            CommunicationProtocol.writeString(buffer, (String)tx.first());
            buffer.writeLong(((Long)tx.other()).longValue());
        }
    }

    private static SlaveContext readSlaveContext(ChannelBuffer buffer) {
        int machineId = buffer.readInt();
        int eventIdentifier = buffer.readInt();
        int txsSize = buffer.readByte();
        Pair[] lastAppliedTransactions = new Pair[txsSize];
        for (int i = 0; i < txsSize; ++i) {
            lastAppliedTransactions[i] = new Pair((Object)CommunicationProtocol.readString(buffer), (Object)buffer.readLong());
        }
        return new SlaveContext(machineId, eventIdentifier, lastAppliedTransactions);
    }

    protected static interface MasterCaller<T> {
        public Response<T> callMaster(Master var1, SlaveContext var2, ChannelBuffer var3);
    }

    protected static interface ObjectSerializer<T> {
        public void write(T var1, ChannelBuffer var2) throws IOException;
    }

    protected static interface Deserializer<T> {
        public T read(ChannelBuffer var1) throws IOException;
    }

    protected static interface Serializer {
        public void write(ChannelBuffer var1, ByteBuffer var2) throws IOException;
    }

    protected static class ByteData
    implements Iterable<byte[]> {
        private final Collection<byte[]> data;
        private final int size;

        ByteData(ReadableByteChannel channel, ByteBuffer readBuffer) throws IOException {
            int size = 0;
            int chunk = 0;
            LinkedList<byte[]> data = new LinkedList<byte[]>();
            while ((chunk = channel.read(readBuffer)) >= 0) {
                size += chunk;
                byte[] bytes = new byte[chunk];
                readBuffer.flip();
                readBuffer.get(bytes);
                readBuffer.clear();
                data.add(bytes);
            }
            this.data = data;
            this.size = size;
        }

        int size() {
            return this.size;
        }

        @Override
        public Iterator<byte[]> iterator() {
            return this.data.iterator();
        }
    }

    static abstract class AquireLockCall
    implements MasterCaller<LockResult> {
        AquireLockCall() {
        }

        @Override
        public Response<LockResult> callMaster(Master master, SlaveContext context, ChannelBuffer input) {
            long[] ids = new long[input.readInt()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = input.readLong();
            }
            return this.lock(master, context, ids);
        }

        abstract Response<LockResult> lock(Master var1, SlaveContext var2, long ... var3);
    }

    protected static class AcquireLockSerializer
    implements Serializer {
        private final long[] entities;

        AcquireLockSerializer(long ... entities) {
            this.entities = entities;
        }

        @Override
        public void write(ChannelBuffer buffer, ByteBuffer readBuffer) throws IOException {
            buffer.writeInt(this.entities.length);
            for (long entity : this.entities) {
                buffer.writeLong(entity);
            }
        }
    }

    private static class ByteArrayChannel
    implements ReadableByteChannel {
        private final byte[] data;
        private int pos;

        ByteArrayChannel(byte[] data) {
            this.data = data;
            this.pos = 0;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            if (this.pos >= this.data.length) {
                return -1;
            }
            int size = Math.min(this.data.length - this.pos, dst.limit() - dst.position());
            dst.put(this.data, this.pos, size);
            this.pos += size;
            return size;
        }

        @Override
        public void close() throws IOException {
            this.pos = -1;
        }

        @Override
        public boolean isOpen() {
            return this.pos > 0;
        }
    }

    public static enum RequestType {
        ALLOCATE_IDS(new MasterCaller<IdAllocation>(){

            @Override
            public Response<IdAllocation> callMaster(Master master, SlaveContext context, ChannelBuffer input) {
                IdType idType = IdType.values()[input.readByte()];
                return Response.wrapResponseObjectOnly(master.allocateIds(idType));
            }
        }, new ObjectSerializer<IdAllocation>(){

            @Override
            public void write(IdAllocation idAllocation, ChannelBuffer result) throws IOException {
                IdRange idRange = idAllocation.getIdRange();
                result.writeInt(idRange.getDefragIds().length);
                for (long id : idRange.getDefragIds()) {
                    result.writeLong(id);
                }
                result.writeLong(idRange.getRangeStart());
                result.writeInt(idRange.getRangeLength());
                result.writeLong(idAllocation.getHighestIdInUse());
                result.writeLong(idAllocation.getDefragCount());
            }
        }, false),
        CREATE_RELATIONSHIP_TYPE(new MasterCaller<Integer>(){

            @Override
            public Response<Integer> callMaster(Master master, SlaveContext context, ChannelBuffer input) {
                return master.createRelationshipType(context, CommunicationProtocol.readString(input));
            }
        }, INTEGER_SERIALIZER),
        ACQUIRE_NODE_WRITE_LOCK(new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireNodeWriteLock(context, ids);
            }
        }, LOCK_SERIALIZER),
        ACQUIRE_NODE_READ_LOCK(new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireNodeReadLock(context, ids);
            }
        }, LOCK_SERIALIZER),
        ACQUIRE_RELATIONSHIP_WRITE_LOCK(new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireRelationshipWriteLock(context, ids);
            }
        }, LOCK_SERIALIZER),
        ACQUIRE_RELATIONSHIP_READ_LOCK(new AquireLockCall(){

            @Override
            Response<LockResult> lock(Master master, SlaveContext context, long ... ids) {
                return master.acquireRelationshipReadLock(context, ids);
            }
        }, LOCK_SERIALIZER),
        COMMIT(new MasterCaller<Long>(){

            @Override
            public Response<Long> callMaster(Master master, SlaveContext context, ChannelBuffer input) {
                String resource = CommunicationProtocol.readString(input);
                TransactionStream transactionStream = CommunicationProtocol.readTransactionStream(input);
                return master.commitSingleResourceTransaction(context, resource, transactionStream);
            }
        }, LONG_SERIALIZER),
        PULL_UPDATES(new MasterCaller<Void>(){

            @Override
            public Response<Void> callMaster(Master master, SlaveContext context, ChannelBuffer input) {
                return master.pullUpdates(context);
            }
        }, VOID_SERIALIZER),
        FINISH(new MasterCaller<Void>(){

            @Override
            public Response<Void> callMaster(Master master, SlaveContext context, ChannelBuffer input) {
                return master.finishTransaction(context);
            }
        }, VOID_SERIALIZER),
        GET_MASTER_ID_FOR_TX(new MasterCaller<Integer>(){

            @Override
            public Response<Integer> callMaster(Master master, SlaveContext context, ChannelBuffer input) {
                int masterId = master.getMasterIdForCommittedTx(input.readLong());
                return Response.wrapResponseObjectOnly(masterId);
            }
        }, INTEGER_SERIALIZER, false);

        final MasterCaller caller;
        final ObjectSerializer serializer;
        private final boolean includesSlaveContext;

        private <T> RequestType(MasterCaller<T> caller, ObjectSerializer<T> serializer, boolean includesSlaveContext) {
            this.caller = caller;
            this.serializer = serializer;
            this.includesSlaveContext = includesSlaveContext;
        }

        private <T> RequestType(MasterCaller<T> caller, ObjectSerializer<T> serializer) {
            this(caller, serializer, true);
        }

        public boolean includesSlaveContext() {
            return this.includesSlaveContext;
        }
    }
}

