/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.ha;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.Config;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.ha.FailedResponse;
import org.neo4j.kernel.ha.IdAllocation;
import org.neo4j.kernel.ha.LockResult;
import org.neo4j.kernel.ha.LockStatus;
import org.neo4j.kernel.ha.LockableNode;
import org.neo4j.kernel.ha.LockableRelationship;
import org.neo4j.kernel.ha.Master;
import org.neo4j.kernel.ha.Response;
import org.neo4j.kernel.ha.SlaveContext;
import org.neo4j.kernel.ha.TransactionStream;
import org.neo4j.kernel.ha.TransactionStreams;
import org.neo4j.kernel.impl.core.LockReleaser;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.transaction.LockManager;
import org.neo4j.kernel.impl.transaction.LockType;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;

public class MasterImpl
implements Master {
    private static final int ID_GRAB_SIZE = 1000;
    private static final Predicate<Long> ALL = new Predicate<Long>(){

        public boolean accept(Long item) {
            return true;
        }
    };
    private final GraphDatabaseService graphDb;
    private final Config graphDbConfig;
    private final Map<SlaveContext, Transaction> transactions = Collections.synchronizedMap(new HashMap());
    private static LockGrabber READ_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, LockReleaser lockReleaser, Object entity) {
            lockManager.getReadLock(entity);
            lockReleaser.addLockToTransaction(entity, LockType.READ);
        }
    };
    private static LockGrabber WRITE_LOCK_GRABBER = new LockGrabber(){

        @Override
        public void grab(LockManager lockManager, LockReleaser lockReleaser, Object entity) {
            lockManager.getWriteLock(entity);
            lockReleaser.addLockToTransaction(entity, LockType.WRITE);
        }
    };

    public MasterImpl(GraphDatabaseService db) {
        this.graphDb = db;
        this.graphDbConfig = ((AbstractGraphDatabase)db).getConfig();
    }

    public GraphDatabaseService getGraphDb() {
        return this.graphDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends PropertyContainer> Response<LockResult> acquireLock(SlaveContext context, LockGrabber lockGrabber, T ... entities) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context);
        try {
            LockManager lockManager = this.graphDbConfig.getLockManager();
            LockReleaser lockReleaser = this.graphDbConfig.getLockReleaser();
            for (T entity : entities) {
                lockGrabber.grab(lockManager, lockReleaser, entity);
            }
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.OK_LOCKED), ALL);
            return response;
        }
        catch (DeadlockDetectedException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(e.getMessage()), ALL);
            return response;
        }
        catch (IllegalResourceException e) {
            Response<LockResult> response = this.packResponse(context, new LockResult(LockStatus.NOT_LOCKED), ALL);
            return response;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    private Transaction getTx(SlaveContext txId) {
        return this.transactions.get(txId);
    }

    private Transaction beginTx(SlaveContext txId) {
        try {
            TransactionManager txManager = this.graphDbConfig.getTxModule().getTxManager();
            txManager.begin();
            Transaction tx = txManager.getTransaction();
            this.transactions.put(txId, tx);
            return tx;
        }
        catch (NotSupportedException e) {
            throw new RuntimeException(e);
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    Transaction suspendOtherAndResumeThis(SlaveContext txId) {
        try {
            TransactionManager txManager = this.graphDbConfig.getTxModule().getTxManager();
            Transaction otherTx = txManager.getTransaction();
            Transaction transaction = this.getTx(txId);
            if (otherTx != null && otherTx == transaction) {
                return null;
            }
            if (otherTx != null) {
                txManager.suspend();
            }
            if (transaction == null) {
                this.beginTx(txId);
            } else {
                txManager.resume(transaction);
            }
            return otherTx;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    void suspendThisAndResumeOther(Transaction otherTx, SlaveContext txId) {
        try {
            TransactionManager txManager = this.graphDbConfig.getTxModule().getTxManager();
            txManager.suspend();
            if (otherTx != null) {
                txManager.resume(otherTx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    void rollbackThisAndResumeOther(Transaction otherTx, SlaveContext txId) {
        try {
            TransactionManager txManager = this.graphDbConfig.getTxModule().getTxManager();
            txManager.rollback();
            this.transactions.remove(txId);
            if (otherTx != null) {
                txManager.resume(otherTx);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response<LockResult> acquireNodeReadLock(SlaveContext context, long ... nodes) {
        return this.acquireLock(context, READ_LOCK_GRABBER, (PropertyContainer[])this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireNodeWriteLock(SlaveContext context, long ... nodes) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, (PropertyContainer[])this.nodesById(nodes));
    }

    @Override
    public Response<LockResult> acquireRelationshipReadLock(SlaveContext context, long ... relationships) {
        return this.acquireLock(context, READ_LOCK_GRABBER, (PropertyContainer[])this.relationshipsById(relationships));
    }

    @Override
    public Response<LockResult> acquireRelationshipWriteLock(SlaveContext context, long ... relationships) {
        return this.acquireLock(context, WRITE_LOCK_GRABBER, (PropertyContainer[])this.relationshipsById(relationships));
    }

    private Node[] nodesById(long[] ids) {
        Node[] result = new Node[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableNode((int)ids[i]);
        }
        return result;
    }

    private Relationship[] relationshipsById(long[] ids) {
        Relationship[] result = new Relationship[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = new LockableRelationship((int)ids[i]);
        }
        return result;
    }

    @Override
    public IdAllocation allocateIds(IdType idType) {
        IdGenerator generator = this.graphDbConfig.getIdGeneratorFactory().get(idType);
        return new IdAllocation(generator.nextIdBatch(1000), generator.getHighId(), generator.getDefragCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response<Long> commitSingleResourceTransaction(SlaveContext context, String resource, TransactionStream transactionStream) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context);
        try {
            XaDataSource dataSource = this.graphDbConfig.getTxModule().getXaDataSourceManager().getXaDataSource(resource);
            final long txId = dataSource.applyPreparedTransaction((ReadableByteChannel)transactionStream.getChannels().iterator().next().other());
            Predicate<Long> notThisTx = new Predicate<Long>(){

                public boolean accept(Long item) {
                    return item != txId;
                }
            };
            Response<Long> response = this.packResponse(context, txId, notThisTx);
            return response;
        }
        catch (IOException e) {
            e.printStackTrace();
            FailedResponse<Long> failedResponse = new FailedResponse<Long>();
            return failedResponse;
        }
        finally {
            this.suspendThisAndResumeOther(otherTx, context);
        }
    }

    @Override
    public Response<Void> finishTransaction(SlaveContext context) {
        Transaction otherTx = this.suspendOtherAndResumeThis(context);
        this.rollbackThisAndResumeOther(otherTx, context);
        return this.packResponse(context, null, ALL);
    }

    @Override
    public Response<Integer> createRelationshipType(SlaveContext context, String name) {
        Integer id = this.graphDbConfig.getRelationshipTypeHolder().getIdFor(name);
        if (id != null) {
            return this.packResponse(context, id, ALL);
        }
        id = this.graphDbConfig.getRelationshipTypeCreator().getOrCreate(this.graphDbConfig.getTxModule().getTxManager(), this.graphDbConfig.getIdGeneratorModule().getIdGenerator(), this.graphDbConfig.getPersistenceModule().getPersistenceManager(), this.graphDbConfig.getRelationshipTypeHolder(), name);
        return this.packResponse(context, id, ALL);
    }

    private <T> Response<T> packResponse(SlaveContext context, T response, Predicate<Long> filter) {
        try {
            TransactionStreams streams = new TransactionStreams();
            for (Pair<String, Long> txEntry : context.lastAppliedTransactions()) {
                String resourceName = (String)txEntry.first();
                XaDataSource dataSource = this.graphDbConfig.getTxModule().getXaDataSourceManager().getXaDataSource(resourceName);
                if (dataSource == null) {
                    throw new RuntimeException("No data source '" + resourceName + "' found");
                }
                long masterLastTx = dataSource.getLastCommittedTxId();
                ArrayList<Pair<Long, ReadableByteChannel>> channels = new ArrayList<Pair<Long, ReadableByteChannel>>();
                for (long txId = (Long)txEntry.other() + 1L; txId <= masterLastTx; ++txId) {
                    if (!filter.accept((Object)txId)) continue;
                    channels.add((Pair<Long, ReadableByteChannel>)new Pair((Object)txId, (Object)dataSource.getCommittedTransaction(txId)));
                }
                streams.add(resourceName, new TransactionStream(channels));
            }
            return new Response<T>(response, streams);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new FailedResponse();
        }
    }

    @Override
    public Response<Void> pullUpdates(SlaveContext context) {
        return this.packResponse(context, null, ALL);
    }

    @Override
    public int getMasterIdForCommittedTx(long txId) {
        try {
            XaDataSource nioneoDataSource = this.graphDbConfig.getTxModule().getXaDataSourceManager().getXaDataSource("nioneodb");
            return nioneoDataSource.getMasterForCommittedTx(txId);
        }
        catch (IOException e) {
            return -1;
        }
    }

    public Map<Integer, Collection<SlaveContext>> getOngoingTransactions() {
        HashMap<Integer, Collection<SlaveContext>> result = new HashMap<Integer, Collection<SlaveContext>>();
        for (SlaveContext context : this.transactions.keySet()) {
            ArrayList<SlaveContext> txs = (ArrayList<SlaveContext>)result.get(context.machineId());
            if (txs == null) {
                txs = new ArrayList<SlaveContext>();
                result.put(context.machineId(), txs);
            }
            txs.add(context);
        }
        return result;
    }

    private static interface LockGrabber {
        public void grab(LockManager var1, LockReleaser var2, Object var3);
    }
}

